/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.swing;

import es.pablo.jee.ejb.jms.PersistenceEvent;
import es.pablo.jee.ejb.jms.Refreshable;
import es.pablo.jee.ejb.jms.Refresher;
import es.pablo.jee.ejb.swing.EntityEditor;
import es.pablo.jee.ejb.swing.EntityTableModel;
import es.pablo.jee.entity.LobFileRef;
import es.pablo.servlet.FileServlet;
import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DbFileRenderer
extends DefaultTableCellRenderer.UIResource {
    public static String baseURL = "";
    private boolean showText;
    private int maxSize = 150;
    private String property;
    private EntityEditor ee;
    private boolean isImage = true;
    private static Map<Object, JLabel> cache = Collections.synchronizedMap(new HashMap());
    public final Stack<StackObject> fileStack = new Stack();

    public DbFileRenderer(String property, EntityEditor ee, int scaled) throws Exception {
        this.maxSize = scaled;
        this.ee = ee;
        this.property = property;
        super.setHorizontalAlignment(0);
        this.startLoaderThread();
    }

    public static void flushCache() {
        cache = Collections.synchronizedMap(new HashMap());
    }

    private void startLoaderThread() {
        Thread loaderThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    StackObject so = DbFileRenderer.this.getFromStack();
                                    if (so != null) {
                                        JLabel label2 = new JLabel();
                                        URL url = new URL(baseURL + FileServlet.getURL(((DbFileRenderer)DbFileRenderer.this).ee.emd.clazz, so.pk, DbFileRenderer.this.property, DbFileRenderer.this.maxSize) + "&rs" + Math.random() + "=" + Math.random());
                                        ImageIcon icon = new ImageIcon(url);
                                        label2.setIcon(icon);
                                        label2.setText(so.lfr.name);
                                        label2.setHorizontalTextPosition(0);
                                        label2.setVerticalTextPosition(0);
                                        String cacheKey = ((DbFileRenderer)DbFileRenderer.this).ee.emd.clazz + " " + DbFileRenderer.this.property + " " + so.pk;
                                        cache.put(cacheKey, label2);
                                        DbFileRenderer.this.ee.getEntityTable().repaint();
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        loaderThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToStack(StackObject lfr) {
        Stack<StackObject> stack = this.fileStack;
        synchronized (stack) {
            this.fileStack.push(lfr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackObject getFromStack() {
        Stack<StackObject> stack = this.fileStack;
        synchronized (stack) {
            try {
                return this.fileStack.pop();
            }
            catch (EmptyStackException e) {
                return null;
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (EntityTableModel.LOADING.equals(value)) {
            this.setText("" + value);
            this.setIcon(null);
            return this;
        }
        Object pk = this.ee.getPk(row);
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        String cacheKey = this.ee.emd.clazz + " " + this.property + " " + pk;
        JLabel label = cache.get(cacheKey);
        if (label == null) {
            label = new JLabel();
            if (value == null) {
                label.setIcon(null);
                label.setText("");
            } else if (value instanceof LobFileRef) {
                try {
                    LobFileRef lfr = (LobFileRef)value;
                    label.setText("Cargando: " + lfr.name);
                    if (this.isImage || lfr.contentType != null && lfr.contentType.startsWith("image")) {
                        this.addToStack(new StackObject(lfr, pk));
                    }
                }
                catch (Throwable t) {
                    System.err.println(t.toString());
                    label.setIcon(null);
                    label.setText("Error: " + t.getMessage());
                }
            }
            cache.put(cacheKey, label);
        }
        this.setIcon(label.getIcon());
        this.setText(label.getText());
        if (this.getIcon() != null) {
            int h;
            int n = h = this.getIcon().getIconHeight() < 15 ? 15 : this.getIcon().getIconHeight();
            if (table.getRowHeight(row) < h) {
                table.setRowHeight(row, h);
            }
        }
        return this;
    }

    static {
        try {
            Refresher.getInstance().subscribeToAll(new CacheRefresher());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class StackObject {
        LobFileRef lfr;
        Object pk;

        public StackObject(LobFileRef lfr, Object pk) {
            this.lfr = lfr;
            this.pk = pk;
        }
    }

    private static class CacheRefresher
    implements Refreshable {
        private CacheRefresher() {
        }

        @Override
        public void refresh(PersistenceEvent pe) throws Exception {
            if (pe != null) {
                String ss = "" + pe.clazz;
                String s2 = "" + pe.pk;
                for (Object o : new ArrayList(cache.keySet())) {
                    String s = (String)o;
                    if (s == null || !s.startsWith(ss) || !s.endsWith(s2)) continue;
                    cache.remove(s);
                    break;
                }
            }
        }
    }
}

