/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RedirectorFilter
implements Filter {
    private static final boolean debug = true;
    private FilterConfig filterConfig = null;
    private Map<String, ActiveRequest> requestsBeingProcessed = Collections.synchronizedMap(new HashMap());
    private Timer activeRequestsDebugger = new Timer(true);

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        req.setCharacterEncoding("UTF-8");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String original = request.getRequestURL().toString();
        String target = RedirectorFilter.normalize(request);
        String uuid = UUID.randomUUID().toString();
        if (target == null) {
            this.requestsBeingProcessed.put(uuid, new ActiveRequest(original + "?" + request.getQueryString()));
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            this.requestsBeingProcessed.put(uuid, new ActiveRequest(target + "?" + request.getQueryString() + "(redirect)"));
            response.sendRedirect(target);
        }
        this.requestsBeingProcessed.remove(uuid);
    }

    public static String normalize(HttpServletRequest request) {
        String original = request.getRequestURL().toString();
        if (original.contains("anahatait")) {
            return null;
        }
        String target = original.replace(".com", ".es").replace("www.", "");
        target = target.replace("/farmaciaonline", "");
        if (!((target = target.replace("/faces", "")).contains("UrlOk.") || target.contains("UrlKo.") || target.contains("UrlNotificacion."))) {
            target = target.replace("/Farmacia-war", "/");
        }
        target = target.replace(".jsp", ".jsf");
        target = target.replace("/DetalleProducto", "/DetProd");
        target = target.replace("/DetProd.jsp", "/DetProd.jsf");
        target = target.replace("/Catalogo.jsp", "/Catalogo.jsf");
        if (request.getParameterMap().isEmpty()) {
            if (target.contains("DetProd.jsf")) {
                target = target.replace("DetProd.jsf", "");
            }
            if (target.contains("DetProd.jsp")) {
                target = target.replace("DetProd.jsp", "");
            }
        }
        if (target.equals(original)) {
            return null;
        }
        if (request.getQueryString() != null) {
            target = target + "?" + request.getQueryString();
        }
        target = target.replace("//", "/");
        target = target.replace("//", "/");
        target = target.replace("//", "/");
        target = target.replace("http:/", "http://");
        return target;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.debugActiveRequests();
        this.activeRequestsDebugger.cancel();
    }

    private void debugActiveRequests() {
        for (Map.Entry<String, ActiveRequest> entry : this.requestsBeingProcessed.entrySet()) {
        }
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        if (filterConfig != null) {
            this.log("RedirectorFilter:Initializing filter");
        }
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                HashSet hs = new HashSet(RedirectorFilter.this.requestsBeingProcessed.values());
                RedirectorFilter.this.debugActiveRequests();
            }
        };
        this.activeRequestsDebugger.scheduleAtFixedRate(tt, 7000L, 30000L);
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "RedirectorFilter()";
        }
        StringBuffer sb = new StringBuffer("RedirectorFilter(");
        sb.append(this.filterConfig);
        sb.append(")");
        return sb.toString();
    }

    private void sendProcessingError(Throwable t, ServletResponse response) {
        String stackTrace = RedirectorFilter.getStackTrace(t);
        if (stackTrace != null && !stackTrace.equals("")) {
            try {
                response.setContentType("text/html");
                PrintStream ps = new PrintStream((OutputStream)response.getOutputStream());
                PrintWriter pw = new PrintWriter(ps);
                pw.print("<html>\n<head>\n<title>Error</title>\n</head>\n<body>\n");
                pw.print("<h1>The resource did not process correctly</h1>\n<pre>\n");
                pw.print(stackTrace);
                pw.print("</pre></body>\n</html>");
                pw.close();
                ps.close();
                response.getOutputStream().close();
            }
            catch (Exception ps) {}
        } else {
            try {
                PrintStream ps = new PrintStream((OutputStream)response.getOutputStream());
                t.printStackTrace(ps);
                ps.close();
                response.getOutputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getStackTrace(Throwable t) {
        String stackTrace = null;
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            sw.close();
            stackTrace = sw.getBuffer().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stackTrace;
    }

    public void log(String msg) {
        this.filterConfig.getServletContext().log(msg);
    }

    private static class ActiveRequest {
        Date date = new Date();
        String url;

        public ActiveRequest(String url) {
            this.url = url;
        }

        public String toString() {
            return "ActiveRequest {url=" + this.url + "} active for " + (System.currentTimeMillis() - this.date.getTime()) + " ms.";
        }
    }
}

