/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.servlet;

import es.pablo.jee.ejb.request.LocalFacade;
import es.pablo.jee.entity.Introspector;
import es.pablo.jee.entity.LobFile;
import es.pablo.servlet.WatermarkProvider;
import es.pablo.util.Util;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.ImageIcon;

public class FileServlet
extends HttpServlet {
    public static final String CLASS = "class";
    public static final String PK = "id";
    public static final String PROPERTY = "property";
    public static final String size = "size";
    public static final String FILE_NAME = "fileName";
    public static final Integer DEFAULT_SIZE = 150;
    public static final String DEFAULT_ALL = "default.all";
    public static final String DEFAULT = "default";
    public static final String WATERMARK = "watermark";
    public static final String WATERMARK_ALL = "watermark.all";
    public static final String WATERMARK_MIN_SIZE = "watermark.minSize";
    static Image logoImage = null;
    static ImageIcon logoImageIcon = null;
    static boolean logo = true;
    static Map<String, BufferedImage> cache = Collections.synchronizedMap(new HashMap());
    static Color c1 = new Color(0, 122, 255);
    static Color c2 = new Color(51, 153, 0);
    static Random r = new Random();
    LocalFacade facade;
    public Map defaultImages = new HashMap();
    public Map<String, String> waterMarks = new HashMap<String, String>();
    public int waterMarkMinSize = 200;
    GraphicsConfiguration gc = null;

    public static String getURL(Class c, Object pk, Object property) throws UnsupportedEncodingException {
        return FileServlet.getURL(c, pk, property, null);
    }

    public static String getURL(Class c, Object pk, Object property, Integer size) throws UnsupportedEncodingException {
        String s = "/FileServlet?class=" + c.getName() + "&" + URLEncoder.encode(PK, "UTF-8") + "=" + pk + "&" + PROPERTY + "=" + property;
        if (size != null && size != -1) {
            s = s + "&size=" + size;
        }
        return s;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            StringTokenizer st;
            String s = (String)e.nextElement();
            if (s.equals(DEFAULT_ALL)) {
                this.defaultImages.put(DEFAULT_ALL, config.getInitParameter(s));
                continue;
            }
            if (s.startsWith(DEFAULT)) {
                st = new StringTokenizer(s, ".");
                st.nextToken();
                this.defaultImages.put(st.nextToken() + "." + st.nextToken(), config.getInitParameter(s));
                continue;
            }
            if (s.equals(WATERMARK_MIN_SIZE)) {
                try {
                    this.waterMarkMinSize = Integer.parseInt(config.getInitParameter(s));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if (s.startsWith(WATERMARK_ALL)) {
                try {
                    this.waterMarks.put(WATERMARK_ALL, config.getInitParameter(s));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if (!s.startsWith(WATERMARK)) continue;
            try {
                st = new StringTokenizer(s, ".");
                st.nextToken();
                this.waterMarks.put(st.nextToken() + "." + st.nextToken(), config.getInitParameter(s));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void init() throws ServletException {
        this.facade = (LocalFacade)super.getServletContext().getAttribute("facade");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        this.gc = gs.getDefaultConfiguration();
    }

    protected void processRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        long ts;
        block22: {
            ts = System.currentTimeMillis();
            try {
                File f;
                String s = req.getParameter(CLASS);
                if (s == null) {
                    res.setContentType("text/plain");
                    res.getWriter().print("Error");
                    return;
                }
                boolean sendOriginalName = true;
                Class<?> c = Class.forName(s.trim());
                Object pk = Introspector.makePkFromString(c, req.getParameter(PK));
                String attribute = req.getParameter(PROPERTY);
                int scale = -1;
                try {
                    scale = new Integer(req.getParameter(size));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long ts2 = System.currentTimeMillis();
                Object o = this.facade.findLocalProperty(c, pk, attribute);
                LobFile lf = null;
                Object bArr = null;
                if (o instanceof LobFile) {
                    lf = (LobFile)o;
                } else if (o instanceof byte[]) {
                    lf = new LobFile();
                    lf.data = (byte[])o;
                    lf.name = c.getSimpleName() + "_" + pk + "_" + attribute;
                }
                if (lf != null && lf.contentType != null) {
                    res.setContentType(lf.contentType);
                }
                ts2 = System.currentTimeMillis() - ts2;
                boolean isImage = Introspector.getEntityMetaData(c).images.containsKey(attribute);
                if (isImage && (lf == null || lf.data == null || lf.data.length == 0) && (f = this.getNoImage(c, attribute)) != null) {
                    lf = new LobFile(f);
                }
                if (isImage && lf != null && lf.data != null && lf.data != null && lf.data.length > 0) {
                    BufferedImage bi = ImageIO.read(new ByteArrayInputStream(lf.data));
                    if (bi == null) {
                        bi = ImageIO.read(this.getNoImage(c, attribute));
                    }
                    float scaleFactor = Util.getScaledFactor(bi.getWidth(), bi.getHeight(), scale);
                    boolean waterMarked = !"false".equals(req.getParameter("wm"));
                    BufferedImage waterMark = null;
                    if (waterMarked) {
                        File waterMarkFile = this.getWaterMark(c, attribute);
                        BufferedImage bufferedImage = waterMark = waterMarkFile != null ? ImageIO.read(waterMarkFile) : null;
                        if (waterMark == null) {
                            WatermarkProvider provider = (WatermarkProvider)super.getServletContext().getAttribute("FileServlet.watermarker");
                            waterMark = provider.getWaterMark(req, c, pk, attribute);
                        }
                    }
                    if (scaleFactor != 1.0f || waterMark != null) {
                        long ts3 = System.currentTimeMillis();
                        int transparency = bi.getTransparency();
                        if (waterMark != null) {
                            Graphics2D g2d = (Graphics2D)bi.getGraphics();
                            int watermarkMaxSize = bi.getWidth() < bi.getHeight() ? bi.getWidth() / 5 : bi.getHeight() / 5;
                            float waterMarkFactor = Util.getScaledFactor(waterMark.getWidth(), waterMark.getHeight(), watermarkMaxSize);
                            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
                            g2d.setComposite(alpha);
                            float factorX = waterMarkFactor;
                            g2d.scale(factorX, factorX);
                            g2d.drawImage((Image)waterMark, (int)((float)bi.getWidth() / factorX) - 20 - (int)((float)watermarkMaxSize / factorX), (int)((float)bi.getHeight() / factorX) - 20 - (int)((float)watermarkMaxSize / factorX), null);
                        }
                        if (scale != -1) {
                            Dimension d = Util.getScaledDimension(bi.getWidth(), bi.getHeight(), scale);
                            BufferedImage scaled = this.gc.createCompatibleImage((int)d.getWidth(), (int)d.getHeight(), transparency);
                            Graphics2D g2d = (Graphics2D)scaled.getGraphics();
                            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            g2d.scale(scaleFactor, scaleFactor);
                            g2d.drawImage((Image)bi, 0, 0, null);
                            bi = scaled;
                        }
                    }
                    long ts3 = System.currentTimeMillis();
                    String extension = "jpg";
                    try {
                        StringTokenizer st = new StringTokenizer(lf.name, ".");
                        st.nextToken();
                        extension = st.nextToken();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ImageIO.write((RenderedImage)bi, extension, (OutputStream)res.getOutputStream());
                    ts3 = System.currentTimeMillis() - ts3;
                    break block22;
                }
                if (lf != null && lf.data != null && lf.data.length > 0) {
                    res.setContentLength(lf.data.length);
                    if (sendOriginalName) {
                        // empty if block
                    }
                    res.getOutputStream().write(lf.data);
                } else {
                    res.sendError(404);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                res.sendError(404);
            }
        }
        res.getOutputStream().close();
        ts = System.currentTimeMillis() - ts;
    }

    private File getNoImage(Class c, String p) throws Exception {
        String noImageKey = c.getSimpleName() + "." + p;
        String relativePath = (String)this.defaultImages.get(noImageKey);
        if (relativePath == null) {
            relativePath = (String)this.defaultImages.get(DEFAULT_ALL);
        }
        if (relativePath != null) {
            String pathTranslated = super.getServletContext().getRealPath(relativePath);
            File f = new File(pathTranslated);
            return f;
        }
        return null;
    }

    private File getWaterMark(Class c, String p) throws Exception {
        String noImageKey = c.getSimpleName() + "." + p;
        String relativePath = this.waterMarks.get(noImageKey);
        if (relativePath == null) {
            relativePath = this.waterMarks.get(WATERMARK_ALL);
        }
        if (relativePath != null) {
            String pathTranslated = super.getServletContext().getRealPath(relativePath);
            File f = new File(pathTranslated);
            return f;
        }
        return null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

