/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.servlet;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class CacheControlFilter
implements Filter {
    private Calendar calendar = new GregorianCalendar();
    private final DateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");

    public CacheControlFilter() {
        Date date = this.calendar.getTime();
        TimeZone tz = TimeZone.getTimeZone("GMT");
        this.formatter.setTimeZone(tz);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.calendar.setTime(new Date());
        this.calendar.add(5, 30);
        String expires = this.formatter.format(this.calendar.getTime());
        long ts = System.currentTimeMillis();
        ((HttpServletResponse)res).setHeader("Pragma", "");
        ((HttpServletResponse)res).setHeader("Expires", expires);
        ((HttpServletResponse)res).setHeader("Cache-Control", "public, max-age=2592000");
        chain.doFilter(req, res);
        ((HttpServletResponse)res).setHeader("Pragma", "");
        ((HttpServletResponse)res).setHeader("Expires", expires);
        ((HttpServletResponse)res).setHeader("Cache-Control", "public, max-age=2592000");
        ts = System.currentTimeMillis() - ts;
    }

    public void destroy() {
    }
}

