/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.seo;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PageRankFrame
extends JFrame {
    private JTextField input;
    private JLabel result;

    public PageRankFrame() {
        super("Fusion Google Pagerank Checker");
        this.setDefaultCloseOperation(3);
        int x = Toolkit.getDefaultToolkit().getScreenSize().width / 2 - 168;
        int y = Toolkit.getDefaultToolkit().getScreenSize().height / 2 - 80;
        this.setSize(336, 160);
        this.setBounds(x, y, 336, 160);
        JPanel back = new JPanel(null);
        this.getContentPane().add(back);
        JLabel lab1 = new JLabel("Enter your page URL here:");
        lab1.setBounds(10, 10, 300, 18);
        back.add(lab1);
        this.input = new JTextField();
        this.input.setBounds(10, 30, 300, 20);
        back.add(this.input);
        JButton button = new JButton("Get Google Page Rank");
        button.setBounds(10, 55, 200, 20);
        back.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PageRankFrame.this.buttonClicked();
            }
        });
        this.result = new JLabel();
        this.result.setBounds(10, 80, 300, 18);
        back.add(this.result);
    }

    public void buttonClicked() {
        new Thread(){

            @Override
            public void run() {
                PageRankFrame.this.result.setText("Please wait...");
                int res = PageRankFrame.getPageRank(PageRankFrame.this.input.getText());
                if (res != -1) {
                    PageRankFrame.this.result.setText("<html>Your Google Pagerank is: <strong><span color=red>" + res + "</span></strong>");
                } else {
                    PageRankFrame.this.result.setText("Invalid URL! chou 3amb tetmanyak?");
                }
            }
        }.start();
    }

    public static int getCheckSum(String url) {
        if (!PageRankFrame.validUrl(url)) {
            return 0;
        }
        return PageRankFrame.generateCheckSum(PageRankFrame.strord("info:" + url));
    }

    public static String getQueryUrl(String url) {
        int checksum = PageRankFrame.getCheckSum(url);
        if (checksum == 0) {
            return null;
        }
        String temp = "";
        try {
            temp = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return "http://www.google.com/search?client=navclient-auto&ch=6" + checksum + "&ie=UTF-8&oe=UTF-8&features=Rank&q=info:" + temp;
    }

    public static String getXmlQueryUrl(String url) {
        int checksum = PageRankFrame.getCheckSum(url);
        if (checksum == 0) {
            return null;
        }
        String temp = "";
        try {
            temp = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return "http://www.google.com/search?client=navclient-auto&ch=6" + checksum + "&ie=UTF-8&oe=UTF-8&q=info:" + temp;
    }

    public static int getPageRank(String url) {
        int pageRank = -1;
        String query = PageRankFrame.getQueryUrl(url);
        if (query == null) {
            return pageRank;
        }
        BufferedReader in = null;
        try {
            URL pr = new URL(query);
            URLConnection conn = pr.openConnection();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null) {
                String[] tokens;
                if (!line.contains(":") || (tokens = line.split(":")).length <= 2) continue;
                pageRank = Integer.parseInt(tokens[2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pageRank;
    }

    private static boolean validUrl(String url) {
        if (url == null || !url.startsWith("http")) {
            return false;
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    private static int[] strord(String str) {
        int[] result = new int[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = str.charAt(i);
        }
        return result;
    }

    private static int zeroFill(int a, int b) {
        int z = Integer.MIN_VALUE;
        if ((z & a) != 0) {
            a >>= 1;
            a &= ~z;
            a |= 0x40000000;
            a >>= b - 1;
        } else {
            a >>= b;
        }
        return a;
    }

    private static int[] mix(int a, int b, int c) {
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= PageRankFrame.zeroFill(c, 13));
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= PageRankFrame.zeroFill(b, 13));
        b -= c;
        b -= (a ^= PageRankFrame.zeroFill(c, 12));
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= PageRankFrame.zeroFill(b, 5));
        b -= c;
        b -= (a ^= PageRankFrame.zeroFill(c, 3));
        c -= a;
        c -= (b ^= a << 10);
        return new int[]{a, b, c ^= PageRankFrame.zeroFill(b, 15)};
    }

    private static int generateCheckSum(int[] url) {
        int[] mix;
        int len;
        int length = url.length;
        int init = -432694688;
        int a = -1640531527;
        int b = -1640531527;
        int c = init;
        int k = 0;
        for (len = length; len >= 12; len -= 12) {
            mix = PageRankFrame.mix(a += url[k + 0] + (url[k + 1] << 8) + (url[k + 2] << 16) + (url[k + 3] << 24), b += url[k + 4] + (url[k + 5] << 8) + (url[k + 6] << 16) + (url[k + 7] << 24), c += url[k + 8] + (url[k + 9] << 8) + (url[k + 10] << 16) + (url[k + 11] << 24));
            a = mix[0];
            b = mix[1];
            c = mix[2];
            k += 12;
        }
        c += length;
        switch (len) {
            case 11: {
                c += url[k + 10] << 24;
            }
            case 10: {
                c += url[k + 9] << 16;
            }
            case 9: {
                c += url[k + 8] << 8;
            }
            case 8: {
                b += url[k + 7] << 24;
            }
            case 7: {
                b += url[k + 6] << 16;
            }
            case 6: {
                b += url[k + 5] << 8;
            }
            case 5: {
                b += url[k + 4];
            }
            case 4: {
                a += url[k + 3] << 24;
            }
            case 3: {
                a += url[k + 2] << 16;
            }
            case 2: {
                a += url[k + 1] << 8;
            }
            case 1: {
                a += url[k + 0];
            }
        }
        mix = PageRankFrame.mix(a, b, c);
        return mix[2];
    }

    public static void main(String[] args) {
        new PageRankFrame().setVisible(true);
    }
}

