/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.locale.postalcode;

import es.pablo.locale.postalcode.Calle;
import es.pablo.locale.postalcode.CodigoPostal;
import es.pablo.locale.postalcode.Pais;
import es.pablo.locale.postalcode.Provincia;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PostalCodeParser
extends DefaultHandler {
    private final String SPAIN = "spain";
    private final String PROVINCIA = "provincia";
    private final String CP = "codigo-postal";
    private final String MUNICIPIO = "municipio";
    private final String CALLE = "calle";
    private final String AT_NOMBRE = "nombre";
    private final String AT_VALUE = "value";
    CodigoPostal _codigoPostal;
    Provincia _provincia;
    Pais _pais;
    static Pais cacheSpain = null;

    private PostalCodeParser() {
    }

    public static synchronized Pais getSpain() throws Exception {
        if (cacheSpain == null) {
            String s = System.getProperty("java.library.path");
            StringTokenizer st = new StringTokenizer(s, ";");
            while (st.hasMoreElements()) {
                File dir = new File(st.nextToken());
                File file = new File(dir, "postalcode.xml");
                if (!file.exists()) continue;
                cacheSpain = PostalCodeParser.parse(new FileInputStream(file));
                break;
            }
        }
        return cacheSpain;
    }

    public static Pais parse(InputStream is) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        SAXParser saxParser = factory.newSAXParser();
        PostalCodeParser handler = new PostalCodeParser();
        saxParser.parse(is, (DefaultHandler)handler);
        handler.dump();
        return handler._pais;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("spain".equals(qName)) {
            this._pais = new Pais("Espa\u00f1a");
        }
        if ("provincia".equals(qName)) {
            this._provincia = new Provincia(atts.getValue("nombre"));
            this._pais.provincias.add(this._provincia);
        }
        if ("codigo-postal".equals(qName)) {
            String cp = atts.getValue("value");
            this._codigoPostal = new CodigoPostal(this._provincia, cp);
            this._provincia.codigosPostales.put(cp, this._codigoPostal);
            this._pais.cache.put(cp, this._codigoPostal);
        }
        if ("municipio".equals(qName)) {
            this._codigoPostal.municipios.add(atts.getValue("nombre"));
        }
        if ("calle".equals(qName)) {
            Calle c;
            String value = atts.getValue("nombre");
            if (value.contains("(")) {
                value = value.substring(0, value.indexOf("(")).trim();
            }
            if (value.contains(",")) {
                String tipoVia = value.substring(value.indexOf(",") + 1);
                String calle = value.substring(0, value.indexOf(",")).trim();
                c = new Calle(tipoVia, calle);
            } else {
                c = new Calle("", value);
            }
            this._codigoPostal.calles.add(c);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    public void dump() {
    }

    private static class CountryEntry
    implements Comparable {
        String name;
        String code;

        public CountryEntry(String name, String code) {
            this.name = name;
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CountryEntry other = (CountryEntry)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.code == null ? other.code != null : !this.code.equals(other.code));
        }

        public int compareTo(Object o) {
            return this.name.compareTo(((CountryEntry)o).name);
        }

        public int hashCode() {
            return this.code.hashCode();
        }
    }
}

