/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.locale.postalcode;

import es.pablo.jee.ejb.request.DefaultController;
import es.pablo.locale.postalcode.Calle;
import es.pablo.locale.postalcode.CodigoPostal;
import es.pablo.locale.postalcode.Provincia;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.model.SelectItem;

public class Pais
implements Serializable {
    String nombre;
    List<Provincia> provincias = Collections.synchronizedList(new ArrayList());
    Map<String, CodigoPostal> cache = Collections.synchronizedMap(new HashMap());

    public static List<SelectItem> getCountriesAsSelectItems(Locale l) {
        ArrayList<SelectItem> sortedCountris = new ArrayList<SelectItem>();
        for (String s2 : Locale.getISOCountries()) {
            Locale le = new Locale("", s2);
            String countryName = le.getDisplayCountry(l);
            sortedCountris.add(new SelectItem((Object)s2, countryName));
        }
        Collections.sort(sortedCountris, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((SelectItem)o1).getLabel().compareTo(((SelectItem)o2).getLabel());
            }
        });
        return sortedCountris;
    }

    public Pais(String nombre) {
        this.nombre = nombre;
    }

    public String getProvincia(String codigoPostal) throws IllegalArgumentException {
        CodigoPostal cp = this.cache.get(codigoPostal);
        if (cp != null) {
            return cp.provincia.nombre;
        }
        return null;
    }

    public List<SelectItem> getMatchingMunicipios(String codigoPostal, String preffix) throws IllegalArgumentException {
        CodigoPostal cp = this.cache.get(codigoPostal);
        ArrayList<SelectItem> al = new ArrayList<SelectItem>();
        if (cp != null) {
            for (String s : cp.municipios) {
                if (s.startsWith(preffix)) {
                    al.add(0, new SelectItem((Object)s));
                    continue;
                }
                if (!s.contains(preffix)) continue;
                al.add(new SelectItem((Object)s));
            }
        }
        return al;
    }

    public List<SelectItem> getMatchingCalles(String codigoPostal, String preffix) throws IllegalArgumentException {
        preffix = DefaultController.quitaAzentos(preffix);
        CodigoPostal cp = this.cache.get(codigoPostal);
        ArrayList<SelectItem> al = new ArrayList<SelectItem>();
        if (cp != null) {
            for (Calle c : cp.calles) {
                String nombre = DefaultController.quitaAzentos(c.nombre.toLowerCase());
                if (nombre.startsWith(preffix)) {
                    al.add(0, new SelectItem((Object)c.toString()));
                    continue;
                }
                if (!nombre.contains(preffix)) continue;
                al.add(new SelectItem((Object)c.toString()));
            }
        }
        return al;
    }

    public List<SelectItem> getMatchingCodigosPostales(String preffix) throws IllegalArgumentException {
        ArrayList<SelectItem> ret = new ArrayList<SelectItem>();
        for (String s : this.cache.keySet()) {
            if (!s.startsWith(preffix)) continue;
            ret.add(new SelectItem((Object)this.cache.get(s)));
        }
        return ret;
    }
}

