/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.entity;

import es.pablo.jee.entity.ServerFile;
import es.pablo.util.Util;
import java.io.File;
import java.io.Serializable;
import java.net.URLConnection;
import java.util.Arrays;

public class LobFile
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    static File TEMP_DIR = new File("C:\\javatemp");
    public byte[] data = new byte[0];
    public String contentType = "";
    public String name = "";

    public LobFile() {
    }

    public LobFile(File f) throws Exception {
        this.data = Util.readFileToByteArr(f);
        this.contentType = URLConnection.guessContentTypeFromName(f.getName());
        this.name = f.getName().replace(" ", "");
    }

    public LobFile(File f, String contentType) throws Exception {
        this(f);
        this.contentType = contentType;
    }

    public LobFile(String name, String contentType, byte[] data) {
        this.name = name;
        this.data = data;
        this.contentType = contentType;
    }

    public LobFile(String name, byte[] data) {
        this(name, null, data);
    }

    public File getTempFile() throws Exception {
        File tempFile = new File(TEMP_DIR, System.currentTimeMillis() + this.name);
        Util.writeFile(tempFile, this.data);
        tempFile.deleteOnExit();
        return tempFile;
    }

    public String getExtension() {
        return this.name.indexOf(".") != -1 ? this.name.substring(this.name.indexOf(".") + 1).toUpperCase() : "";
    }

    public String getContentFamily() {
        return this.contentType.indexOf("/") != -1 ? this.contentType.substring(0, this.contentType.indexOf("/")).toLowerCase() : this.contentType;
    }

    public Boolean isEmpty() {
        return this.data.length == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LobFile) {
            LobFile sf = (LobFile)o;
            return sf != null && sf.hashCode() == this.hashCode() && Arrays.equals(this.data, sf.data);
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof ServerFile) {
            ServerFile other = (ServerFile)o;
            return other.name != null ? other.name.compareTo(this.name) : -1;
        }
        return -1;
    }

    public String toString() {
        if (this.data == null) {
            return "LobFile data is null";
        }
        String size = this.data.length < 1000 ? this.data.length + " bytes" : (this.data.length < 1000000 ? this.data.length / 1000 + " KB." : this.data.length / 100000000 + " MB.");
        return this.name + " (" + this.contentType + ") - " + size;
    }

    static {
        TEMP_DIR.mkdirs();
    }
}

