/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.entity;

import es.pablo.jee.entity.BackRef;
import es.pablo.jee.entity.ConditionedRef;
import es.pablo.jee.entity.CurrentDate;
import es.pablo.jee.entity.DbFile;
import es.pablo.jee.entity.DecimalFormat;
import es.pablo.jee.entity.DisplayName;
import es.pablo.jee.entity.EntityMetaData;
import es.pablo.jee.entity.File;
import es.pablo.jee.entity.ForeignKey;
import es.pablo.jee.entity.Image;
import es.pablo.jee.entity.Pattern;
import es.pablo.jee.entity.TemporalFormat;
import es.pablo.jee.entity.Text;
import es.pablo.jee.entity.UseCombo;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.reflect.FieldUtils;

public class Introspector {
    private static final HashMap<Class, BeanInfo> cache = new HashMap();

    private static Class getActualType(Field f, EntityMetaData emd) {
        Type t = f.getGenericType();
        return Introspector.getActualType(t);
    }

    public static Class getActualType(Type t) {
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            Type raw = pt.getRawType();
            Class rawClass = (Class)raw;
            if (rawClass.isAssignableFrom(Collection.class) || rawClass.isAssignableFrom(Set.class) || rawClass.isAssignableFrom(List.class)) {
                Type[] actualType = pt.getActualTypeArguments();
                if (actualType.length == 1) {
                    Class actualClass = (Class)actualType[0];
                    if (actualClass.isAnnotationPresent(Entity.class)) {
                        return actualClass;
                    }
                    throw new RuntimeException("No envuelve entidades:" + t);
                }
                throw new RuntimeException("Demasiado rollo: " + t);
            }
            throw new RuntimeException("El atributo no es del tipo java.util.Collection " + t);
        }
        return (Class)t;
    }

    public static boolean isEntity(Class c) {
        return c.isAnnotationPresent(Entity.class);
    }

    public static Class getPKClass(Class c) throws IntrospectionException {
        EntityMetaData emd = (EntityMetaData)Introspector.getBeanInfo(c).getBeanDescriptor().getValue("emd");
        String id = emd.id.get(0);
        return emd.columnClasses.get(id);
    }

    public static Object getId(Object e) throws Exception {
        EntityMetaData emd = Introspector.getEntityMetaData(e.getClass());
        return emd.getReadMethod(emd.id.get(0)).invoke(e, new Object[0]);
    }

    public static EntityMetaData getEntityMetaData(Class c) throws IntrospectionException {
        return (EntityMetaData)Introspector.getBeanInfo(c).getBeanDescriptor().getValue("emd");
    }

    public static synchronized BeanInfo getBeanInfo(Class c) throws IntrospectionException {
        Field[] dfs;
        BeanInfo bi = cache.get(c);
        if (bi != null) {
            return bi;
        }
        bi = java.beans.Introspector.getBeanInfo(c);
        EntityMetaData emd = new EntityMetaData();
        HashMap<String, PropertyDescriptor> pdMap = new HashMap<String, PropertyDescriptor>();
        emd.clazz = c;
        emd.name = c.getSimpleName();
        for (Field field : dfs = FieldUtils.getAllFields((Class)c)) {
            Id id;
            DecimalFormat decFormat;
            ConditionedRef cr;
            OneToMany otm;
            OneToOne oto;
            File file;
            DbFile dbf;
            UseCombo uc;
            Image image;
            PropertyDescriptor[] pds;
            if (field.isAnnotationPresent(Transient.class) || Modifier.isTransient(field.getModifiers())) continue;
            for (PropertyDescriptor p : pds = bi.getPropertyDescriptors()) {
                if (!p.getName().equals(field.getName())) continue;
                pdMap.put(field.getName(), p);
            }
            if (!pdMap.containsKey(field.getName())) continue;
            Class actualClass = Introspector.getActualType(field, emd);
            DisplayName dn = field.getAnnotation(DisplayName.class);
            if (dn != null) {
                emd.columnDisplayNames.put(field.getName(), dn.value());
            } else {
                emd.columnDisplayNames.put(field.getName(), field.getName());
            }
            Basic b = field.getAnnotation(Basic.class);
            if (b != null && FetchType.LAZY.equals((Object)b.fetch())) {
                emd.lazy.add(field.getName());
            }
            if (field.getAnnotation(Text.class) != null) {
                emd.text.add(field.getName());
            }
            if ((image = field.getAnnotation(Image.class)) != null) {
                emd.images.put(field.getName(), image);
            }
            if ((uc = field.getAnnotation(UseCombo.class)) != null) {
                emd.combos.put(field.getName(), uc);
            }
            if ((dbf = field.getAnnotation(DbFile.class)) != null) {
                emd.dbFiles.put(field.getName(), field.getType());
            }
            if ((file = field.getAnnotation(File.class)) != null) {
                emd.file.add(field.getName());
                emd.files.put(field.getName(), file);
            }
            if ((oto = field.getAnnotation(OneToOne.class)) != null) {
                if (oto.mappedBy().isEmpty()) {
                    ForeignKey fk = new ForeignKey();
                    fk.targetEntity = actualClass;
                    fk.optional = oto.optional();
                    fk.onEntity = c;
                    fk.onProperty = field.getName();
                    if (!fk.optional) {
                        emd.notNull.add(field.getName());
                    }
                    fk.card = ForeignKey.Card.OTO;
                    emd.fk.put(field.getName(), fk);
                } else {
                    BackRef br = new BackRef();
                    br.source = actualClass;
                    br.sourceFK = oto.mappedBy();
                    br.card = BackRef.Card.OTO;
                    br.onProperty = field.getName();
                    br.onClass = c;
                    emd.br.put(field.getName(), br);
                    continue;
                }
            }
            if ((otm = field.getAnnotation(OneToMany.class)) != null) {
                if (otm.mappedBy().isEmpty()) {
                    throw new IntrospectionException("OneToMany without mappedBy  " + field.getName() + " in " + c);
                }
                BackRef br = new BackRef();
                br.source = actualClass;
                br.sourceFK = otm.mappedBy();
                br.card = BackRef.Card.OTM;
                br.onProperty = field.getName();
                br.onClass = c;
                emd.br.put(field.getName(), br);
                continue;
            }
            ManyToMany mtm = field.getAnnotation(ManyToMany.class);
            if (mtm != null) {
                BackRef br = new BackRef();
                br.onProperty = field.getName();
                br.onClass = c;
                br.source = actualClass;
                br.sourceFK = mtm.mappedBy();
                br.card = BackRef.Card.MTM;
                emd.br.put(field.getName(), br);
                continue;
            }
            ManyToOne mto = field.getAnnotation(ManyToOne.class);
            if (mto != null) {
                ForeignKey fk = new ForeignKey();
                fk.targetEntity = actualClass;
                fk.optional = mto.optional();
                fk.onEntity = c;
                fk.onProperty = field.getName();
                if (!fk.optional) {
                    emd.notNull.add(field.getName());
                }
                fk.card = ForeignKey.Card.MTO;
                emd.fk.put(field.getName(), fk);
            }
            if ((cr = field.getAnnotation(ConditionedRef.class)) != null) {
                emd.conditionedRefs.put(field.getName(), cr.value());
            }
            emd.columnNames.add(field.getName());
            emd.columnClasses.put(field.getName(), actualClass);
            Pattern p = field.getAnnotation(Pattern.class);
            if (p != null) {
                emd.pattern.put(field.getName(), p);
            }
            if ((decFormat = field.getAnnotation(DecimalFormat.class)) != null) {
                java.text.DecimalFormat df = new java.text.DecimalFormat(decFormat.value());
                df.setParseBigDecimal(true);
                emd.decimalFormat.put(field.getName(), df);
            }
            if ((id = field.getAnnotation(Id.class)) != null) {
                emd.id.add(field.getName());
                emd.unique.add(field.getName());
                emd.notNull.add(field.getName());
                GeneratedValue gv = field.getAnnotation(GeneratedValue.class);
                if (gv != null) {
                    emd.generated.add(field.getName());
                    emd.nonInsertable.add(field.getName());
                }
            } else {
                Column co;
                Basic ba = field.getAnnotation(Basic.class);
                if (ba != null && !ba.optional()) {
                    emd.notNull.add(field.getName());
                }
                if ((co = field.getAnnotation(Column.class)) != null) {
                    if (co.unique()) {
                        emd.unique.add(field.getName());
                    }
                    if (!co.nullable()) {
                        emd.notNull.add(field.getName());
                    }
                    if (!co.updatable()) {
                        emd.nonUpdatable.add(field.getName());
                    }
                    if (!co.insertable()) {
                        emd.nonInsertable.add(field.getName());
                    }
                } else {
                    JoinColumn jc = field.getAnnotation(JoinColumn.class);
                    if (jc != null) {
                        if (jc.unique()) {
                            emd.unique.add(field.getName());
                        }
                        if (!jc.nullable()) {
                            emd.notNull.add(field.getName());
                        }
                        if (!jc.updatable()) {
                            emd.nonUpdatable.add(field.getName());
                        }
                        if (!jc.insertable()) {
                            emd.nonInsertable.add(field.getName());
                        }
                    }
                }
            }
            Temporal tf = field.getAnnotation(Temporal.class);
            if (tf == null) continue;
            SimpleDateFormat format = tf.value() == TemporalType.DATE ? TemporalFormat.DATE : (tf.value() == TemporalType.TIME ? TemporalFormat.TIME : TemporalFormat.TIME_STAMP);
            emd.temporalFormat.put(field.getName(), format);
            if (field.getAnnotation(CurrentDate.class) == null) continue;
            emd.generatedDates.add(field.getName());
        }
        bi.getBeanDescriptor().setValue("emd", emd);
        bi.getBeanDescriptor().setValue("pdMap", pdMap);
        cache.put(c, bi);
        return bi;
    }

    public static Object makePkFromString(Class c, String pk) throws Exception {
        EntityMetaData emd = Introspector.getEntityMetaData(c);
        Class pkType = emd.columnClasses.get(emd.id.get(0));
        Constructor constructor = pkType.getConstructor(String.class);
        return constructor.newInstance(pk);
    }

    public static Object readProperty(Object o, String property) throws Exception {
        Map pdMap = (Map)Introspector.getBeanInfo(o.getClass()).getBeanDescriptor().getValue("pdMap");
        PropertyDescriptor pd = (PropertyDescriptor)pdMap.get(property);
        return pd.getReadMethod().invoke(o, new Object[0]);
    }
}

