/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.timer;

import es.pablo.jee.ejb.exception.InvalidParameterException;
import es.pablo.jee.ejb.timer.TimedBean;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.ejb.EJBContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTimedBean
implements TimedObject,
TimedBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractTimedBean.class);
    String name;
    long intervalo;

    public AbstractTimedBean(String name, long intervalo) {
        this.name = name != null ? name : this.toString();
        this.intervalo = intervalo;
    }

    public void ejbTimeout(Timer timer) {
        log.info("timeout {}", (Object)timer.getInfo());
        if (this.isDuplicate()) {
            this.paraServicio();
        }
        this.doTimeOut(timer);
    }

    @Override
    public void setIntervalo(long l) throws InvalidParameterException {
        this.intervalo = l;
        if (this.isRunning()) {
            this.paraServicio();
            this.arrancaServicio();
        }
    }

    @Override
    public String arrancaServicio() {
        if (this.isRunning()) {
            log.info("Servicio no arrancado porque ya estaba en marcha");
            return "El servicio ya esta en marcha ";
        }
        Timer t = this.getContext().getTimerService().createTimer(this.getFirstExpiration(), this.intervalo, (Serializable)((Object)this.name));
        log.info("Servicio creado {} coun un intervalo de {}", (Object)t.getNextTimeout(), (Object)this.intervalo);
        return "Servicio arrancado " + new Date();
    }

    public long getFirstExpiration() {
        long l = (long)(10000.0 * Math.random());
        return l;
    }

    @Override
    public boolean isRunning() {
        boolean ret = false;
        Collection timers = this.getContext().getTimerService().getTimers();
        for (Object o : timers) {
            Timer t = (Timer)o;
            log.info("{} isRunning found: {}", (Object)super.toString(), (Object)t.getInfo());
            if (!this.name.equals(t.getInfo())) continue;
            ret = true;
            break;
        }
        log.info("{} isRunning: {}", (Object)super.toString(), (Object)ret);
        return ret;
    }

    public boolean isDuplicate() {
        boolean found = false;
        Collection timers = this.getContext().getTimerService().getTimers();
        for (Object o : timers) {
            Timer t = (Timer)o;
            if (!this.name.equals(t.getInfo())) continue;
            if (found) {
                return true;
            }
            found = true;
        }
        return false;
    }

    @Override
    public String paraServicio() {
        String s = "El servicio no estaba en marcha";
        Collection timers = this.getContext().getTimerService().getTimers();
        for (Object o : timers) {
            Timer t = (Timer)o;
            if (!this.name.equals(t.getInfo())) continue;
            t.cancel();
            s = "Serivicio detenido a las " + new Date();
        }
        log.info("{} paraServicio: {}", (Object)super.toString(), (Object)s);
        return s;
    }

    protected abstract EJBContext getContext();

    protected abstract void doTimeOut(Timer var1);
}

