/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.swing.tree;

import es.pablo.jee.ejb.jms.PersistenceEvent;
import es.pablo.jee.ejb.jms.Refreshable;
import es.pablo.jee.ejb.jms.Refresher;
import es.pablo.jee.ejb.request.LocalFacade;
import es.pablo.jee.ejb.swing.Clipboard;
import es.pablo.jee.ejb.swing.EntityEditor;
import es.pablo.jee.ejb.swing.tree.EntityTree;
import es.pablo.jee.ejb.swing.tree.Filter;
import es.pablo.jee.entity.EntityRef;
import es.pablo.jee.entity.Introspector;
import es.pablo.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class EntityTreeModel
implements TreeModel,
Refreshable {
    Class c;
    String id;
    String displayName;
    String rp;
    String root = "root";
    String br = null;
    Map<Object, List<EntityRef>> cache = null;
    public static LocalFacade facadeLocal;
    EntityTree tree;
    Filter filter;
    List<TreeModelListener> listeners = Collections.synchronizedList(new ArrayList());

    public EntityTreeModel() {
    }

    public EntityTreeModel(EntityTree tree, Class c, String displayName) throws Exception {
        this();
        this.tree = tree;
        this.setClass(c);
        this.setDisplayName(displayName);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public EntityTree getTree() {
        return this.tree;
    }

    public void setTree(EntityTree tree) {
        this.tree = tree;
    }

    public synchronized EntityRef getEntityRef(Object pk) {
        for (Map.Entry<Object, List<EntityRef>> e : this.cache.entrySet()) {
            List<EntityRef> l = e.getValue();
            for (EntityRef er : l) {
                if (!er.pk.equals(pk)) continue;
                return er;
            }
        }
        return null;
    }

    public synchronized EntityRef getFather(Object o) {
        if (o.equals(this.root)) {
            return null;
        }
        for (Map.Entry<Object, List<EntityRef>> e : this.cache.entrySet()) {
            List<EntityRef> l = e.getValue();
            for (int i = 0; i < l.size(); ++i) {
                EntityRef er = l.get(i);
                if (er == null || er.pk == null || !er.equals(o) && !er.pk.equals(o)) continue;
                return this.getEntityRef(e.getKey());
            }
        }
        return null;
    }

    public TreePath getTreePath(Object o) {
        ArrayList<Object> tp = new ArrayList<Object>();
        while (o != null) {
            tp.add(0, o);
            o = this.getFather(o);
        }
        return new TreePath(tp.toArray());
    }

    @Override
    public synchronized void refresh(PersistenceEvent pe) throws Exception {
        if (pe == null) {
            this.reload();
        } else if (pe.clazz.equals(this.c)) {
            if (pe.type.equals((Object)PersistenceEvent.Type.CREATE)) {
                List<EntityRef> kids;
                Object pk = pe.pk;
                ArrayList<String> propertiesWeWant = new ArrayList<String>();
                propertiesWeWant.add(this.id);
                propertiesWeWant.add(this.displayName);
                propertiesWeWant.add(this.rp);
                Object[] l = EntityEditor.ac.get(this.c, pk, propertiesWeWant);
                EntityRef newNode = new EntityRef(l[0], "" + l[1]);
                EntityRef father = (EntityRef)l[2];
                if (father == null) {
                    father = new EntityRef((Object)this.root, this.root);
                }
                if ((kids = this.cache.get(father.pk)) == null) {
                    kids = new ArrayList<EntityRef>();
                    this.cache.put(father.pk, kids);
                }
                this.cache.put(pk, new ArrayList());
                kids.add(newNode);
                int childIdx = kids.indexOf(newNode);
                TreePath fatherTreePath = this.getTreePath(father);
                for (TreeModelListener tml : this.listeners) {
                    TreeModelEvent tme = new TreeModelEvent((Object)this, fatherTreePath, new int[]{childIdx}, new Object[]{newNode});
                    tml.treeNodesInserted(tme);
                }
            } else if (pe.type.equals((Object)PersistenceEvent.Type.DELETE)) {
                Object pk = pe.pk;
                EntityRef father = this.getFather(pk);
                if (father != null) {
                    int childIdx = this.getIndexOfChild(father, new EntityRef(pk, pk));
                    TreePath fatherTreePath = this.getTreePath(father);
                    for (TreeModelListener tml : this.listeners) {
                        tml.treeNodesInserted(new TreeModelEvent((Object)this, fatherTreePath, new int[]{childIdx}, new Object[]{this.getEntityRef(pk)}));
                    }
                }
            } else if (pe.type.equals((Object)PersistenceEvent.Type.UPDATE)) {
                // empty if block
            }
            this.tree.refresh(false);
        }
    }

    public synchronized void reload() {
        this.cache = null;
    }

    public synchronized void setClass(Class c) throws Exception {
        if (!c.equals(this.c) && facadeLocal == null) {
            Refresher.getInstance().unsubscribe(this.c, this);
            Refresher.getInstance().subscribe(c, this);
        }
        this.c = c;
        this.id = Introspector.getEntityMetaData((Class)c).id.get(0);
        this.rp = Introspector.getEntityMetaData(c).getRecursibleProperties().get(0);
        this.br = Introspector.getEntityMetaData(c).getRecursibleChildren(this.rp);
    }

    public synchronized String getBackrefProperty() {
        return this.br;
    }

    public synchronized String getId() {
        return this.id;
    }

    public synchronized String getRecursedProperty() {
        return this.rp;
    }

    public synchronized void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public synchronized Object getChild(Object parent, int index) {
        return this.getChildren(parent).get(index);
    }

    public synchronized void fireChanges() {
        for (TreeModelListener l : this.listeners) {
            l.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}));
        }
    }

    public List<Object> getChildrenIds(Object parent) {
        List<EntityRef> ret = this.getChildren(parent);
        ArrayList<Object> ret2 = new ArrayList<Object>();
        for (EntityRef o : ret) {
            ret2.add(o.pk);
        }
        return ret2;
    }

    public synchronized List<EntityRef> getChildren(Object parent) {
        ArrayList<EntityRef> ret = new ArrayList<EntityRef>();
        try {
            if (this.cache == null) {
                long ts = System.currentTimeMillis();
                this.cache = facadeLocal == null ? EntityEditor.facade.getTree(this.c, this.displayName, this.rp, this.filter) : facadeLocal.getTreeLocal(this.c, this.displayName, this.rp, this.filter);
                ts = System.currentTimeMillis() - ts;
            }
            if (parent == this.getRoot()) {
                return this.cache.get(this.getRoot());
            }
            if (parent instanceof EntityRef) {
                return this.cache.get(((EntityRef)parent).pk);
            }
            if (this.cache.containsKey(parent)) {
                return this.cache.get(parent);
            }
            throw new IllegalArgumentException("Unknown parent: " + parent);
        }
        catch (Exception e) {
            if (facadeLocal == null) {
                Util.show(null, (Throwable)e);
            }
            return ret;
        }
    }

    @Override
    public synchronized int getChildCount(Object parent) {
        List<EntityRef> kids = this.getChildren(parent);
        if (kids != null) {
            return kids.size();
        }
        return 0;
    }

    @Override
    public synchronized int getIndexOfChild(Object parent, Object child) {
        List<EntityRef> children = this.getChildren(parent);
        int ret = children.indexOf(child);
        int idx = 0;
        for (EntityRef er : children) {
            EntityRef childEr;
            if (child instanceof EntityRef ? (childEr = (EntityRef)child).equals(child) : er.pk.equals(child)) {
                return idx;
            }
            ++idx;
        }
        return ret;
    }

    @Override
    public synchronized Object getRoot() {
        return this.root;
    }

    @Override
    public synchronized boolean isLeaf(Object node) {
        List<EntityRef> kids = this.getChildren(node);
        if (kids == null) {
            System.err.println(" isLeaf got null kids for " + node);
            return false;
        }
        return kids.size() == 0;
    }

    @Override
    public synchronized void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public synchronized void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public synchronized void valueForPathChanged(TreePath path, Object newValue) {
        EntityRef er = (EntityRef)path.getLastPathComponent();
        try {
            EntityEditor.ac.set(this.c, er.pk, this.displayName, newValue);
            er.desc = String.valueOf(newValue);
            for (TreeModelListener tml : this.listeners) {
                tml.treeNodesChanged(new TreeModelEvent((Object)this, path));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void postPasteUpdate(Clipboard cb, TreePath tp, EntityRef target) {
        EntityTreeModel treeModel = this;
        if (cb.isCut && cb.fromType.equals(this.c)) {
            List<EntityRef> ler = treeModel.cache.get(cb.fromPk);
            ArrayList<EntityRef> toBeAddedToOtherBranch = new ArrayList<EntityRef>();
            for (EntityRef er : ler) {
                if (!cb.content.contains(er)) continue;
                toBeAddedToOtherBranch.add(er);
            }
            treeModel.cache.get(target.pk).addAll(toBeAddedToOtherBranch);
            for (TreeModelListener tml : treeModel.listeners) {
                tml.treeNodesRemoved(new TreeModelEvent((Object)this, cb.cutFromTp, cb.cutChildIdxs, cb.content.toArray()));
                int[] idxs = new int[cb.content.size()];
                int i = 0;
                for (EntityRef o : cb.content) {
                    idxs[i++] = treeModel.getIndexOfChild(target, o);
                }
                tml.treeNodesInserted(new TreeModelEvent((Object)this, tp, idxs, cb.content.toArray()));
            }
        } else if (!cb.fromType.equals(this.c)) {
            // empty if block
        }
    }
}

