/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.swing.tree;

import es.pablo.jee.ejb.swing.Clipboard;
import es.pablo.jee.ejb.swing.EntityEditor;
import es.pablo.jee.ejb.swing.EntityEditorPopup;
import es.pablo.jee.ejb.swing.tree.EntityTreeModel;
import es.pablo.jee.ejb.swing.tree.Filter;
import es.pablo.jee.entity.EntityMetaData;
import es.pablo.jee.entity.EntityRef;
import es.pablo.jee.entity.Introspector;
import es.pablo.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class EntityTree
extends JPanel {
    Class c;
    EntityMetaData emd;
    public Map<String, EntityEditor> editors = new HashMap<String, EntityEditor>();
    EntityEditor fakeEE = null;
    Clipboard cb = new Clipboard();
    EntityTreeModel treeModel = new EntityTreeModel();
    final Object treeModelLock = new Object();
    private JMenuItem cortar;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JMenuItem pegar;
    private JTabbedPane tabs;
    private JTree tree;
    private JPopupMenu treePopup;

    public EntityTree() {
        this.initComponents();
        this.tree.add(this.treePopup);
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
    }

    public EntityTree(Class c, String displayName) throws Exception {
        this(c, displayName, null);
    }

    public EntityTree(Class c, String displayName, Filter f) throws Exception {
        this();
        this.treeModel.setFilter(f);
        this.treeModel.setTree(this);
        this.setData(c, displayName);
    }

    public Clipboard getClipBoard() {
        return this.cb;
    }

    public Class getClazz() {
        return this.c;
    }

    public JTree getTree() {
        return this.tree;
    }

    public EntityTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setData(Class c, String displayName) throws Exception {
        this.c = c;
        this.treeModel.setClass(c);
        this.treeModel.setDisplayName(displayName);
        this.tree.setModel(this.treeModel);
        this.emd = Introspector.getEntityMetaData(c);
        this.fakeEE = new EntityEditor(c, true, true, true, true, true, true, true, null, new ArrayList());
        for (String s : this.emd.br.keySet()) {
            EntityEditor ee = this.fakeEE.getBrEE(s);
            ee.setHorizontalScrollBars(false);
            EntityEditorPopup pu = new EntityEditorPopup(this, ee);
            this.editors.put(s, ee);
            this.tabs.add(this.emd.columnDisplayNames.get(s), ee);
        }
        try {
            this.tree.setSelectionRow(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.treePopup = new JPopupMenu();
        this.cortar = new JMenuItem();
        this.pegar = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.tabs = new JTabbedPane();
        ResourceBundle bundle = ResourceBundle.getBundle("es/pablo/jee/ejb/swing/tree/Bundle");
        this.cortar.setText(bundle.getString("EntityTree.cortar.text"));
        this.cortar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityTree.this.cortarActionPerformed(evt);
            }
        });
        this.treePopup.add(this.cortar);
        this.pegar.setText(bundle.getString("EntityTree.pegar.text"));
        this.pegar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityTree.this.pegarActionPerformed(evt);
            }
        });
        this.treePopup.add(this.pegar);
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.add((Component)this.jPanel1, "First");
        this.tree.setEditable(true);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                EntityTree.this.treeMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                EntityTree.this.treeMouseReleased(evt);
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                EntityTree.this.treeValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                EntityTree.this.tabsStateChanged(evt);
            }
        });
        this.jSplitPane1.setRightComponent(this.tabs);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void cortarActionPerformed(ActionEvent evt) {
        TreePath tp = this.tree.getSelectionPath();
        if (tp != null) {
            EntityRef er = (EntityRef)tp.getLastPathComponent();
            this.cb.content.clear();
            this.cb.content.add(er);
            this.cb.clipboardType = this.c;
            EntityRef cutFromEr = (EntityRef)tp.getParentPath().getLastPathComponent();
            if (cutFromEr != null) {
                this.cb.fromPk = cutFromEr.pk;
                this.cb.cutFromTp = tp.getParentPath();
                this.cb.cutChildIdxs = new int[]{this.treeModel.getChildren(cutFromEr).indexOf(er)};
            } else {
                this.cb.fromPk = null;
                this.cb.cutFromTp = null;
                this.cb.cutChildIdxs = new int[]{0};
            }
            this.cb.fromType = this.c;
            this.cb.fromPropterty = this.treeModel.getBackrefProperty();
            this.cb.isCut = true;
        }
    }

    private void treeValueChanged(TreeSelectionEvent evt) {
        this.updateSelection(evt.getNewLeadSelectionPath());
    }

    private void updateSelection(TreePath newSelection) {
        if (newSelection != null) {
            Object o = newSelection.getLastPathComponent();
            EntityEditor ee = (EntityEditor)this.tabs.getSelectedComponent();
            EntityEditor.BrList l = null;
            if (ee.pKs instanceof EntityEditor.BrList) {
                l = (EntityEditor.BrList)ee.pKs;
            } else if (ee.pKs instanceof EntityEditor.SearchList) {
                l = (EntityEditor.BrList)((EntityEditor.SearchList)ee.pKs).getCompleteList();
            }
            Object pk = null;
            if (o instanceof EntityRef) {
                pk = ((EntityRef)o).pk;
            } else if (o == this.treeModel.getRoot()) {
                pk = o;
            }
            if (l.getProperty().equals(this.treeModel.br)) {
                l.setFixedList(this.treeModel.getChildrenIds(pk));
            } else if (o == this.treeModel.getRoot()) {
                l.setFixedList(Collections.emptyList());
            } else {
                l.setFixedList(null);
                l.setPk(pk);
            }
            ee.refresh(null);
        }
    }

    private void pegarActionPerformed(ActionEvent evt) {
        if (this.cb.content.size() > 0) {
            TreePath tp = this.tree.getSelectionPath();
            if (tp != null) {
                EntityRef target = (EntityRef)tp.getLastPathComponent();
                try {
                    EntityEditor.facade.pasteRemote(this.c, target.pk, this.cb.fromPropterty, this.getClipboardType(), this.getClipboardPks(), this.cb.isCut, this.cb.fromType, this.cb.fromPk, this.cb.fromPropterty);
                    if (this.cb.isCut && this.cb.fromType.equals(this.c)) {
                        this.treeModel.postPasteUpdate(this.cb, tp, target);
                    } else if (!this.cb.fromType.equals(this.c)) {
                        EntityEditor ee = this.editors.get(this.cb.fromPropterty);
                        if (ee.emd.clazz.equals(this.getClipboardType())) {
                            ee.refresh(null);
                        }
                    }
                    this.cb.content.clear();
                }
                catch (Exception e) {
                    Util.show((Component)this.tree, (Throwable)e);
                }
            }
        } else {
            Util.show((Component)this.tree, "No hay que pegar");
        }
    }

    private Class getClipboardType() {
        return this.cb.clipboardType;
    }

    private List getClipboardPks() {
        ArrayList<Object> l = new ArrayList<Object>(this.cb.content.size());
        for (EntityRef er : this.cb.content) {
            l.add(er.pk);
        }
        return l;
    }

    private void treeMouseReleased(MouseEvent evt) {
        this.maybeShowTreePopup(evt);
    }

    private void treeMousePressed(MouseEvent evt) {
        this.maybeShowTreePopup(evt);
    }

    private void tabsStateChanged(ChangeEvent evt) {
        this.updateSelection(this.tree.getLeadSelectionPath());
    }

    private void maybeShowTreePopup(MouseEvent evt) {
        if (evt.isPopupTrigger() && evt.getSource() == this.tree) {
            TreePath tp = this.tree.getPathForRow(this.tree.getRowForLocation(evt.getX(), evt.getY()));
            if (tp != null) {
                this.tree.setSelectionPath(tp);
                if (this.cb.content.size() > 0) {
                    this.pegar.setEnabled(true);
                } else {
                    this.pegar.setEnabled(false);
                }
            }
            this.treePopup.show(this.tree, evt.getX(), evt.getY());
        }
    }

    public void refresh(boolean flushModel) {
        HashSet<Object> expanded = new HashSet<Object>();
        HashSet<Object> expanded2 = new HashSet<Object>();
        Enumeration<TreePath> e = this.tree.getExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        while (e != null && e.hasMoreElements()) {
            TreePath tp = e.nextElement();
            expanded2.add(tp.getLastPathComponent());
        }
        TreePath selectionPath = this.tree.getSelectionPath();
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            TreePath tp = this.tree.getPathForRow(i);
            this.tree.isExpanded(tp);
            expanded.add(tp.getLastPathComponent());
        }
        int h = this.jScrollPane1.getHorizontalScrollBar().getValue();
        int v = this.jScrollPane1.getVerticalScrollBar().getValue();
        if (flushModel) {
            this.treeModel.reload();
        }
        this.tree.setModel(null);
        this.tree.setModel(this.treeModel);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            TreePath tp = this.tree.getPathForRow(i);
            if (!expanded2.contains(tp.getLastPathComponent())) continue;
            this.tree.expandPath(tp);
        }
        this.tree.setSelectionPath(selectionPath);
        this.jScrollPane1.getHorizontalScrollBar().setValue(h);
        this.jScrollPane1.getVerticalScrollBar().setValue(v);
    }
}

