/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.swing;

import es.pablo.jee.ejb.exception.InvalidParameterException;
import es.pablo.jee.ejb.jms.PersistenceEvent;
import es.pablo.jee.ejb.jms.Refreshable;
import es.pablo.jee.ejb.jms.Refresher;
import es.pablo.jee.ejb.request.AppController;
import es.pablo.jee.ejb.swing.ClientSideModel;
import es.pablo.jee.ejb.swing.EntityChooserDialog;
import es.pablo.jee.ejb.swing.EntityCreator;
import es.pablo.jee.ejb.swing.EntityEditor;
import es.pablo.jee.entity.EntityMetaData;
import es.pablo.jee.entity.EntityRef;
import es.pablo.jee.entity.ForeignKey;
import es.pablo.jee.entity.Introspector;
import es.pablo.util.MonitorRendimiento;
import es.pablo.util.Util;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class FKComboBox
extends JComboBox
implements Refreshable {
    public static final String NUEVO = "<< NUEVO >>";
    public static final String BUSCAR = "<< BUSCAR >>";
    private AppController ac;
    private EntityMetaData emd;
    private EntityMetaData fkEmd;
    private String p;
    private Object pk;
    private EntityCreator ec;
    private EntityChooserDialog ecd;
    private boolean create;
    private boolean autoLoad;
    private Object lastSelected = null;
    JFrame parentFrame;

    public FKComboBox(Class c, String p) throws Exception {
        this(Introspector.getEntityMetaData(c), p, true);
    }

    public FKComboBox(EntityMetaData emd, String p, boolean create) throws Exception {
        this(null, emd, p, create, true);
    }

    public FKComboBox(JFrame parentFrame, EntityMetaData emd, String p, boolean create, boolean autoload) throws Exception {
        this.parentFrame = parentFrame;
        this.ac = EntityEditor.ac;
        this.autoLoad = autoload;
        this.emd = emd;
        this.p = p;
        this.create = create;
        MonitorRendimiento.getInstance().append("\t\t\t FKCombo box " + p + "de " + emd.name + " creada por: " + Thread.currentThread().getStackTrace()[2].toString(), System.currentTimeMillis());
        this.fkEmd = Introspector.getEntityMetaData(emd.columnClasses.get(p));
        Refresher.getInstance().subscribe(this.fkEmd.clazz, this);
        if (emd.fk.get((Object)p).card == ForeignKey.Card.OTO) {
            Refresher.getInstance().subscribe(emd.clazz, this);
        }
        this.refresh(null);
        final FKComboBox refreshable = this;
        if (create) {
            this.addActionListener(new ActionListener(){

                @Override
                public synchronized void actionPerformed(ActionEvent evt) {
                    try {
                        if (FKComboBox.this.isEditable() && FKComboBox.this.getSelectedItem() != null && FKComboBox.this.getSelectedItem().toString().length() > 0 && FKComboBox.this.getSelectedIndex() == -1) {
                            String s = (String)FKComboBox.this.getSelectedItem();
                            int idx = s.indexOf(" ");
                            if (idx != -1) {
                                s = s.substring(0, idx);
                            }
                            if (!FKComboBox.this.setSelectedString(s = s.toUpperCase())) {
                                int userResponse = JOptionPane.showConfirmDialog(refreshable, " No se encontro " + s + " \n\n Crear unha nova?", "Crear nova?", 0);
                                if (userResponse == 0) {
                                    JTextField tf = (JTextField)FKComboBox.this.getEntityCreator().fields.get(((FKComboBox)FKComboBox.this).fkEmd.id.get(0));
                                    if (tf != null) {
                                        tf.setText(s);
                                    }
                                    FKComboBox.this.setSelectedItem(null);
                                    FKComboBox.this.getEntityCreator().setVisible(true);
                                } else {
                                    FKComboBox.this.setSelectedItem(null);
                                    return;
                                }
                            }
                        }
                        if (FKComboBox.NUEVO.equals(FKComboBox.this.getSelectedItem())) {
                            FKComboBox.this.setSelectedItem(FKComboBox.this.lastSelected);
                            FKComboBox.this.openEntityCreator();
                        } else if (FKComboBox.BUSCAR.equals(FKComboBox.this.getSelectedItem())) {
                            FKComboBox.this.getEntityChooser().setVisible(true);
                            Object selectedPk = FKComboBox.this.getEntityChooser().getSelectedPk();
                            if (selectedPk != null) {
                                FKComboBox.this.setSelected(selectedPk);
                            } else {
                                FKComboBox.this.setSelectedItem(FKComboBox.this.lastSelected);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public synchronized EntityCreator getEntityCreator() throws Exception {
        if (this.ec == null) {
            this.ec = new EntityCreator(this.parentFrame, this.fkEmd);
            this.ec.setNotifyOnCreate(this);
            this.ec.setCloseOnCreate(true);
        }
        return this.ec;
    }

    public synchronized EntityChooserDialog getEntityChooser() throws Exception {
        if (this.ecd == null) {
            this.ecd = new EntityChooserDialog((Window)this.parentFrame, this.fkEmd.clazz);
        }
        return this.ecd;
    }

    public void openEntityCreator() throws Exception {
        if (this.emd.conditionedRefs.containsKey(this.p)) {
            for (String fp : this.getEntityCreator().fields.keySet()) {
                if (!this.fkEmd.columnClasses.get(fp).equals(this.emd.clazz)) continue;
                FKComboBox fc = (FKComboBox)this.getEntityCreator().fields.get(fp);
                fc.setSelected(this.pk);
                fc.setEnabled(false);
            }
        }
        this.getEntityCreator().setVisible(true);
    }

    public synchronized void setPk(Object pk) throws Exception {
        if (pk instanceof EntityRef) {
            pk = ((EntityRef)pk).pk;
        }
        if (pk != null && !pk.equals(this.pk)) {
            this.pk = pk;
            this.refresh(null);
        }
    }

    public synchronized boolean setSelectedString(String s) throws InvalidParameterException {
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object o = this.getItemAt(i);
            if (!(o instanceof EntityRef) || !((EntityRef)o).desc.startsWith(s)) continue;
            this.setSelectedItem(o);
            return true;
        }
        return false;
    }

    public synchronized void setSelected(Object pk) {
        if (pk == null || pk == EntityChooserDialog.NONE) {
            super.setSelectedItem(null);
            return;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object o = this.getItemAt(i);
            if (!(o instanceof EntityRef) || !((EntityRef)o).pk.equals(pk)) continue;
            this.setSelectedItem(o);
            return;
        }
        if (!this.autoLoad) {
            try {
                EntityRef er = ClientSideModel.getEntityRef(this.fkEmd.clazz, pk);
                super.addItem(er);
                super.setSelectedItem(er);
            }
            catch (Exception e) {
                Util.show((Component)this, (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void setSelectedItem(Object o) {
        this.lastSelected = this.getSelectedItem();
        super.setSelectedItem(o);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
    }

    @Override
    public synchronized void refresh(PersistenceEvent pe) throws Exception {
        if (pe != null && PersistenceEvent.Type.FULL_REFRESH.equals((Object)pe.type)) {
            pe = null;
        }
        if (!this.autoLoad) {
            if (pe != null && pe.clazz.equals(this.fkEmd) && !pe.type.equals((Object)PersistenceEvent.Type.CREATE)) {
                for (int i = 0; i < this.getItemCount(); ++i) {
                    Object o = this.getItemAt(i);
                    if (!(o instanceof EntityRef) || !((EntityRef)o).pk.equals(this.pk)) continue;
                    super.removeItemAt(i);
                    return;
                }
            }
            return;
        }
        long ts = System.currentTimeMillis();
        if (pe != null && !pe.clazz.equals(this.fkEmd.clazz) && !pe.clazz.equals(this.emd.clazz)) {
            throw new RuntimeException("Combo box got event that has nothing to do ");
        }
        Object reminder = super.getSelectedItem();
        int sidx = super.getSelectedIndex();
        Object[] sobject = super.getSelectedObjects();
        ArrayList<String> items = new ArrayList<String>();
        items.add(null);
        if (this.create) {
            items.add(NUEVO);
        }
        items.add(BUSCAR);
        List l = null;
        if (this.emd.conditionedRefs.containsKey(this.p)) {
            if (this.pk == null) {
                this.removeAllItems();
                this.setEnabled(false);
                return;
            }
            String cond = this.emd.conditionedRefs.get(this.p);
            int idx = cond.indexOf(".");
            if (idx != -1) {
                String entityName = cond.substring(0, idx);
                String property = cond.substring(idx + 1, cond.length());
                Class c = this.emd.columnClasses.get(entityName);
                if (this.pk == null) {
                    System.err.println("--------------aqui------------");
                }
                l = (List)this.ac.get(c, this.pk, property);
            } else {
                if (this.pk == null) {
                    System.err.println("--------------aqui------------");
                }
                l = (List)this.ac.get(this.emd.clazz, this.pk, cond);
            }
            this.setEnabled(true);
        } else {
            l = ClientSideModel.getFKValues(this.emd.clazz, this.p);
        }
        if (l == null) {
            items = new ArrayList();
        } else {
            items.addAll(l);
        }
        DefaultComboBoxModel<Object> cbm = new DefaultComboBoxModel<Object>(items.toArray());
        if (reminder != null) {
            cbm.setSelectedItem(reminder);
        }
        super.setModel(cbm);
        MonitorRendimiento.getInstance().append("\t\tFKComboBox " + this.p + " of " + this.emd.name + " total refresh time ", ts);
    }
}

