/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.swing;

import es.pablo.jee.ejb.request.AppController;
import es.pablo.jee.ejb.swing.ClientSideModel;
import es.pablo.jee.ejb.swing.EntityChooserDialog;
import es.pablo.jee.ejb.swing.EntityEditor;
import es.pablo.jee.entity.EntityMetaData;
import es.pablo.jee.entity.EntityRef;
import es.pablo.jee.entity.Introspector;
import es.pablo.util.MonitorRendimiento;
import es.pablo.util.Util;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class EntityTableModel2
extends AbstractTableModel {
    private EntityMetaData emd;
    private AppController ac;
    List pks;
    private ArrayList<String> columns;
    private boolean editable;
    public SoftReference[] cache;
    public LoaderThread2 loaderThread;
    long hits = 0L;
    long hitsAverageTime = 0L;
    public Map<String, CellPatch> patches = Collections.synchronizedMap(new HashMap());

    private EntityTableModel2() {
    }

    public EntityTableModel2(AppController ac, Class c, boolean editable) throws Exception {
        this(ac, c, editable, true, null);
    }

    public EntityTableModel2(AppController ac, Class c, boolean editable, boolean fks, List pks) throws Exception {
        this.ac = ac;
        this.emd = (EntityMetaData)Introspector.getBeanInfo(c).getBeanDescriptor().getValue("emd");
        this.columns = (ArrayList)this.emd.columnNames.clone();
        if (!fks) {
            this.columns.removeAll(this.emd.fk.keySet());
        }
        this.editable = editable;
        this.pks = new ArrayList();
        if (pks == null) {
            this.setPks(ClientSideModel.getPks(c));
        } else {
            this.setPks(pks);
        }
        this.flushCache();
    }

    private synchronized void startLoader() {
        if (this.loaderThread != null) {
            this.loaderThread.running = false;
        }
        this.loaderThread = new LoaderThread2();
        this.loaderThread.setName("TableModel Loader " + this.emd.clazz.getSimpleName());
        this.loaderThread.setPriority(1);
        this.loaderThread.start();
    }

    public EntityTableModel2 _clone() {
        EntityTableModel2 etm = new EntityTableModel2();
        etm.ac = this.ac;
        etm.emd = this.emd;
        etm.columns = new ArrayList<String>(this.columns);
        etm.editable = this.editable;
        etm.pks = new ArrayList(this.pks);
        return etm;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public synchronized void refresh() {
        this.setPks(this.pks);
    }

    public synchronized void setPks(List l) {
        if (l != null && l.equals(this.pks)) {
            return;
        }
        this.pks.clear();
        this.pks.addAll(l);
        this.fireTableDataChanged();
    }

    public synchronized void setPk(Object pk) {
        this.pks.clear();
        if (pk != null) {
            this.pks.add(pk);
        }
        this.fireTableDataChanged();
    }

    public synchronized List getPks() {
        return new ArrayList(this.pks);
    }

    public synchronized void removePk(Object pk) throws IllegalArgumentException {
        if (!this.pks.remove(pk)) {
            throw new IllegalArgumentException(pk + " no esta en la lista");
        }
        this.fireTableDataChanged();
    }

    public synchronized void addPk(Object pk) throws IllegalArgumentException {
        if (this.pks.contains(pk)) {
            throw new IllegalArgumentException(pk + " ya esta en la lista");
        }
        this.pks.add(pk);
        this.fireTableDataChanged();
    }

    public synchronized void clear() {
        this.pks.clear();
        this.fireTableDataChanged();
    }

    public boolean hasPk(Object pk) {
        return this.pks.contains(pk);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnIdentifier(String fieldName) {
        int idx = this.columns.indexOf(fieldName);
        if (idx == -1) {
            System.err.println("EntityTableModel " + fieldName + " not found in " + this.columns);
        }
        return this.getColumnName(idx);
    }

    @Override
    public String getColumnName(int c) {
        String cn = this.columns.get(c);
        return this.emd.columnDisplayNames.get(cn);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.editable) {
            return false;
        }
        String cn = this.columns.get(col);
        return !this.emd.id.contains(cn) && !this.emd.nonUpdatable.contains(cn);
    }

    public Class getColumnClass(int col) {
        Class cc = this.emd.columnClasses.get(this.columns.get(col));
        if (Introspector.isEntity(cc)) {
            return String.class;
        }
        return cc;
    }

    public Object getValueAt(Object pk, String property) {
        return this.getValueAt(this.pks.indexOf(pk), property);
    }

    public Object getValueAt(int r, String property) {
        int c = this.columns.indexOf(property);
        if (c != -1) {
            return this.getValueAt(r, c);
        }
        throw new IllegalArgumentException("Property " + property + " not found in columns " + this.columns);
    }

    @Override
    public synchronized Object getValueAt(int r, int c) {
        long ts = System.currentTimeMillis();
        ++this.hits;
        try {
            CellPatch cp;
            Object value = null;
            Object pk = this.pks.get(r);
            CacheEntry entry = null;
            SoftReference cachedValue = this.cache[r];
            if (cachedValue != null) {
                entry = (CacheEntry)cachedValue.get();
            }
            if (entry == null) {
                entry = new CacheEntry(ClientSideModel.get(this.emd.clazz, pk, this.pks, this.columns));
                this.cache[r] = new SoftReference<CacheEntry>(entry);
            }
            value = entry.values[c];
            long ts1 = System.currentTimeMillis();
            this.hitsAverageTime += ts1 - ts;
            if (this.hits == 100L) {
                this.hits = 0L;
                MonitorRendimiento.getInstance().ta.append("\n\t" + this.emd.clazz.getSimpleName() + " getValue() 100 hits in time " + this.hitsAverageTime);
                this.hitsAverageTime = 0L;
            }
            if ((cp = this.patches.get(this.columns.get(c))) != null) {
                return cp.patch(this.pks.get(r), this.columns.get(c), value);
            }
            return value;
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("Error en getValueAt " + r + " " + c + " " + t.getClass().getSimpleName() + "" + t.getMessage());
            return null;
        }
    }

    public synchronized void setValueAt(Object o, int r, String property) {
        int c = this.columns.indexOf(property);
        if (c == -1) {
            throw new IllegalArgumentException("Property " + property + " not found in columns " + this.columns);
        }
        this.setValueAt(o, r, c);
    }

    @Override
    public synchronized void setValueAt(Object o, int r, int c) {
        try {
            if (o == "<< NUEVO >>" || o == "<< BUSCAR >>") {
                return;
            }
            if (o instanceof EntityRef) {
                o = ((EntityRef)o).pk;
            } else if (o == EntityChooserDialog.NONE) {
                o = null;
            }
            String property = this.columns.get(c);
            Object pk = this.getPk(r);
            EntityEditor.ac.set(this.emd.clazz, pk, property, o);
        }
        catch (Exception e) {
            Util.show(null, (Throwable)e);
        }
    }

    @Override
    public synchronized int getRowCount() {
        return this.pks.size();
    }

    public synchronized Object getPk(int row) {
        return this.pks.get(row);
    }

    @Override
    public synchronized void fireTableRowsInserted(int firstRow, int lastRow) {
        this.flushCache();
        super.fireTableRowsInserted(firstRow, lastRow);
    }

    @Override
    public synchronized void fireTableDataChanged() {
        this.flushCache();
        super.fireTableDataChanged();
    }

    public synchronized void fireTableRowUpdated(Object pk) {
        int row = this.pks.indexOf(pk);
        if (row != -1) {
            this.fireTableRowsUpdated(row, row);
        }
    }

    @Override
    public synchronized void fireTableRowsUpdated(int firstRow, int lastRow) {
        for (int i = firstRow; i <= lastRow; ++i) {
            try {
                this.cache[i] = null;
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        super.fireTableRowsUpdated(firstRow, lastRow);
    }

    @Override
    public synchronized void fireTableStructureChanged() {
        this.flushCache();
        super.fireTableStructureChanged();
    }

    @Override
    public synchronized void fireTableChanged(TableModelEvent e) {
        this.flushCache();
        super.fireTableChanged(e);
    }

    @Override
    public synchronized void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.flushCache();
        super.fireTableRowsDeleted(firstRow, lastRow);
    }

    @Override
    public synchronized void fireTableCellUpdated(int row, int column) {
        try {
            this.cache[row] = null;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        super.fireTableCellUpdated(row, column);
    }

    private synchronized void flushCache() {
        if (this.loaderThread != null) {
            this.loaderThread.running = false;
        }
        this.cache = new SoftReference[this.getRowCount()];
    }

    public static interface CellPatch {
        public Object patch(Object var1, String var2, Object var3);
    }

    private class LoaderThread2
    extends Thread {
        public transient boolean running = true;

        private LoaderThread2() {
        }

        @Override
        public void run() {
            int pageSize = 500;
            int idx = 0;
            int endIdx = 0;
            while (this.running && endIdx < EntityTableModel2.this.getRowCount()) {
                endIdx = idx + pageSize;
                if (endIdx > EntityTableModel2.this.getRowCount()) {
                    endIdx = EntityTableModel2.this.getRowCount();
                }
                try {
                    Thread.sleep(100L);
                    ArrayList pksSublist = new ArrayList();
                    for (int i = idx; i < EntityTableModel2.this.getRowCount(); ++i) {
                        pksSublist.add(EntityTableModel2.this.pks.get(i));
                    }
                    long ts = System.currentTimeMillis();
                    Object[] data = EntityEditor.ac.get(((EntityTableModel2)EntityTableModel2.this).emd.clazz, pksSublist, (List<String>)EntityTableModel2.this.columns);
                    long ts2 = System.currentTimeMillis();
                    for (int i = 0; i < data.length; ++i) {
                        Object[] row = (Object[])data[i];
                        CacheEntry ce = new CacheEntry(row);
                        SoftReference<CacheEntry> sr = new SoftReference<CacheEntry>(ce);
                        if (this.running) {
                            EntityTableModel2.this.cache[i + idx] = sr;
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
                idx = endIdx;
            }
        }
    }

    private static class CacheEntry {
        public Object[] values;
        public boolean[] loaded;

        public CacheEntry(int cols) {
            this.values = new Object[cols];
            this.loaded = new boolean[cols];
        }

        public CacheEntry(Object[] data) {
            this.values = data;
            this.loaded = new boolean[data.length];
            for (int i = 0; i < data.length; ++i) {
                this.loaded[i] = true;
            }
        }
    }
}

