/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.swing;

import es.pablo.jee.ejb.request.AppController;
import es.pablo.jee.ejb.swing.ClientSideModel;
import es.pablo.jee.ejb.swing.EntityChooserDialog;
import es.pablo.jee.ejb.swing.EntityEditor;
import es.pablo.jee.entity.EntityMetaData;
import es.pablo.jee.entity.EntityRef;
import es.pablo.jee.entity.Introspector;
import es.pablo.jee.entity.LobFile;
import es.pablo.util.MonitorRendimiento;
import es.pablo.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class EntityTableModel
extends AbstractTableModel {
    private EntityMetaData emd;
    private AppController ac;
    public static boolean SHOW_LOADING = false;
    public static String LOADING = "Cargando...";
    List pks;
    private ArrayList<String> columns;
    private boolean editable;
    long hits = 0L;
    long hitsAverageTime = 0L;
    public Map<String, CellPatch> patches = Collections.synchronizedMap(new HashMap());

    private EntityTableModel() {
    }

    public EntityTableModel(AppController ac, Class c, boolean editable) throws Exception {
        this(ac, c, editable, true, null);
    }

    public EntityTableModel(AppController ac, Class c, boolean editable, boolean fks, List pks) throws Exception {
        this.ac = ac;
        this.emd = (EntityMetaData)Introspector.getBeanInfo(c).getBeanDescriptor().getValue("emd");
        this.columns = (ArrayList)this.emd.columnNames.clone();
        if (!fks) {
            this.columns.removeAll(this.emd.fk.keySet());
        }
        this.editable = editable;
        this.pks = new ArrayList();
        if (pks == null) {
            this.setPks(ClientSideModel.getPks(c));
        } else {
            this.setPks(pks);
        }
    }

    public EntityTableModel _clone() {
        EntityTableModel etm = new EntityTableModel();
        etm.ac = this.ac;
        etm.emd = this.emd;
        etm.columns = new ArrayList<String>(this.columns);
        etm.editable = this.editable;
        etm.pks = new ArrayList(this.pks);
        return etm;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public synchronized void refresh() {
        this.setPks(this.pks);
    }

    public synchronized void setPks(List l) {
        if (l != null && l.equals(this.pks)) {
            return;
        }
        this.pks.clear();
        this.pks.addAll(l);
        this.fireTableDataChanged();
    }

    public synchronized void setPk(Object pk) {
        this.pks.clear();
        if (pk != null) {
            this.pks.add(pk);
        }
        this.fireTableDataChanged();
    }

    public synchronized List getPks() {
        return new ArrayList(this.pks);
    }

    public synchronized void removePk(Object pk) throws IllegalArgumentException {
        if (!this.pks.remove(pk)) {
            throw new IllegalArgumentException(pk + " no esta en la lista");
        }
        this.fireTableDataChanged();
    }

    public synchronized void addPk(Object pk) throws IllegalArgumentException {
        if (this.pks.contains(pk)) {
            throw new IllegalArgumentException(pk + " ya esta en la lista");
        }
        this.pks.add(pk);
        this.fireTableDataChanged();
    }

    public synchronized void clear() {
        this.pks.clear();
        this.fireTableDataChanged();
    }

    public boolean hasPk(Object pk) {
        return this.pks.contains(pk);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnIdentifier(String fieldName) {
        int idx = this.columns.indexOf(fieldName);
        if (idx == -1) {
            System.err.println("EntityTableModel " + fieldName + " not found in " + this.columns);
        }
        return this.getColumnName(idx);
    }

    @Override
    public String getColumnName(int c) {
        String cn = this.columns.get(c);
        return this.emd.columnDisplayNames.get(cn);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.editable) {
            return false;
        }
        String cn = this.columns.get(col);
        return !this.emd.id.contains(cn) && !this.emd.nonUpdatable.contains(cn);
    }

    public Class getColumnClass(int col) {
        Class cc = this.emd.columnClasses.get(this.columns.get(col));
        if (Introspector.isEntity(cc)) {
            return String.class;
        }
        return cc;
    }

    public Object getValueAt(Object pk, String property) {
        return this.getValueAt(this.pks.indexOf(pk), property);
    }

    public Object getValueAt(int r, String property) {
        int c = this.columns.indexOf(property);
        if (c != -1) {
            return this.getValueAt(r, c);
        }
        throw new IllegalArgumentException("Property " + property + " not found in columns " + this.columns);
    }

    @Override
    public synchronized Object getValueAt(int r, int c) {
        long ts = System.currentTimeMillis();
        ++this.hits;
        try {
            CellPatch cp;
            Object value = null;
            Object pk = this.pks.get(r);
            Object[] row = new Object[this.columns.size()];
            if (SHOW_LOADING && !ClientSideModel.getInstance().getTable(this.emd.clazz).isAvailable(pk, this.pks)) {
                Class clazz = this.getColumnClass(c);
                if (clazz.equals(LobFile.class) || clazz.equals(String.class)) {
                    return LOADING;
                }
                return null;
            }
            row = ClientSideModel.get(this.emd.clazz, pk, this.pks, this.columns);
            value = row[c];
            long ts1 = System.currentTimeMillis();
            this.hitsAverageTime += ts1 - ts;
            if (this.hits == 100L) {
                this.hits = 0L;
                MonitorRendimiento.getInstance().ta.append("\n\t" + this.emd.clazz.getSimpleName() + " getValue() 100 hits in time " + this.hitsAverageTime);
                this.hitsAverageTime = 0L;
            }
            if ((cp = this.patches.get(this.columns.get(c))) != null) {
                return cp.patch(this.pks.get(r), this.columns.get(c), value);
            }
            return value;
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("Error en getValueAt " + r + " " + c + " " + t.getClass().getSimpleName() + "" + t.getMessage());
            return null;
        }
    }

    public synchronized void setValueAt(Object o, int r, String property) {
        int c = this.columns.indexOf(property);
        if (c == -1) {
            throw new IllegalArgumentException("Property " + property + " not found in columns " + this.columns);
        }
        this.setValueAt(o, r, c);
    }

    @Override
    public synchronized void setValueAt(Object o, int r, int c) {
        try {
            if (o == "<< NUEVO >>" || o == "<< BUSCAR >>") {
                return;
            }
            if (o instanceof EntityRef) {
                o = ((EntityRef)o).pk;
            } else if (o == EntityChooserDialog.NONE) {
                o = null;
            }
            String property = this.columns.get(c);
            Object pk = this.getPk(r);
            EntityEditor.ac.set(this.emd.clazz, pk, property, o);
        }
        catch (Exception e) {
            Util.show(null, (Throwable)e);
        }
    }

    @Override
    public synchronized int getRowCount() {
        return this.pks.size();
    }

    public synchronized Object getPk(int row) {
        return this.pks.get(row);
    }

    public synchronized void fireTableRowUpdated(Object pk) {
        int row = this.pks.indexOf(pk);
        if (row != -1) {
            this.fireTableRowsUpdated(row, row);
        }
    }

    public static interface CellPatch {
        public Object patch(Object var1, String var2, Object var3);
    }
}

