/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.swing;

import es.pablo.jee.ejb.swing.Clipboard;
import es.pablo.jee.ejb.swing.EntityEditor;
import es.pablo.jee.ejb.swing.tree.EntityTree;
import es.pablo.jee.entity.BackRef;
import es.pablo.jee.entity.EntityRef;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class EntityEditorPopup
extends MouseAdapter
implements ActionListener {
    private boolean supportsCopy = false;
    EntityEditor ee = null;
    EntityTree et;
    Clipboard cb = null;
    JPopupMenu popup = new JPopupMenu();
    JMenuItem cortar = new JMenuItem("Cortar");
    JMenuItem copiar = new JMenuItem("Copiar");
    JMenuItem pegar = new JMenuItem("Pegar");

    public EntityEditorPopup(EntityTree tree, EntityEditor ee) {
        this.ee = ee;
        this.cb = tree.getClipBoard();
        this.et = tree;
        EntityEditor.BrList brList = (EntityEditor.BrList)ee.pKs;
        this.supportsCopy = brList.getBackRef().card.equals((Object)BackRef.Card.MTM);
        this.cortar.addActionListener(this);
        this.copiar.addActionListener(this);
        this.pegar.addActionListener(this);
        this.popup.add(this.cortar);
        if (this.supportsCopy) {
            this.popup.add(this.copiar);
        }
        ee.getEntityTable().addMouseListener(this);
    }

    public boolean isSupportsCopy() {
        return this.supportsCopy;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.pegar) {
            List l = this.ee.getSelectedPks();
            ArrayList<EntityRef> l2 = new ArrayList<EntityRef>(l.size());
            for (Object o : l) {
                l2.add(new EntityRef(o, ""));
            }
            this.cb.clipboardType = this.ee.emd.clazz;
            this.cb.content = new ArrayList<EntityRef>();
            List pks = this.ee.getSelectedPks();
            for (Object o : pks) {
                this.cb.content.add(new EntityRef(o, ""));
            }
            this.cb.fromPk = this.getBrList().getPk();
            this.cb.fromPropterty = this.getBrList().getBackRef().onProperty;
            this.cb.fromType = this.getBrList().getBackRef().onClass;
            if (e.getSource() == this.cortar) {
                this.cb.isCut = true;
                if (this.cb.fromType.equals(this.et.getClazz())) {
                    this.cb.cutFromTp = this.et.getTree().getSelectionPath();
                    this.cb.cutChildIdxs = new int[this.cb.content.size()];
                    for (int i = 0; i < this.cb.cutChildIdxs.length; ++i) {
                        EntityRef wrapper = new EntityRef((Object)this.cb.content.get(i), this.cb.content.get(i));
                        this.cb.cutChildIdxs[i] = this.et.getTreeModel().getIndexOfChild(this.cb.cutFromTp.getLastPathComponent(), wrapper);
                    }
                }
            } else if (e.getSource().equals(this.copiar)) {
                this.cb.isCut = false;
                this.cb.cutFromTp = null;
                this.cb.cutChildIdxs = null;
            }
        }
    }

    private EntityEditor.BrList getBrList() {
        return (EntityEditor.BrList)this.ee.pKs;
    }

    public void setSupportsCopy(boolean supportsCopy) {
        this.supportsCopy = supportsCopy;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            if (this.ee.pKs instanceof EntityEditor.BrList) {
                EntityEditor.BrList brList = (EntityEditor.BrList)this.ee.pKs;
                if (this.ee.getSelectedPks().size() > 0) {
                    this.cortar.setEnabled(true);
                    this.copiar.setEnabled(this.supportsCopy);
                } else {
                    this.cortar.setEnabled(false);
                    this.copiar.setEnabled(false);
                }
                if (this.cb.content.size() > 0) {
                    this.pegar.setEnabled(true);
                } else {
                    this.pegar.setEnabled(false);
                }
                this.popup.show(this.ee.getEntityTable(), evt.getX(), evt.getY());
            } else {
                System.err.println("Not a back ref ee");
            }
        }
    }
}

