/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.swing;

import es.pablo.jee.ejb.jms.PersistenceEvent;
import es.pablo.jee.ejb.jms.Refreshable;
import es.pablo.jee.ejb.jms.Refresher;
import es.pablo.jee.ejb.request.AppController;
import es.pablo.jee.ejb.request.RemoteFacade;
import es.pablo.jee.ejb.swing.ClientSideModel;
import es.pablo.jee.ejb.swing.EntityChooserDialog;
import es.pablo.jee.ejb.swing.EntityCreator;
import es.pablo.jee.ejb.swing.EntityTableModel;
import es.pablo.jee.ejb.swing.FKComboBox;
import es.pablo.jee.entity.BackRef;
import es.pablo.jee.entity.EntityMetaData;
import es.pablo.jee.entity.ForeignKey;
import es.pablo.jee.entity.Image;
import es.pablo.jee.entity.Introspector;
import es.pablo.jee.entity.PkList;
import es.pablo.jee.entity.ServerFile;
import es.pablo.jee.entity.TemporalFormat;
import es.pablo.swing.DateCellEditor;
import es.pablo.swing.DateCellRenderer;
import es.pablo.swing.DbFileRenderer;
import es.pablo.swing.DecimalCellEditor;
import es.pablo.swing.DecimalCellRenderer;
import es.pablo.swing.EntityChooserCellEditor;
import es.pablo.swing.EnumCellEditor;
import es.pablo.swing.FileCellEditor;
import es.pablo.swing.ImagenRenderer;
import es.pablo.swing.TextAreaCellRenderer;
import es.pablo.swing.TextCellEditor;
import es.pablo.util.MonitorRendimiento;
import es.pablo.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class EntityEditor
extends JPanel
implements Printable,
Refreshable {
    public String nickname;
    public JFrame frame;
    public static AppController ac;
    public static RemoteFacade facade;
    boolean editable;
    boolean creable;
    boolean deletable;
    boolean backRefs;
    boolean fks;
    boolean searchable;
    public EntityMetaData emd;
    public List pKs;
    SearchList searchList;
    public EntityTableModel etm;
    private EntityCreator ec;
    private JFrame parentFrame;
    Font tableFont = null;
    private final JTextField searchField = new JTextField();
    HashMap<String, FKComboBox> comboFks = new HashMap();
    public HashMap<String, EntityEditor> brEEs = new HashMap();
    HashMap<String, JDialog> brDialog = new HashMap();
    HashMap<String, JButton> brButtons = new HashMap();
    public JButton deleteButton;
    public JButton searchButton;
    public JButton nuevoButton;
    private Printable printableTable;
    private JCheckBox checkBoxBarraHorizontal;
    private final Object refreshLock = new Object();
    private JPanel headerPanel;
    JTable entityTable;
    public JPanel footerPanel;
    JScrollPane jScrollPane1;

    private EntityEditor() {
        this.initComponents();
        if (EntityTableModel.SHOW_LOADING) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(1000L);
                                if (EntityEditor.this.entityTable == null) continue;
                                EventQueue.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        EntityEditor.this.entityTable.repaint();
                                    }
                                });
                            }
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                }
            };
            t.start();
        }
    }

    public EntityEditor(Class c) throws Exception {
        this(c, true, true, true, null, null);
    }

    public EntityEditor(JFrame frame, Class c) throws Exception {
        this(frame, c, true, true, true, true, true, true, true, null, null);
    }

    public EntityEditor(Class c, boolean editable, boolean backRefs, boolean fks, Font f, List pKs) throws Exception {
        this(c, editable, true, true, backRefs, fks, f, pKs);
    }

    public EntityEditor(Class c, boolean editable, boolean creable, boolean searchable, boolean backRefs, boolean fks, Font f, List pkList) throws Exception {
        this(c, editable, creable, editable && backRefs, searchable, backRefs, fks, f, pkList);
    }

    public EntityEditor(Class c, boolean editable, boolean creable, boolean deletable, boolean searchable, boolean backRefs, boolean fks, Font f, List pkList) throws Exception {
        this(c, editable, creable, deletable, searchable, backRefs, fks, false, f, pkList);
    }

    public EntityEditor(Class c, boolean editable, boolean creable, boolean deletable, boolean searchable, boolean backRefs, boolean fks, boolean printable, Font f, List pkList) throws Exception {
        this(null, c, editable, creable, deletable, searchable, backRefs, fks, printable, f, pkList);
    }

    public EntityEditor(JFrame frame, Class c, boolean editable, boolean creable, boolean deletable, boolean searchable, boolean backRefs, boolean fks, boolean printable, Font f, List pkList) throws Exception {
        this();
        long ts = System.currentTimeMillis();
        this.frame = frame;
        this.backRefs = backRefs;
        this.editable = editable;
        this.deletable = deletable;
        this.searchable = searchable;
        this.creable = creable;
        this.tableFont = f;
        this.fks = fks;
        this.emd = Introspector.getEntityMetaData(c);
        this.pKs = pkList;
        if (pkList instanceof PkList) {
            pkList = ((PkList)this.pKs).getList();
        }
        this.etm = new EntityTableModel(ac, this.emd.clazz, editable, fks, pkList);
        this.entityTable.setModel(this.etm);
        this.setSelected(new ArrayList());
        this.entityTable.getSelectionModel().addListSelectionListener(new ListSelectionListenerImpl());
        Refresher.getInstance().subscribe(c, this);
        TableColumnModel tcm = this.entityTable.getColumnModel();
        for (int i = 0; i < this.etm.getColumns().size(); ++i) {
            TableCellEditor tce;
            String id = this.etm.getColumns().get(i);
            if (this.emd.br.containsKey(id)) continue;
            int idx = tcm.getColumnIndex(this.emd.columnDisplayNames.get(id));
            TableColumn tc = tcm.getColumn(idx);
            Class type = this.emd.columnClasses.get(id);
            boolean nullable = this.emd.isNullable(id);
            if (Number.class.isAssignableFrom(type)) {
                tc.setPreferredWidth(40);
                DecimalFormat df = this.emd.decimalFormat.get(id);
                if (df != null) {
                    tc.setCellRenderer(new DecimalCellRenderer(df, nullable));
                    if (editable) {
                        tc.setCellEditor(new DecimalCellEditor(df, nullable));
                    }
                }
            }
            if (Boolean.class.isAssignableFrom(type)) {
                tc.setPreferredWidth(40);
            }
            if (editable && Enum.class.isAssignableFrom(type)) {
                DefaultCellEditor ce = EnumCellEditor.createEditor(type, nullable);
                tc.setCellEditor(ce);
                ce.setClickCountToStart(2);
            } else if (Date.class.isAssignableFrom(type)) {
                SimpleDateFormat sdf = this.emd.temporalFormat.get(id);
                SimpleDateFormat rf = TemporalFormat.getRenderingFormat(sdf);
                tc.setCellRenderer(new DateCellRenderer(rf, nullable));
                if (editable) {
                    tc.setCellEditor(new DateCellEditor(sdf, nullable));
                }
                tc.setPreferredWidth(120);
            } else if (this.emd.fk.containsKey(id)) {
                ForeignKey fk = this.emd.fk.get(id);
                if (editable && this.emd.conditionedRefs.containsKey(id)) {
                    FKComboBox fkcb = new FKComboBox(this.emd, id, editable);
                    DefaultCellEditor ce = new DefaultCellEditor(fkcb);
                    ce.setClickCountToStart(2);
                    tc.setCellEditor(ce);
                    this.comboFks.put(id, fkcb);
                } else if (editable) {
                    EntityChooserCellEditor tce2 = new EntityChooserCellEditor(this, fk.targetEntity);
                    tc.setCellEditor(tce2);
                }
                DefaultRowSorter drs = (DefaultRowSorter)this.entityTable.getRowSorter();
                drs.setComparator(idx, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        if (o1 != null && o1 instanceof Comparable) {
                            return ((Comparable)o1).compareTo(o2);
                        }
                        if (o2 != null && o2 instanceof Comparable) {
                            return ((Comparable)o2).compareTo(o1);
                        }
                        return ("" + o1).compareTo("" + o2);
                    }
                });
            } else if (this.emd.file.contains(id) || this.emd.dbFiles.containsKey(id)) {
                int maxSize;
                Image im = this.emd.images.get(id);
                int n = maxSize = im != null && im.maxSize() != -1 ? im.maxSize() : 150;
                if (this.emd.file.contains(id) && im != null) {
                    ImagenRenderer ir = new ImagenRenderer(this.emd.clazz, id, true, im.maxSize());
                    tc.setCellRenderer(ir);
                } else if (this.emd.dbFiles.containsKey(id)) {
                    DbFileRenderer dr = new DbFileRenderer(id, this, maxSize);
                    tc.setCellRenderer(dr);
                }
                if (editable) {
                    Class<ServerFile> targetClass = this.emd.dbFiles.get(id);
                    if (targetClass == null) {
                        targetClass = ServerFile.class;
                    }
                    FileCellEditor fce = new FileCellEditor(this.entityTable, im, targetClass);
                    tc.setCellEditor(fce);
                    ((DefaultRowSorter)this.entityTable.getRowSorter()).setSortable(tc.getModelIndex(), false);
                }
            } else if (this.emd.text.contains(id)) {
                tc.setCellRenderer(new TextAreaCellRenderer());
                tce = new TextCellEditor();
                tc.setCellEditor(tce);
            }
            if (this.tableFont == null || !((tce = tc.getCellEditor()) instanceof JComponent)) continue;
            ((JComponent)((Object)tce)).setFont(this.tableFont);
        }
        if (this.tableFont != null) {
            this.entityTable.setFont(this.tableFont);
            this.getEntityTable().getTableHeader().setFont(this.tableFont);
            this.entityTable.setRowHeight(this.tableFont.getSize());
            DefaultCellEditor dc = (DefaultCellEditor)this.entityTable.getDefaultEditor(String.class);
            if (dc != null) {
                dc.getComponent().setFont(this.tableFont);
            }
            if ((dc = (DefaultCellEditor)this.entityTable.getDefaultEditor(Number.class)) != null) {
                dc.getComponent().setFont(this.tableFont);
            }
        }
        this.footerPanel = new JPanel();
        if (searchable) {
            this.searchList = new SearchList();
            this.searchList.completeList = this.pKs;
            this.searchField.setColumns(30);
            this.searchField.setBorder(BorderFactory.createTitledBorder(null, "Busqueda", 0, 0, new Font("Tahoma", 0, 14)));
            this.searchField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String s = EntityEditor.this.searchField.getText().trim();
                    EntityEditor.this.pKs = s.length() > 0 ? EntityEditor.this.searchList : EntityEditor.this.searchList.completeList;
                    EntityEditor.this.refresh(null);
                }
            });
            this.footerPanel.add(this.searchField);
        }
        if (creable) {
            this.nuevoButton = new JButton();
            this.nuevoButton.setText("Nuevo");
            this.nuevoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EntityEditor.this.getEntityCreator().setVisible(false);
                    EntityEditor.this.getEntityCreator().setVisible(true);
                }
            });
            this.footerPanel.add(this.nuevoButton);
        }
        if (deletable) {
            this.deleteButton = new JButton();
            this.deleteButton.setText("Eliminar");
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EntityEditor.this.delete();
                }
            });
            this.footerPanel.add(this.deleteButton);
        }
        if (printable) {
            JButton printButton = new JButton();
            printButton.setText("Imprimir");
            printButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EntityEditor.this.print(null, null);
                }
            });
            this.footerPanel.add(printButton);
        }
        if (backRefs) {
            for (final String p : this.emd.br.keySet()) {
                JButton brButton = new JButton("Ver " + this.emd.columnDisplayNames.get(p));
                brButton.setEnabled(true);
                brButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        EntityEditor.this.showBr(p, true);
                    }
                });
                this.footerPanel.add(brButton);
                this.brButtons.put(p, brButton);
            }
        }
        if (backRefs || deletable || searchable) {
            JButton refreshButton = new JButton("Actualizar");
            refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        ClientSideModel.getInstance().flushCache(EntityEditor.this.emd.clazz);
                        ImagenRenderer.flushCache();
                    }
                    catch (Exception e) {
                        Util.show((Component)EntityEditor.this.entityTable, (Throwable)e);
                    }
                    EntityEditor.this.refresh(null);
                }
            });
            this.footerPanel.add(refreshButton);
            this.add((Component)this.footerPanel, "Last");
        }
        MonitorRendimiento.getInstance().append("\n\tEntityEditor constructor " + this.emd.name, ts);
    }

    public synchronized EntityCreator getEntityCreator() {
        if (this.ec == null) {
            try {
                this.ec = new EntityCreator(this.parentFrame, this.emd);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new Error(t.getMessage());
            }
        }
        return this.ec;
    }

    public List getSelectedPks() {
        int[] srs = this.entityTable.getSelectedRows();
        ArrayList<Object> l = new ArrayList<Object>();
        for (int s : srs) {
            int j = this.entityTable.convertRowIndexToModel(s);
            l.add(this.etm.getPk(j));
        }
        return l;
    }

    public List getSelectedObjects() throws Exception {
        return facade.findMany(this.emd.clazz, this.getSelectedPks());
    }

    public void setMinColWidth(int idx, int size) {
        this.getEntityTable().getColumnModel().getColumn(idx).setMinWidth(size);
    }

    public boolean setMinColWidth(String column, int size) {
        String id = this.etm.getColumnIdentifier(column);
        int idx = this.entityTable.getColumnModel().getColumnIndex(id);
        if (idx != -1) {
            this.getEntityTable().getColumnModel().getColumn(idx).setMinWidth(size);
            return true;
        }
        return false;
    }

    public boolean fixColumn(String column, int size) {
        TableColumn tc = this.getColumn(column);
        if (tc != null) {
            tc.setResizable(true);
            tc.setMinWidth(size);
            tc.setMaxWidth(size);
            tc.setResizable(false);
            return true;
        }
        return false;
    }

    public TableColumn getColumn(String column) {
        String id = this.etm.getColumnIdentifier(column);
        int idx = this.entityTable.getColumnModel().getColumnIndex(id);
        if (idx != -1) {
            return this.getEntityTable().getColumnModel().getColumn(idx);
        }
        return null;
    }

    public void removeColumns(String[] columns) {
        for (String c : columns) {
            String id = this.etm.getColumnIdentifier(c);
            int idx = this.getEntityTable().getColumnModel().getColumnIndex(id);
            if (idx == -1) continue;
            TableColumn t = this.getEntityTable().getColumnModel().getColumn(idx);
            this.getEntityTable().removeColumn(t);
        }
    }

    public synchronized JTable cloneTable() {
        EntityTableModel etmCopy = this.etm._clone();
        JTable copy = new JTable(etmCopy, this.entityTable.getColumnModel(), this.entityTable.getSelectionModel());
        copy.setFont(this.entityTable.getFont());
        copy.setTableHeader(this.entityTable.getTableHeader());
        copy.setRowHeight(this.entityTable.getRowHeight());
        copy.setRowMargin(this.entityTable.getRowMargin());
        return copy;
    }

    public synchronized JTable cloneTableWithSelectedRows() {
        int[] srs = this.entityTable.getSelectedRows();
        ArrayList newPks = new ArrayList();
        for (int i : srs) {
            int j = this.entityTable.convertRowIndexToModel(i);
            newPks.add(this.etm.pks.get(j));
        }
        EntityTableModel etmCopy = this.etm._clone();
        etmCopy.pks = newPks;
        JTable copy = new JTable(etmCopy, this.entityTable.getColumnModel());
        copy.setDefaultRenderer(Object.class, this.entityTable.getDefaultRenderer(Object.class));
        copy.setFont(this.entityTable.getFont());
        copy.setTableHeader(this.entityTable.getTableHeader());
        copy.setRowHeight(this.entityTable.getRowHeight());
        copy.setRowMargin(this.entityTable.getRowMargin());
        return copy;
    }

    public synchronized EntityEditor getBrEE(String p) {
        return this.getBrEE(p, this.editable, this.creable, this.deletable, this.searchable, this.backRefs, this.fks, this.getTableFont());
    }

    public synchronized EntityEditor getBrEE(final String p, boolean editable, boolean creable, boolean deletable, boolean searchable, boolean backRefs, boolean fks, Font font) {
        long ts = System.currentTimeMillis();
        EntityEditor bree = null;
        if (!this.brEEs.containsKey(p)) {
            BackRef br = this.emd.br.get(p);
            if (br == null) {
                throw new Error("No se encontro " + p + " en " + this.emd.br);
            }
            final Class brClass = br.source;
            try {
                BrList brList = new BrList(br);
                bree = new EntityEditor(brClass, editable, creable, deletable, searchable, backRefs, fks, font == null ? this.getTableFont() : font, brList);
                bree.setHorizontalScrollBars(true);
                final EntityEditor _bree = bree;
                final BrList _brList = brList;
                if (br.card == BackRef.Card.MTM && "".equals(br.sourceFK)) {
                    final EntityChooserDialog ecd = new EntityChooserDialog(null, brClass);
                    ecd.setMultipleSelection();
                    JButton b = new JButton("A\u00f1adir " + brClass.getSimpleName());
                    b.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                Object pk = _brList.getPk();
                                List currentPks = _bree.etm.getPks();
                                List selectablePks = ClientSideModel.getPks(brClass);
                                selectablePks.removeAll(currentPks);
                                ecd.ee.setPKs(selectablePks);
                                ecd.setVisible(true);
                                List ret = ecd.getSelectedPks();
                                if (ret != null && ret.size() > 0 && ret.get(0) != EntityChooserDialog.NONE) {
                                    facade.addChildren(EntityEditor.this.emd.clazz, pk, p, brClass, ret);
                                }
                            }
                            catch (Exception ex) {
                                Util.show((Component)_bree, (Throwable)ex);
                            }
                        }
                    });
                    JButton b2 = new JButton("Quitar " + brClass.getSimpleName());
                    b2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                Object pk = _brList.getPk();
                                List toRemovePks = _bree.getSelectedPks();
                                if (toRemovePks.size() > 0) {
                                    facade.unbindRemote(EntityEditor.this.emd.clazz, pk, p, brClass, toRemovePks);
                                }
                            }
                            catch (Exception ex) {
                                Util.show((Component)_bree, (Throwable)ex);
                            }
                        }
                    });
                    bree.footerPanel.add(b);
                    bree.footerPanel.add(b2);
                }
                this.brEEs.put(p, bree);
                List l = this.getSelectedPks();
                if (l.size() > 0) {
                    brList.setPk(l.get(0));
                }
            }
            catch (Exception e) {
                Util.show((Component)this, (Throwable)e);
            }
        } else {
            bree = this.brEEs.get(p);
        }
        MonitorRendimiento.getInstance().append(this.emd.name + "getBrEE(" + p + ")", ts);
        return bree;
    }

    private synchronized boolean showBr(String p, boolean setVisible) {
        if (!setVisible && !this.brEEs.containsKey(p)) {
            return false;
        }
        long ts = System.currentTimeMillis();
        JDialog jd = null;
        EntityEditor bree = this.getBrEE(p);
        List l = this.getSelectedPks();
        if (l.size() > 0) {
            ((PkList)bree.pKs).setPk(l.get(0));
        } else {
            ((PkList)bree.pKs).setPk(null);
        }
        bree.refresh(null);
        if (setVisible) {
            if (!this.brDialog.containsKey(p)) {
                jd = new JDialog((Frame)this.getParentFrame(), false);
                jd.setDefaultCloseOperation(2);
                this.brDialog.put(p, jd);
                jd.add(bree);
            } else {
                jd = this.brDialog.get(p);
            }
            jd.setTitle(this.emd.columnDisplayNames.get(p) + " de " + this.emd.name + " " + this.getSelectedPks());
            jd.pack();
            jd.setVisible(setVisible);
        }
        MonitorRendimiento.getInstance().append("\t\t" + this.emd.name + " showBr(" + p + "," + setVisible + "", ts);
        return true;
    }

    private synchronized void delete() {
        int[] srs = this.entityTable.getSelectedRows();
        if (srs.length > 0) {
            int result = JOptionPane.showConfirmDialog(this, "Eliminar " + srs.length + " lineas?", "Eliminar " + this.emd.name, 0);
            if (result != 0) {
                return;
            }
            try {
                ArrayList<Object> pksToRemove = new ArrayList<Object>();
                for (int r : srs) {
                    int row = this.entityTable.convertRowIndexToModel(r);
                    pksToRemove.add(this.etm.getPk(row));
                }
                Object object = pksToRemove.iterator();
                while (object.hasNext()) {
                    Object pk = object.next();
                    try {
                        ac.remove(this.emd.clazz, pk);
                    }
                    catch (Exception e) {
                        Util.show((Component)this, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                Util.show((Component)this, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(PersistenceEvent pe) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.refreshImpl(pe);
        }
    }

    private void refreshImpl(PersistenceEvent pe) {
        System.out.println(Thread.currentThread() + " 0 Refrescando entityEditor " + this.nickname + " " + this.emd.name + " pe " + pe + " 0");
        if (pe != null && PersistenceEvent.Type.FULL_REFRESH.equals((Object)pe.type)) {
            pe = null;
        }
        long ts = System.currentTimeMillis();
        if (pe == null || pe.type == PersistenceEvent.Type.CREATE || pe.type == PersistenceEvent.Type.DELETE && this.etm.hasPk(pe.pk) || pe.type == PersistenceEvent.Type.UPDATE) {
            try {
                List pks;
                int[] srs = this.entityTable.getSelectedRows();
                Object[] selectedPks = new Object[srs.length];
                int j = 0;
                for (int sr : srs) {
                    try {
                        int row = this.entityTable.convertRowIndexToModel(sr);
                        selectedPks[j++] = this.etm.pks.get(row);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                if (this.pKs instanceof PkList) {
                    System.out.println("DL Refrescando entityEditor " + this.emd.name + " pe " + pe + " " + this.pKs);
                    pks = ((PkList)this.pKs).getList();
                    if (pe == null || !this.etm.pks.containsAll(pks) || !pks.containsAll(this.etm.pks)) {
                        this.etm.setPks(pks);
                    } else if (pe.type == PersistenceEvent.Type.UPDATE && this.etm.hasPk(pe.pk)) {
                        this.etm.fireTableRowUpdated(pe.pk);
                    }
                } else if (this.pKs == null) {
                    System.out.println("this.pks==null Refrescando entityEditor " + this.emd.name + " pe " + pe);
                    if (pe != null && pe.type == PersistenceEvent.Type.UPDATE) {
                        this.etm.fireTableRowUpdated(pe.pk);
                    } else {
                        pks = ClientSideModel.getPks(this.emd.clazz);
                        this.etm.setPks(pks);
                    }
                } else if (pe != null && pe.type == PersistenceEvent.Type.UPDATE && this.etm.hasPk(pe.pk)) {
                    this.etm.fireTableRowUpdated(pe.pk);
                } else if (pe != null && pe.type == PersistenceEvent.Type.DELETE && this.etm.hasPk(pe.pk)) {
                    this.pKs.remove(pe.pk);
                    this.etm.setPks(this.pKs);
                } else if (pe == null) {
                    List _pks = this.pKs instanceof PkList ? ((PkList)this.pKs).getList() : this.pKs;
                    this.etm.setPks(_pks);
                }
                this.setSelected(Arrays.asList(selectedPks));
            }
            catch (Exception e) {
                Util.show((Component)this, (Throwable)e);
            }
        }
        MonitorRendimiento.getInstance().append("EntityEditor " + this.emd.name + " total refresh time ", ts);
    }

    public boolean setSelected(Object pk) {
        int modelIdx = this.etm.pks.indexOf(pk);
        if (modelIdx != -1) {
            try {
                int viewIdx = this.entityTable.convertRowIndexToView(modelIdx);
                this.entityTable.getSelectionModel().addSelectionInterval(viewIdx, viewIdx);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void scrollToSelected() {
        int sr = this.entityTable.getSelectedRow();
        if (sr != -1) {
            Rectangle rect = this.entityTable.getCellRect(sr, 0, false);
            Rectangle rectLast = this.entityTable.getCellRect(this.entityTable.getRowCount() - 1, 0, false);
            float f = (float)rect.getY() / (float)rectLast.getY();
            this.jScrollPane1.scrollRectToVisible(rect);
            float f2 = f * (float)this.jScrollPane1.getVerticalScrollBar().getMaximum();
            int i = (int)f2 - 10;
            if (i < 0) {
                i = 0;
            }
            this.jScrollPane1.getVerticalScrollBar().setValue(i);
        }
    }

    public void clearSelection() {
        this.entityTable.getSelectionModel().clearSelection();
    }

    public void setSelected(List selectedPks) {
        boolean gotAny = false;
        for (Object o : selectedPks) {
            if (o == null || !this.etm.hasPk(o) || !this.setSelected(o)) continue;
            gotAny = true;
        }
        if (!gotAny && this.etm.pks.size() > 0) {
            this.setSelected(this.etm.pks.get(0));
        }
    }

    public void scrollToBottom() {
        Thread t = new Thread(){

            @Override
            public void run() {
                JScrollBar jsb = EntityEditor.this.jScrollPane1.getVerticalScrollBar();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jsb.setValue(jsb.getMaximum());
            }
        };
        t.start();
    }

    protected static void show(String msg) {
        JOptionPane.showMessageDialog(null, msg, "", 1);
    }

    public void print(JPanel header, String footer) {
        this.headerPanel = header;
        try {
            if (footer == null) {
                footer = " Numero de registros: " + this.etm.getRowCount() + " - P\u00e1gina {0}";
            }
            PrinterJob printJob = PrinterJob.getPrinterJob();
            MessageFormat h = this.headerPanel == null ? new MessageFormat("Listado de " + this.emd.name) : null;
            this.printableTable = this.getEntityTable().getPrintable(JTable.PrintMode.FIT_WIDTH, h, new MessageFormat(footer));
            if (printJob.printDialog()) {
                printJob.setPrintable(this);
                printJob.print();
            }
        }
        catch (Exception e) {
            Util.show((Component)this, (Throwable)e);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY() - 20.0);
        if (this.headerPanel != null) {
            RepaintManager currentManager = RepaintManager.currentManager(this.headerPanel);
            currentManager.setDoubleBufferingEnabled(false);
            this.headerPanel.printAll(g2d);
            currentManager = RepaintManager.currentManager(this.headerPanel);
            currentManager.setDoubleBufferingEnabled(true);
            Paper p = pageFormat.getPaper();
            p.setImageableArea(p.getImageableX(), p.getImageableY() + 35.0, p.getImageableWidth(), p.getImageableHeight() - 20.0);
            pageFormat.setPaper(p);
            g2d.scale(0.95, 0.9);
        }
        int ret = this.printableTable.print(graphics, pageFormat, pageIndex);
        return ret;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.entityTable = new JTable();
        this.footerPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.entityTable.setAutoCreateRowSorter(true);
        this.jScrollPane1.setViewportView(this.entityTable);
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.footerPanel, "Last");
    }

    public JTable getEntityTable() {
        return this.entityTable;
    }

    public JScrollPane getJScrollPane1() {
        return this.jScrollPane1;
    }

    public void setHorizontalScrollBars(boolean b) {
        this.setHorizontalScroolBarsImpl(b);
        if (this.checkBoxBarraHorizontal != null) {
            this.checkBoxBarraHorizontal.setSelected(b);
        }
    }

    private void setHorizontalScroolBarsImpl(boolean b) {
        int policy = b ? 32 : 30;
        this.jScrollPane1.setHorizontalScrollBarPolicy(policy);
        this.repaint();
        if (!b) {
            this.getEntityTable().setAutoResizeMode(0);
            for (int i = 0; i < this.getEntityTable().getColumnCount(); ++i) {
                int currrWidth = this.getEntityTable().getColumnModel().getColumn(i).getWidth();
                this.getEntityTable().getColumnModel().getColumn(i).setWidth(currrWidth * 3 + 40);
                this.getEntityTable().repaint();
            }
        } else {
            this.getEntityTable().setAutoResizeMode(0);
        }
    }

    public void resizeColumnWidthToFitHeaderText() {
        TableColumnModel columnModel = this.entityTable.getColumnModel();
        for (int column = 0; column < this.entityTable.getColumnCount(); ++column) {
            TableColumn tc = columnModel.getColumn(column);
            int width = 9;
            String header = String.valueOf(tc.getHeaderValue().toString());
            tc.setPreferredWidth(header.length() * width);
        }
    }

    public List getPKs() {
        return this.pKs;
    }

    public void setPKs(List pKs) {
        if (this.pKs == this.searchList) {
            this.searchList.completeList = pKs;
        } else {
            this.pKs = pKs;
        }
        if (this.searchList != null) {
            this.searchList.completeList = pKs;
        }
        this.refresh(null);
    }

    public void setEntityTable(JTable entityTable) {
        this.entityTable = entityTable;
    }

    public EntityTableModel getEtm() {
        return this.etm;
    }

    public void setEtm(EntityTableModel etm) {
        this.etm = etm;
    }

    public Object getPk(int row) {
        return this.etm.getPk(this.entityTable.convertRowIndexToModel(row));
    }

    public JFrame getParentFrame() {
        return this.parentFrame;
    }

    public void setParentFrame(JFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public boolean isBackRefs() {
        return this.backRefs;
    }

    public void setBackRefs(boolean backRefs) {
        this.backRefs = backRefs;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public Font getTableFont() {
        return this.tableFont;
    }

    public void setTableFont(Font tableFont) {
        this.tableFont = tableFont;
    }

    public JPanel getFooterPanel() {
        return this.footerPanel;
    }

    private EntityMetaData getEntityMetaData() {
        return this.emd;
    }

    public void installCheckBoxBarraHorizontal() {
        if (this.checkBoxBarraHorizontal != null) {
            throw new IllegalStateException("Checkbox barra horiz ya instalado");
        }
        this.checkBoxBarraHorizontal = new JCheckBox("Barra horizontal");
        this.checkBoxBarraHorizontal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityEditor.this.setHorizontalScroolBarsImpl(EntityEditor.this.checkBoxBarraHorizontal.isSelected());
            }
        });
        this.setHorizontalScroolBarsImpl(false);
        this.footerPanel.add(this.checkBoxBarraHorizontal);
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public class BrList
    extends PkList {
        private BackRef backRef;
        private String property;
        private Object filter = null;

        public String getProperty() {
            return this.property;
        }

        public BrList(String property) {
            this.property = property;
        }

        public BrList(BackRef br) {
            this.property = br.onProperty;
            this.backRef = br;
        }

        public Object getFilter() {
            return this.filter;
        }

        public void setFilter(Object filter) {
            this.filter = filter;
        }

        public BackRef getBackRef() {
            return this.backRef;
        }

        @Override
        public Object getPk() {
            return this.pk;
        }

        void updateEnityCreator() {
            EntityEditor bree = EntityEditor.this.getBrEE(this.property);
            String sourceFk = ((EntityEditor)EntityEditor.this).getEntityMetaData().br.get((Object)this.property).sourceFK;
            if (bree != null && bree.getEntityCreator() != null) {
                EntityCreator ec = bree.getEntityCreator();
                FKComboBox combo = (FKComboBox)ec.fields.get(sourceFk);
                if (combo != null) {
                    combo.setEnabled(true);
                    combo.setSelected(this.pk);
                    combo.setEnabled(false);
                    ec.buscarButtons.get(sourceFk).setEnabled(false);
                    ec.resetFatherChildData();
                } else {
                    try {
                        sourceFk = this.backRef.getSourceFk();
                        ec.setFatherChildData(this.pk, this.backRef.onClass, this.property, sourceFk);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void setPk(Object pk) {
            this.pk = pk;
            this.updateEnityCreator();
        }

        @Override
        public List getList() {
            long ts = System.currentTimeMillis();
            if (this.fixedList != null) {
                return this.fixedList;
            }
            List<Object> list = new ArrayList<Object>();
            Class sourceClass = ((EntityEditor)EntityEditor.this).getEntityMetaData().br.get((Object)this.property).source;
            String sourceFk = ((EntityEditor)EntityEditor.this).getEntityMetaData().br.get((Object)this.property).sourceFK;
            if (this.pk == null && !sourceClass.equals(EntityEditor.this.emd.clazz)) {
                return new ArrayList();
            }
            try {
                Object ret = new ArrayList();
                ts = System.currentTimeMillis();
                ret = this.pk != null ? ac.getBackReferenceIds(EntityEditor.this.emd.clazz, this.pk, this.property, this.filter) : facade.getRootIds(sourceClass, sourceFk);
                ts = System.currentTimeMillis() - ts;
                if (ret != null) {
                    if (ret instanceof List) {
                        list = (List)ret;
                    } else {
                        list.add(ret);
                    }
                }
            }
            catch (Exception e) {
                Util.show(this, (Throwable)e);
            }
            MonitorRendimiento.getInstance().append("\t\tBackRef " + this.property + " de " + EntityEditor.this.emd.name + "(" + this.pk + ")", ts);
            return list;
        }
    }

    public class SearchList
    extends PkList {
        public List completeList;

        @Override
        public void setPk(Object pk) {
            System.err.println("...............SearchList got setPk............");
            System.err.println("...............SearchList got setPk............");
            if (this.completeList instanceof PkList) {
                ((PkList)this.completeList).setPk(pk);
            }
        }

        public List getCompleteList() {
            return this.completeList;
        }

        @Override
        public List getList() {
            try {
                String search = EntityEditor.this.searchField.getText().trim();
                List pks = this.completeList;
                if (pks instanceof PkList) {
                    pks = ((PkList)pks).getList();
                }
                long ts = System.currentTimeMillis();
                List l = ac.search(EntityEditor.this.emd.clazz, search, pks);
                long ts1 = System.currentTimeMillis();
                return l;
            }
            catch (Exception e) {
                Util.show(this, (Throwable)e);
                return new ArrayList();
            }
        }
    }

    private class ListSelectionListenerImpl
    implements ListSelectionListener {
        private ListSelectionListenerImpl() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            long ts = System.currentTimeMillis();
            List selectedPks = EntityEditor.this.getSelectedPks();
            for (String p : EntityEditor.this.emd.br.keySet()) {
                if (EntityEditor.this.backRefs) {
                    JButton b = EntityEditor.this.brButtons.get(p);
                    String text = "Ver " + EntityEditor.this.emd.columnDisplayNames.get(p);
                    if (selectedPks.size() > 0) {
                        text = text + " de " + selectedPks.get(0);
                    }
                    b.setText(text);
                }
                if (!EntityEditor.this.brEEs.containsKey(p)) continue;
                JDialog d = EntityEditor.this.brDialog.get(p);
                try {
                    EntityEditor.this.showBr(p, d != null && d.isVisible());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    Util.show(this, t);
                }
            }
            if (selectedPks.size() > 0) {
                Object selectedItemPk = selectedPks.get(0);
                for (String p : EntityEditor.this.emd.conditionedRefs.keySet()) {
                    FKComboBox fkcb = EntityEditor.this.comboFks.get(p);
                    try {
                        if (fkcb == null) continue;
                        fkcb.setPk(selectedItemPk);
                    }
                    catch (Exception ex) {
                        Util.show(this, (Throwable)ex);
                    }
                }
            }
        }
    }
}

