/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.swing;

import es.pablo.jee.ejb.jms.PersistenceEvent;
import es.pablo.jee.ejb.jms.Refreshable;
import es.pablo.jee.ejb.jms.Refresher;
import es.pablo.jee.ejb.swing.CachedTable;
import es.pablo.jee.ejb.swing.EntityEditor;
import es.pablo.jee.entity.EntityRef;
import es.pablo.jee.entity.ForeignKey;
import es.pablo.jee.entity.Introspector;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientSideModel
implements Refreshable {
    private static ClientSideModel singelton = null;
    public static volatile boolean autoLoadPks = true;
    public static volatile boolean autoLoadTable = false;
    public static volatile boolean autoLoadTablePageByPage = true;
    public static volatile int lostSrBeforeFullReload = 5;
    public static volatile boolean autoLoadPageOnSingleRequest = true;
    public static volatile int autoLoadPageSize = 80;
    private Map<Class, CachedTable> cache = Collections.synchronizedMap(new HashMap());
    private Map<Class, SoftReference<List<EntityRef>>> merCache = Collections.synchronizedMap(new HashMap());
    final Object entityRefLoaderlock = new Object();
    private volatile boolean loadingAllEr = false;

    private ClientSideModel() throws Exception {
        Refresher.getInstance().subscribeToAll(this);
    }

    public static synchronized ClientSideModel getInstance() throws Exception {
        if (singelton == null) {
            singelton = new ClientSideModel();
        }
        return singelton;
    }

    public synchronized void flushCache(Class clazz) {
        System.err.println("ClientSideModel flushing cache for " + clazz.getSimpleName());
        this.cache.remove(clazz);
        this.merCache.remove(clazz);
    }

    public synchronized void flushAll() {
        this.cache.clear();
        this.merCache.clear();
    }

    @Override
    public synchronized void refresh(PersistenceEvent pe) throws Exception {
        SoftReference<List<EntityRef>> sr;
        List<EntityRef> l;
        if (pe != null && PersistenceEvent.Type.FULL_REFRESH.equals((Object)pe.type)) {
            this.flushAll();
            return;
        }
        CachedTable ct = this.cache.get(pe.clazz);
        if (ct != null) {
            if (pe.type == PersistenceEvent.Type.DELETE || pe.type == PersistenceEvent.Type.UPDATE) {
                ct.rows.remove(pe.pk);
                if (ct.pks != null && pe.type == PersistenceEvent.Type.DELETE) {
                    ct.pks.remove(pe.pk);
                }
            } else if (ct.pks != null && pe.type == PersistenceEvent.Type.CREATE) {
                ct.pks.add(pe.pk);
            }
        }
        if (this.merCache.containsKey(pe.clazz) && (l = (sr = this.merCache.get(pe.clazz)).get()) != null) {
            if (pe.type == PersistenceEvent.Type.CREATE) {
                l.add(EntityEditor.ac.getEntityRef(pe.clazz, pe.pk));
            } else if (pe.type == PersistenceEvent.Type.UPDATE || pe.type == PersistenceEvent.Type.DELETE) {
                for (int i = 0; i < l.size(); ++i) {
                    EntityRef er = l.get(i);
                    if (!pe.pk.equals(er.pk)) continue;
                    if (pe.type == PersistenceEvent.Type.UPDATE) {
                        l.set(i, EntityEditor.ac.getEntityRef(pe.clazz, pe.pk));
                    } else if (pe.type == PersistenceEvent.Type.DELETE) {
                        l.remove(i);
                    }
                    return;
                }
            }
        }
    }

    public static List getPks(Class c) throws Exception {
        return ClientSideModel.getInstance().getTable(c).getPks();
    }

    public static Object[] get(Class c, Object pk, List pkGroup, List<String> properties) throws Exception {
        long ts = System.currentTimeMillis();
        Object[] ret = ClientSideModel.getInstance()._get(c, pk, pkGroup, properties);
        return ret;
    }

    public Object[] _get(Class c, Object pk, List pkGroup, List<String> properties) throws Exception {
        Object[] ret = new Object[properties.size()];
        CachedTable ct = this.getTable(c);
        Object[] values = ct.getRow(pk, pkGroup);
        for (int i = 0; i < properties.size(); ++i) {
            String p = properties.get(i);
            int idx = ct.allProperties.indexOf(p);
            ret[i] = values[idx];
        }
        return ret;
    }

    public synchronized CachedTable getTable(Class c) throws Exception {
        CachedTable ct = this.cache.get(c);
        if (ct == null) {
            ct = new CachedTable(c);
            this.cache.put(c, ct);
        }
        return ct;
    }

    public static List getFKValues(Class c, String property) throws Exception {
        ForeignKey fk = Introspector.getEntityMetaData((Class)c).fk.get(property);
        long ts = System.currentTimeMillis();
        if (fk.card == ForeignKey.Card.OTO) {
            long ts1 = System.currentTimeMillis();
            return EntityEditor.ac.getFKValues(c, null, property);
        }
        ClientSideModel.getInstance();
        List ret = ClientSideModel.getAllErs(fk.targetEntity);
        long ts1 = System.currentTimeMillis();
        return ret;
    }

    public synchronized EntityRef _getEntityRef(final Class c, Object pk) throws Exception {
        List<EntityRef> ler;
        SoftReference<List<EntityRef>> sr = this.merCache.get(c);
        if (sr != null && (ler = sr.get()) != null) {
            for (EntityRef er : ler) {
                if (er == null || er.pk == null || !er.pk.equals(pk)) continue;
                return er;
            }
        }
        if (!this.loadingAllEr && autoLoadTable) {
            this.loadingAllEr = true;
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        List<EntityRef> ler = EntityEditor.ac.getAllEntityRefs(c);
                        Object object = ClientSideModel.this.entityRefLoaderlock;
                        synchronized (object) {
                            if (ler.contains(null)) {
                                System.err.println("Got list of entity refs from server and one was null");
                            }
                            ClientSideModel.this.merCache.put(c, new SoftReference<List<EntityRef>>(ler));
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    ClientSideModel.this.loadingAllEr = false;
                }
            };
            t.start();
        }
        return EntityEditor.ac.getEntityRef(c, pk);
    }

    public static EntityRef getEntityRef(Class c, Object pk) throws Exception {
        return ClientSideModel.getInstance()._getEntityRef(c, pk);
    }

    public static List getAllErs(Class c) throws Exception {
        return ClientSideModel.getInstance()._getAllErs(c);
    }

    private synchronized List<EntityRef> _getAllErs(Class c) throws Exception {
        List<EntityRef> l = null;
        SoftReference<List<EntityRef>> sr = this.merCache.get(c);
        if (sr != null) {
            l = sr.get();
        }
        if (l == null) {
            l = EntityEditor.ac.getAllEntityRefs(c);
            this.merCache.put(c, new SoftReference<List<EntityRef>>(l));
        }
        return l;
    }
}

