/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.swing;

import es.pablo.jee.ejb.swing.ClientSideModel;
import es.pablo.jee.ejb.swing.EntityEditor;
import es.pablo.jee.entity.EntityMetaData;
import es.pablo.jee.entity.Introspector;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class CachedTable {
    EntityMetaData emd;
    List allProperties = new ArrayList();
    volatile Map<Object, SoftReference<Object[]>> rows = Collections.synchronizedMap(new HashMap());
    volatile Set loadingPks = Collections.synchronizedSet(new HashSet());
    volatile List pks = null;
    volatile boolean loadingFullTable;
    volatile int lostSr = 0;
    public final Stack<List> pageStack = new Stack();

    CachedTable(Class clazz) throws Exception {
        this.emd = Introspector.getEntityMetaData(clazz);
        this.allProperties.addAll(this.emd.columnNames);
        if (ClientSideModel.autoLoadTable) {
            this.loadFullTable();
        } else if (ClientSideModel.autoLoadPks) {
            this.getPks();
        }
        if (ClientSideModel.autoLoadPageOnSingleRequest) {
            this.startLoaderThread();
        }
    }

    public boolean isAvailable(Object pk, List pkGroup) {
        SoftReference<Object[]> sr = this.rows.get(pk);
        if (sr != null && sr.get() != null) {
            return true;
        }
        this.makePageAndAddToLoadingStackIfNecessary(pk, pkGroup);
        return false;
    }

    synchronized List getPks() throws Exception {
        if (this.pks == null) {
            long ts = System.currentTimeMillis();
            this.pks = EntityEditor.ac.getPKs(this.emd.clazz);
            long l = System.currentTimeMillis();
        }
        return new ArrayList(this.pks);
    }

    void loadFullTable() {
        if (this.loadingFullTable) {
            return;
        }
        final CachedTable tableLock = this;
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    if (CachedTable.this.loadingFullTable) {
                        return;
                    }
                    CachedTable.this.loadingFullTable = true;
                    try {
                        if (ClientSideModel.autoLoadTablePageByPage) {
                            List pks = CachedTable.this.getPks();
                            CachedTable.this.loadPageByPage(pks);
                            break block11;
                        }
                        long ts = System.currentTimeMillis();
                        Object[] pksAndTable = EntityEditor.ac.getFullTable(CachedTable.this.emd.clazz);
                        List _pks = (List)pksAndTable[0];
                        Object[] table = (Object[])pksAndTable[1];
                        long ts2 = System.currentTimeMillis();
                        ts = System.currentTimeMillis();
                        HashMap<Object, SoftReference<Object[]>> _rows = new HashMap<Object, SoftReference<Object[]>>();
                        int idx = 0;
                        for (Object o : table) {
                            Object[] row = (Object[])o;
                            Object pk = _pks.get(idx);
                            ++idx;
                            _rows.put(pk, new SoftReference<Object[]>(row));
                        }
                        ts2 = System.currentTimeMillis();
                        Object object = tableLock;
                        synchronized (object) {
                            CachedTable.this.pks = _pks;
                            CachedTable.this.rows = _rows;
                            CachedTable.this.lostSr = 0;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Object object = tableLock;
                        synchronized (object) {
                            CachedTable.this.rows = new HashMap<Object, SoftReference<Object[]>>();
                            CachedTable.this.pks = null;
                        }
                    }
                }
                CachedTable.this.loadingFullTable = false;
            }
        };
        t.setPriority(1);
        t.start();
    }

    void loadPageByPage(List pks) throws Exception {
        int pageSize = ClientSideModel.autoLoadPageSize;
        int page = 0;
        int pageStart = 0;
        do {
            if (this.loadingFullTable || pks == null || pks.size() < 1) {
                return;
            }
            int pageEnd = pageStart + pageSize > pks.size() ? pks.size() : pageStart + pageSize;
            ArrayList pkPage = new ArrayList(pks.subList(pageStart, pageEnd));
            long ts = System.currentTimeMillis();
            try {
                pkPage.removeAll(this.rows.keySet());
                this.loadPage(pkPage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long ts1 = System.currentTimeMillis();
            pageStart = page * pageSize;
            ++page;
        } while (pageStart < pks.size());
    }

    public Object[] loadPage(List pkPage) throws Exception {
        ArrayList toBeLoaded = new ArrayList();
        toBeLoaded.addAll(pkPage);
        for (Object o : pkPage) {
            SoftReference<Object[]> sr = this.rows.get(o);
            if (sr == null || sr.get() == null) continue;
            toBeLoaded.remove(o);
        }
        pkPage.removeAll(this.loadingPks);
        if (toBeLoaded.size() > 0) {
            this.loadingPks.addAll(toBeLoaded);
            long ts = System.currentTimeMillis();
            Object[] rowPage = EntityEditor.ac.get(this.emd.clazz, toBeLoaded, (List<String>)this.allProperties);
            ts = System.currentTimeMillis() - ts;
            for (int i = 0; i < rowPage.length; ++i) {
                Object _pk = toBeLoaded.get(i);
                Object[] _row = (Object[])rowPage[i];
                this.rows.put(_pk, new SoftReference<Object[]>(_row));
            }
            this.loadingPks.removeAll(toBeLoaded);
            return rowPage;
        }
        return new Object[0];
    }

    synchronized Object[] getRow(Object pk, List pkGroup) throws Exception {
        long ts;
        Object[] row = null;
        if (this.rows.containsKey(pk)) {
            ts = System.currentTimeMillis();
            row = this.rows.get(pk).get();
            if (row == null && ClientSideModel.autoLoadTable) {
                ++this.lostSr;
                if (this.lostSr > ClientSideModel.lostSrBeforeFullReload) {
                    this.loadFullTable();
                }
            }
        }
        if (row == null) {
            ts = System.currentTimeMillis();
            row = EntityEditor.ac.get(this.emd.clazz, pk, (List<String>)this.allProperties);
            this.rows.put(pk, new SoftReference<Object[]>(row));
            this.makePageAndAddToLoadingStackIfNecessary(pk, pkGroup);
        }
        return row;
    }

    private void startLoaderThread() {
        Thread loaderThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            List l;
                            if ((l = CachedTable.this.getFromStack()) != null) {
                                long ts = System.currentTimeMillis();
                                Object[] objectArray = CachedTable.this.loadPage(l);
                            }
                            Thread.sleep(10L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        loaderThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToStack(List l) {
        Stack<List> stack = this.pageStack;
        synchronized (stack) {
            if (this.pageStack.size() > 10) {
                ArrayList l2 = new ArrayList(this.pageStack.subList(this.pageStack.size() - 10, this.pageStack.size()));
                this.pageStack.clear();
                this.pageStack.addAll(l2);
            }
            ArrayList<List> toRemove = new ArrayList<List>();
            for (List l2 : this.pageStack) {
                l2.removeAll(l);
                if (l2.size() != 0) continue;
                toRemove.add(l2);
            }
            this.pageStack.removeAll(toRemove);
            this.pageStack.push(l);
        }
    }

    public void makePageAndAddToLoadingStackIfNecessary(Object pk, List pkGroup) {
        if (ClientSideModel.autoLoadPageOnSingleRequest && pkGroup != null && pkGroup.size() > 0) {
            int indx = pkGroup.indexOf(pk);
            int pageEnd = indx + ClientSideModel.autoLoadPageSize;
            if (pageEnd > pkGroup.size()) {
                pageEnd = pkGroup.size();
            }
            ArrayList subSet = new ArrayList(pkGroup.subList(indx, pageEnd));
            subSet.removeAll(this.loadingPks);
            if (subSet.size() > 0) {
                this.addToStack(subSet);
            }
        } else {
            this.loadingPks.remove(pk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFromStack() {
        Stack<List> stack = this.pageStack;
        synchronized (stack) {
            try {
                List l = null;
                while ((l = this.pageStack.pop()) != null && l.size() == 0) {
                }
                return l;
            }
            catch (EmptyStackException e) {
                return null;
            }
        }
    }
}

