/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.request;

import es.pablo.jee.ejb.request.AbstractEntityListener;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueuedEntityListener
extends AbstractEntityListener {
    private static final Logger log = LoggerFactory.getLogger(QueuedEntityListener.class);
    public static Object lock = new Object();
    public static boolean running = true;
    LinkedBlockingQueue<Serializable> queue = new LinkedBlockingQueue();

    public QueuedEntityListener() {
        if (this.isJmsPresent()) {
            log.debug("Launching QueueDispatcher");
            new QueueDispatcher().start();
        } else {
            log.warn("JMS disabled");
        }
    }

    @Override
    protected void sendMessage(Serializable s) {
        if (!this.queue.offer(s)) {
            System.err.println("QUE FULL!! while tying to send " + s + " queu size is " + this.queue.size() + " discarding message");
        }
    }

    @Override
    protected abstract ConnectionFactory getConnectionFactory();

    @Override
    protected abstract Topic getTopic();

    private class QueueDispatcher
    extends Thread {
        Connection con = null;
        Session ses = null;
        MessageProducer producer = null;

        private QueueDispatcher() {
        }

        @Override
        public void run() {
            while (true) {
                Serializable o = null;
                try {
                    o = QueuedEntityListener.this.queue.poll(2L, TimeUnit.SECONDS);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (o == null) {
                    this.closeStuff();
                    continue;
                }
                try {
                    this.dispatchEvent(o, 0);
                    continue;
                }
                catch (Throwable t) {
                    this.closeStuff();
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }

        protected void dispatchEvent(Serializable s, int attempt) {
            block2: {
                try {
                    this.openStuff();
                    ObjectMessage om = this.ses.createObjectMessage();
                    om.setObject(s);
                    this.producer.send((Message)om);
                    System.out.println("... MESSAGE " + s + " SENT OK queue size = " + QueuedEntityListener.this.queue.size() + " on attempt " + attempt);
                }
                catch (Throwable t) {
                    System.err.println("... MESSAGE SENT FAILED!!!!: " + t.getMessage() + " on attempt " + attempt + " quee size= " + QueuedEntityListener.this.queue.size());
                    this.closeStuff();
                    if (attempt >= 3) break block2;
                    this.dispatchEvent(s, ++attempt);
                }
            }
        }

        private void openStuff() throws JMSException {
            if (this.con == null && QueuedEntityListener.this.getConnectionFactory() != null) {
                this.con = QueuedEntityListener.this.getConnectionFactory().createConnection();
                this.ses = this.con.createSession(false, 1);
                this.producer = this.ses.createProducer((Destination)QueuedEntityListener.this.getTopic());
            }
        }

        private void closeStuff() {
            if (this.ses != null) {
                try {
                    this.ses.close();
                    this.ses = null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.producer != null) {
                try {
                    this.producer.close();
                    this.producer = null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.con != null) {
                try {
                    this.con.close();
                    this.con = null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.ses = null;
            this.producer = null;
            this.con = null;
        }
    }
}

