/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.request;

import com.anahata.util.model.Activatable;
import es.pablo.jee.ejb.exception.InvalidParameterException;
import es.pablo.jee.ejb.request.AbstractAppController;
import es.pablo.jee.ejb.request.Controller;
import es.pablo.jee.ejb.swing.tree.Filter;
import es.pablo.jee.entity.BackRef;
import es.pablo.jee.entity.EntityMetaData;
import es.pablo.jee.entity.EntityRef;
import es.pablo.jee.entity.File;
import es.pablo.jee.entity.ForeignKey;
import es.pablo.jee.entity.Introspector;
import es.pablo.jee.entity.LobFile;
import es.pablo.jee.entity.LobFileRef;
import es.pablo.jee.entity.ServerFile;
import es.pablo.util.Util;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.ejb.EJBException;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

public class DefaultController
implements Controller {
    protected EntityManager em;
    protected EntityMetaData emd;
    protected HashMap<String, PropertyDescriptor> pdMap;
    protected BeanInfo bi;
    protected Class entityClass;
    protected String entityName;
    protected AbstractAppController ac;
    public static final int SEARCH_MAX_RESULTS = 1007;

    protected DefaultController(AbstractAppController ac, EntityManager em, Class c) throws IntrospectionException {
        this.ac = ac;
        this.em = em;
        this.setEntityClass(c);
    }

    protected void setEntityManager(EntityManager em) {
        this.em = em;
    }

    public void setEntityClass(Class c) throws IntrospectionException {
        this.entityClass = c;
        this.entityName = this.entityClass.getSimpleName();
        this.bi = Introspector.getBeanInfo(this.entityClass);
        this.pdMap = (HashMap)this.bi.getBeanDescriptor().getValue("pdMap");
        this.emd = (EntityMetaData)this.bi.getBeanDescriptor().getValue("emd");
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    @Override
    public BeanInfo getBeanInfo() {
        return this.bi;
    }

    public static Object getId(Object o) throws Exception {
        return DefaultController.getIdReadMethod(o).invoke(o, new Object[0]);
    }

    public static Method getIdReadMethod(Object o) throws Exception {
        BeanInfo bi = Introspector.getBeanInfo(o.getClass());
        HashMap pdMap = (HashMap)bi.getBeanDescriptor().getValue("pdMap");
        EntityMetaData emd = (EntityMetaData)bi.getBeanDescriptor().getValue("emd");
        String pkName = null;
        try {
            pkName = emd.id.get(0);
        }
        catch (Exception e) {
            emd = Introspector.getEntityMetaData(o.getClass());
            try {
                pkName = emd.id.get(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Exception(emd.clazz + " Sin Id: " + emd.id + " " + emd.id.size());
            }
        }
        PropertyDescriptor pd = (PropertyDescriptor)pdMap.get(pkName);
        Method m = pd.getReadMethod();
        return m;
    }

    private EntityRef e2er(Object o) throws Exception {
        if (o == null) {
            return null;
        }
        Method m = DefaultController.getIdReadMethod(o);
        Object pk = m.invoke(o, new Object[0]);
        return new EntityRef(pk, o.toString());
    }

    public static ArrayList<EntityRef> me2mer(List l) throws Exception {
        Method m = DefaultController.getIdReadMethod(l.get(0));
        ArrayList<EntityRef> result = new ArrayList<EntityRef>();
        for (Object o : l) {
            Activatable a;
            if (o instanceof Activatable && !(a = (Activatable)o).isActive()) continue;
            Object pk = m.invoke(o, new Object[0]);
            result.add(new EntityRef(pk, o.toString()));
        }
        return result;
    }

    private Object getForeignReference(Class c, Object o, String p, Object v) throws Exception {
        Object ooo = null;
        if (v instanceof EntityRef) {
            v = ((EntityRef)v).pk;
            ooo = this.em.find(c, v);
            if (ooo == null) {
                throw new Exception("No se encontro " + c.getSimpleName() + " " + v);
            }
        } else {
            ooo = this.em.find(c, v);
            if (ooo == null) {
                try {
                    DefaultController dc = (DefaultController)this.ac.getController(c);
                    String pkName = dc.emd.id.get(0);
                    ArrayList<String> props = new ArrayList<String>();
                    ArrayList<Object> values = new ArrayList<Object>();
                    props.add(pkName);
                    values.add(v);
                    Object createdPk = this.ac.getController(c).create(props, values);
                    ooo = this.em.find(c, createdPk);
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    System.err.println("Error al crear " + c.getSimpleName() + " " + v);
                    throw new InvalidParameterException(t.getMessage());
                }
            }
        }
        return ooo;
    }

    private Object getForeignReferences(Class c, Object o, String p, Object v) throws Exception {
        AbstractCollection value = v;
        if (Introspector.isEntity(c)) {
            if (this.emd.br.containsKey(p) && this.emd.br.get((Object)p).card != BackRef.Card.OTO) {
                PropertyDescriptor pd = this.pdMap.get(p);
                AbstractCollection collectedEntities = pd.getPropertyType().isAssignableFrom(Set.class) ? new HashSet() : new ArrayList();
                List pks = (List)((Object)value);
                for (Object pk : pks) {
                    Object ooo = this.getForeignReference(c, o, p, pk);
                    collectedEntities.add(ooo);
                }
                value = collectedEntities;
            } else {
                value = this.getForeignReference(c, o, p, v);
            }
        } else {
            throw new Exception(c + " Not an Entity");
        }
        return value;
    }

    private Date parseDate(String p, String s) throws InvalidParameterException {
        Date date = null;
        if (p.length() > 0) {
            SimpleDateFormat df = this.emd.temporalFormat.get(p);
            try {
                date = df.parse(s);
            }
            catch (ParseException e) {
                String errMsg = "Fecha / Hora " + s + " no valida ";
                errMsg = errMsg + " \n Introduzca en formato " + df.toPattern();
                throw new InvalidParameterException(errMsg, p);
            }
        }
        return date;
    }

    private Object parseValue(Object o, String p, Object v) throws Exception {
        if (v instanceof LobFile) {
            return v;
        }
        if (this.emd.generated.contains(p)) {
            throw new InvalidParameterException(p + " se genera automaticamente", p);
        }
        PropertyDescriptor pd = this.pdMap.get(p);
        if (pd == null) {
            throw new Exception("No se encontro la propiedad " + p);
        }
        Class c = pd.getPropertyType();
        BackRef br = this.emd.br.get(p);
        if (br != null) {
            c = br.source;
        }
        if (v == null || v.toString().isEmpty()) {
            if (this.emd.notNull.contains(p)) {
                throw new InvalidParameterException(p + " es obligatorio ", p);
            }
            return String.class.equals((Object)c) ? v : null;
        }
        Object value = v;
        if (v instanceof ServerFile && this.emd.file.contains(p)) {
            File file = this.emd.files.get(p);
            if (file == null) {
                throw new Exception("No se encontro la anotacion File en la entidad");
            }
            ServerFile uploaded = (ServerFile)v;
            try {
                Util.writeToDisc(file, uploaded);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InvalidParameterException("Error al guardar el archivo: " + e.getMessage(), p);
            }
            return uploaded.name;
        }
        if (Introspector.isEntity(c)) {
            value = this.getForeignReferences(c, o, p, v);
        } else {
            if (c.isInstance(v) && !c.isAssignableFrom(String.class)) {
                return v;
            }
            if (v instanceof String) {
                String s = (String)v;
                if (this.emd.pattern.containsKey(p)) {
                    es.pablo.jee.entity.Pattern pa = this.emd.pattern.get(p);
                    if (pa.uppercase()) {
                        s = s.toUpperCase();
                    }
                    if (pa.value().length() > 0 && !Pattern.matches(pa.value(), s)) {
                        throw new InvalidParameterException(p + " no valido \n\n" + pa.description(), p);
                    }
                    value = s;
                } else if (Date.class.isAssignableFrom(c)) {
                    value = this.parseDate(p, s);
                } else if (Number.class.isAssignableFrom(c)) {
                    if (v == null || v.toString().isEmpty()) {
                        value = null;
                    } else {
                        try {
                            value = c.getConstructor(String.class).newInstance(v);
                        }
                        catch (Exception e) {
                            throw new InvalidParameterException(p + " debe de ser numerico de tipo " + c.getSimpleName() + " ", p);
                        }
                    }
                } else if (Enum.class.isAssignableFrom(c)) {
                    Enum[] types;
                    for (Enum e : types = (Enum[])c.getEnumConstants()) {
                        if (!e.name().equals(s)) continue;
                        value = e;
                        break;
                    }
                } else if (Boolean.class.isAssignableFrom(c) || c.equals(Boolean.TYPE)) {
                    value = Boolean.parseBoolean(s);
                }
            } else if (Boolean.TYPE.equals(c)) {
                value = v;
            } else {
                throw new InvalidParameterException("Can not parse " + v + " because is not String p=" + p + " c=" + c, p);
            }
        }
        return value;
    }

    @Override
    public Object[] getFullTable() throws Exception {
        long ts = System.currentTimeMillis();
        try {
            StringBuffer sb = new StringBuffer();
            for (String p : this.emd.columnNames) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("X." + p);
            }
            String query = "SELECT " + sb + " FROM " + this.emd.name + " X ";
            Query q = this.em.createQuery(query);
            List l = q.getResultList();
            int pkIdx = this.emd.columnNames.indexOf(this.emd.id.get(0));
            ArrayList<Object> pks = new ArrayList<Object>();
            Object[] table = new Object[l.size()];
            int rowIdx = 0;
            for (Object[] ret1 : l) {
                Object[] row = new Object[this.emd.columnNames.size()];
                for (int i = 0; i < ret1.length; ++i) {
                    if (i == pkIdx) {
                        pks.add(ret1[pkIdx]);
                    }
                    String p = this.emd.columnNames.get(i);
                    row[i] = this.valueToObject(row[i], p, ret1[i]);
                }
                table[rowIdx] = row;
                ++rowIdx;
            }
            return new Object[]{pks, table};
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception(t.getMessage());
        }
    }

    @Override
    public Object[] get(Object pk, List<String> properties) throws Exception {
        long ts = System.currentTimeMillis();
        try {
            if (pk instanceof EntityRef) {
                pk = ((EntityRef)pk).pk;
            }
            StringBuffer sb = new StringBuffer();
            for (String p : properties) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("X." + p);
            }
            String query = "SELECT " + sb + " FROM " + this.emd.name + " X WHERE X." + this.emd.id.get(0) + "= :pk";
            Query q = this.em.createQuery(query);
            q.setParameter("pk", pk);
            if (q == null) {
                // empty if block
            }
            List l = q.getResultList();
            ts = System.currentTimeMillis() - ts;
            ts = System.currentTimeMillis();
            Object[] ret2 = new Object[properties.size()];
            if (l.size() > 0) {
                Object[] ret1 = (Object[])l.get(0);
                for (int i = 0; i < ret1.length; ++i) {
                    String p = properties.get(i);
                    ret2[i] = this.valueToObject(pk, p, ret1[i]);
                }
            }
            ts = System.currentTimeMillis() - ts;
            return ret2;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception(t.getMessage());
        }
    }

    private Object valueToObject(Object pk, String p, Object o) throws Exception {
        Serializable ret = o;
        if (this.emd.br.containsKey(p) && this.emd.br.get((Object)p).card != BackRef.Card.OTO) {
            ret = DefaultController.me2mer(ret);
        } else if (this.emd.br.containsKey(p) || this.emd.fk.containsKey(p)) {
            ret = this.e2er(o);
        } else if (this.emd.files.containsKey(p)) {
            try {
                ret = this.getFile(p, o);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                ServerFile sf = new ServerFile();
                sf.name = "No se pudo cargar:" + o + " : " + e.getMessage();
                sf.data = new int[0];
                ret = sf;
            }
        } else {
            ret = o instanceof LobFile ? new LobFileRef((LobFile)((Object)o)) : (o instanceof byte[] && this.emd.dbFiles.containsKey(p) ? LobFileRef.EMPTY_LOB_FILE_REF : o);
        }
        return ret;
    }

    @Override
    public Object[] get(List pks, List<String> properties) throws Exception {
        try {
            Object[] ret = new Object[pks.size()];
            for (int idx = 0; idx < pks.size(); ++idx) {
                Object pk = pks.get(idx);
                ret[idx] = this.get(pk, properties);
            }
            return ret;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception(t.getMessage());
        }
    }

    @Override
    public Object getBackReferenceIds(Object pk, String p, Object qlFilter) throws Exception {
        if (this.emd.br.containsKey(p)) {
            Object objetoEnCuestion = this.em.getReference(this.emd.clazz, pk);
            if (this.emd.br.get(p).getSourceFk() != null) {
                String inOrEqual = this.emd.br.get((Object)p).card == BackRef.Card.MTM ? " :S MEMBER OF  X." + this.emd.br.get(p).getSourceFk() : " X." + this.emd.br.get(p).getSourceFk() + " = :S";
                String query = "Select X." + this.emd.br.get(p).getSourcePk() + " FROM " + this.emd.br.get((Object)p).source.getSimpleName() + " X WHERE  " + inOrEqual;
                Filter filterFilter = null;
                if (qlFilter != null) {
                    if (qlFilter instanceof String) {
                        query = query + " AND " + qlFilter;
                    } else if (qlFilter instanceof Filter) {
                        filterFilter = (Filter)qlFilter;
                        filterFilter.init(this.em);
                    }
                }
                long ts = System.currentTimeMillis();
                ArrayList ret = this.em.createQuery(query).setParameter("S", objetoEnCuestion).getResultList();
                ts = System.currentTimeMillis() - ts;
                if (filterFilter != null) {
                    ArrayList ret2 = ret;
                    ret = new ArrayList();
                    for (Object o : ret2) {
                        if (!filterFilter.isValid(this.em, o)) continue;
                        ret.add(o);
                    }
                }
                return ret;
            }
            if (qlFilter != null) {
                throw new IllegalArgumentException("Can\u00b4t take qlFilter beacuase mapping is not defined in both sides of the relationship");
            }
            String query = "SELECT X." + p + " FROM " + this.emd.name + " X WHERE X." + this.emd.id.get(0) + " = :pk";
            Query q = this.em.createQuery(query).setParameter("pk", pk);
            if (this.emd.br.get((Object)p).card.equals((Object)BackRef.Card.OTO)) {
                try {
                    Object o = q.getSingleResult();
                    if (o != null) {
                        return Introspector.getId(o);
                    }
                    return null;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            List ret = q.getResultList();
            ArrayList<Object> ret2 = new ArrayList<Object>(ret.size());
            for (Object o : ret) {
                ret2.add(Introspector.getId(o));
            }
            return ret2;
        }
        throw new IllegalArgumentException("Not a back reference: " + p + " emd.clazz=" + this.emd.clazz);
    }

    @Override
    @Deprecated
    public Object get(Object pk, String p) throws Exception {
        try {
            if (pk instanceof EntityRef) {
                pk = ((EntityRef)pk).pk;
            }
            List ret = new ArrayList();
            String query = "SELECT X." + p + " FROM " + this.emd.name + " X  WHERE X." + this.emd.id.get(0) + "= :pk";
            System.out.println("ac.get() " + query);
            Query q = this.em.createQuery(query);
            q.setParameter("pk", pk);
            ret = q.getResultList();
            if (ret.size() > 0) {
                System.out.println("converting: " + ret);
                if (this.emd.br.containsKey(p) && this.emd.br.get((Object)p).card != BackRef.Card.OTO) {
                    if (ret.size() == 1 && ret.get(0) == null) {
                        return null;
                    }
                    return DefaultController.me2mer(ret);
                }
                if (this.emd.br.containsKey(p) || this.emd.fk.containsKey(p)) {
                    return this.e2er(ret.get(0));
                }
                return this.valueToObject(pk, p, ret.get(0));
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidParameterException(e.getMessage(), p);
        }
    }

    @Deprecated
    public Object get(int row, String p) throws Exception {
        try {
            String s = " X." + p;
            String query = "SELECT " + s + " FROM " + this.emd.name + " X ";
            Query q = this.em.createQuery(query);
            q.setFirstResult(row);
            q.setMaxResults(1);
            List l = q.getResultList();
            Serializable ret = null;
            if (l.size() > 0) {
                ret = this.emd.br.containsKey(p) && this.emd.br.get((Object)p).card != BackRef.Card.OTO ? DefaultController.me2mer(l) : (this.emd.br.containsKey(p) || this.emd.fk.containsKey(p) ? this.e2er(l.get(0)) : l.get(0));
            }
            return ret;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + " property=" + p);
        }
    }

    @Override
    public List getPKs() {
        try {
            if (this.emd.id.isEmpty()) {
                throw new IllegalArgumentException("There are no Ids for class " + this.emd.clazz);
            }
            String pk = this.emd.id.get(0);
            String query = "SELECT X." + pk + " FROM " + this.entityName + " X ";
            Query q = this.em.createQuery(query);
            return q.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EJBException(e);
        }
    }

    @Override
    public EntityRef getEntityRef(Object pk) throws Exception {
        try {
            Object o = this.em.find(this.entityClass, pk);
            return this.e2er(o);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception(t);
        }
    }

    @Override
    public List<EntityRef> getAllEntityRefs() throws Exception {
        try {
            String query = "SELECT DISTINCT X FROM " + this.entityName + " X ORDER BY X." + this.emd.id.get(0);
            List l = this.em.createQuery(query).getResultList();
            if (l.size() > 0) {
                return DefaultController.me2mer(l);
            }
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    public ServerFile getFile(String p, Object value) throws Exception {
        File f = this.emd.files.get(p);
        if (f == null) {
            throw new Exception(p + " no es un fichero " + this.emd.files);
        }
        if (value == null || value.toString().length() == 0) {
            return null;
        }
        return Util.readFromDisc(f, value.toString());
    }

    @Override
    public List<EntityRef> getFKValues(Object PP, String p) throws Exception {
        try {
            Query q;
            List l;
            ForeignKey fk = this.emd.fk.get(p);
            String query = "SELECT DISTINCT X FROM " + fk.targetEntity.getSimpleName() + " X";
            if (fk.card == ForeignKey.Card.OTO) {
                query = query + " WHERE NOT EXISTS (SELECT Y FROM " + this.entityName + " Y WHERE Y." + p + " = X)";
            }
            if ((l = (q = this.em.createQuery(query = query + " ORDER BY X." + fk.getTargetPk())).getResultList()).size() > 0) {
                return DefaultController.me2mer(l);
            }
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidParameterException(e.getMessage(), p);
        }
    }

    @Override
    public Object create(List properties, List values) throws InvalidParameterException {
        return this.createChild(properties, values, null, null, null, null);
    }

    @Override
    public Object createChild(List properties, List values, Class fatherClass, Object fatherPk, String fatherProperty, String childProperty) throws InvalidParameterException {
        String pkName = this.emd.id.get(0);
        Object pkValue = null;
        try {
            Object father;
            Object p;
            Object o = this.entityClass.newInstance();
            for (int i = 0; i < properties.size(); ++i) {
                p = (String)properties.get(i);
                Object v = values.get(i);
                if (this.emd.id.contains(p)) {
                    pkValue = v;
                }
                this._update(o, (String)p, v, true);
            }
            this.em.persist(o);
            Object object = father = fatherClass != null ? this.em.find(fatherClass, fatherPk) : null;
            if (father != null) {
                Collection currentChildren = (Collection)Introspector.getEntityMetaData(fatherClass).getReadMethod(fatherProperty).invoke(father, new Object[0]);
                currentChildren.add(o);
                Introspector.getEntityMetaData(fatherClass).getWriteMethod(fatherProperty).invoke(father, currentChildren);
                if (childProperty != null) {
                    Collection currentFathers = (Collection)Introspector.getEntityMetaData(o.getClass()).getReadMethod(childProperty).invoke(o, new Object[0]);
                    currentFathers.add(o);
                    Introspector.getEntityMetaData(o.getClass()).getWriteMethod(childProperty).invoke(o, currentFathers);
                }
            }
            this.em.flush();
            p = this.pdMap.get(pkName);
            Method m = ((PropertyDescriptor)p).getReadMethod();
            pkValue = m.invoke(o, new Object[0]);
            return pkValue;
        }
        catch (InvalidParameterException e) {
            throw e;
        }
        catch (EntityExistsException e) {
            throw new InvalidParameterException("Ya existe un registro " + this.emd.name + " con " + pkName + " " + pkValue, pkName);
        }
        catch (Throwable t) {
            t.printStackTrace();
            for (int i = 0; i < properties.size(); ++i) {
                String p = (String)properties.get(i);
                if (!this.emd.unique.contains(p)) continue;
                this.checkUnique(p, values.get(i));
            }
            throw new InvalidParameterException("Error al crear " + this.entityName + "\n" + t.getMessage(), null, t);
        }
    }

    public static String quitaAzentos(String s) {
        return s.toLowerCase().replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u").replace("\u00f1", "n").toLowerCase();
    }

    @Override
    public List search(String query, List pks) throws Exception {
        return this.search(null, query, pks);
    }

    @Override
    public List search(String property, String _query, List pks) throws Exception {
        if (pks != null && pks.isEmpty()) {
            return Collections.emptyList();
        }
        _query = DefaultController.quitaAzentos(_query);
        ArrayList<Object> result1 = new ArrayList<Object>();
        StringTokenizer st0 = new StringTokenizer(_query);
        int words = st0.countTokens();
        ArrayList[] result2 = new ArrayList[words];
        for (int i = 0; i < words; ++i) {
            result2[i] = new ArrayList();
        }
        int found = 0;
        try {
            Method m = null;
            Method m2 = null;
            try {
                if (property == null) {
                    m = this.emd.clazz.getMethod("paramString", null);
                } else {
                    m = this.pdMap.get(property).getReadMethod();
                    ForeignKey fk = this.emd.fk.get(property);
                    if (fk != null) {
                        m2 = fk.targetEntity.getMethod("paramString", null);
                    }
                }
            }
            catch (NoSuchMethodException fk) {
                // empty catch block
            }
            boolean fetch = true;
            String query = "Select X FROM " + this.emd.name + " X ";
            if (pks != null) {
                query = query + " WHERE X." + this.emd.id.get(0) + " IN " + pks.toString().replace("[", "(").replace("]", ")").replace("{", "(").replace("}", ")");
            }
            Query q = this.em.createQuery(query);
            long ts = System.currentTimeMillis();
            pks = q.getResultList();
            fetch = false;
            for (Object o : pks) {
                if (fetch) {
                    o = this.em.find(this.emd.clazz, o);
                }
                String desc = null;
                if (m != null) {
                    Object ret = m.invoke(o, (Object[])null);
                    desc = m2 != null ? (String)m.invoke(ret, (Object[])null) : String.valueOf(ret);
                } else {
                    desc = String.valueOf(o);
                }
                desc = DefaultController.quitaAzentos(desc);
                int idx = desc.indexOf(_query);
                if (idx != -1) {
                    Object pk = DefaultController.getIdReadMethod(o).invoke(o, new Object[0]);
                    result1.add(pk);
                } else {
                    if (found > 1007) continue;
                    StringTokenizer st = new StringTokenizer(_query);
                    int hits = 0;
                    if (st.countTokens() > 0) {
                        while (st.hasMoreTokens()) {
                            String _s = st.nextToken();
                            idx = desc.indexOf(_s);
                            if (idx == -1) continue;
                            ++hits;
                        }
                    }
                    if (hits > 0) {
                        Object pk = DefaultController.getIdReadMethod(o).invoke(o, new Object[0]);
                        result2[words - hits].add(pk);
                        ++found;
                    }
                }
                if (result1.size() <= 1007) continue;
                break;
            }
            for (int i = 0; i < result2.length; ++i) {
                result1.addAll(result2[i]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        return result1;
    }

    private Object _update(Object o, String p, Object value, boolean insertion) throws Exception {
        if (!insertion && this.emd.id.contains(p)) {
            throw new InvalidParameterException(this.emd.columnDisplayNames.get(p) + " es clave primaria y no se puede cambiar");
        }
        if (!insertion && this.emd.nonUpdatable.contains(p)) {
            throw new InvalidParameterException(this.emd.columnDisplayNames.get(p) + " no se puede cambiar");
        }
        AbstractCollection v = this.parseValue(o, p, value);
        PropertyDescriptor pd = this.pdMap.get(p);
        if (pd == null) {
            throw new InvalidParameterException("No se encontro la propiedad " + p);
        }
        Method setter = pd.getWriteMethod();
        try {
            System.out.println("About to invoke setter " + setter.getName() + " with " + v);
            if (v instanceof Set) {
                v = new HashSet(v);
            } else if (v instanceof ArrayList) {
                v = new ArrayList((List)((Object)v));
            }
            setter.invoke(o, v);
            if (!insertion) {
                this.em.flush();
            }
            return v;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.checkUnique(p, v);
            throw new InvalidParameterException("Error desconocido en el servidor " + t);
        }
    }

    @Override
    public void set(Object pk, String p, Object v) throws InvalidParameterException {
        try {
            Object object = this._update(this.findByPk(pk), p, v, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidParameterException(e);
        }
    }

    @Override
    public void forceRemove(Object pk) throws InvalidParameterException {
        try {
            Object o = this.findByPk(pk);
            this.em.remove(o);
        }
        catch (Exception e) {
            throw new InvalidParameterException("Error al eliminar " + this.emd.name + ":" + e.getMessage());
        }
    }

    @Override
    public void remove(Object pk) throws InvalidParameterException {
        try {
            Iterator<String> it = this.emd.br.keySet().iterator();
            String msg = "";
            while (it.hasNext()) {
                String p = it.next();
                Object v = this.get(pk, p);
                if (v == null) continue;
                BackRef br = this.emd.br.get(p);
                if (BackRef.Card.MTM.equals((Object)br.card)) continue;
                if (v instanceof Collection) {
                    int size = ((Collection)v).size();
                    msg = msg + "\n\n " + size + " " + br.source.getSimpleName() + "(s) ";
                    continue;
                }
                msg = msg + "\n\n " + br.source.getSimpleName() + " " + v;
            }
            if (!msg.isEmpty()) {
                throw new InvalidParameterException("No se puede eliminar " + this.emd.name + " " + pk + " porque tiene los siguientes datos asociados: " + msg);
            }
            Object o = this.findByPk(pk);
            this.em.remove(o);
            this.em.flush();
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (Exception e) {
            throw new InvalidParameterException("Error desconocido " + e.getMessage(), "...");
        }
    }

    public Long getCount() {
        Long count;
        try {
            count = (Long)this.em.createQuery("SELECT COUNT (x) FROM " + this.entityName + " x").getSingleResult();
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return count;
    }

    protected void checkUnique(String p, Object value) throws InvalidParameterException {
        String property = p;
        if (value instanceof EntityRef) {
            value = ((EntityRef)value).pk;
            ForeignKey fk = this.emd.fk.get(p);
            try {
                property = p + "." + fk.getTargetPk();
            }
            catch (IntrospectionException ie) {
                ie.printStackTrace();
                throw new InvalidParameterException("Error en checkUnique al buscar la clave primaria de la entidad de " + p);
            }
        }
        Query q = this.em.createQuery("SELECT e FROM " + this.entityName + " e WHERE e." + p + "= :v");
        q.setParameter("v", value);
        List result = q.getResultList();
        if (result.size() > 0) {
            throw new InvalidParameterException("Ya existe un(a) " + this.entityName + " con " + p + "\n\n" + result.get(0), p);
        }
    }

    protected Object findByPk(Object pk) throws Exception {
        Object o = this.em.find(this.entityClass, pk);
        if (o == null) {
            throw new Exception("No se encuentra " + this.entityName + "  con id " + pk);
        }
        return o;
    }
}

