/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.request;

import es.pablo.jee.ejb.jms.PersistenceEvent;
import es.pablo.jee.ejb.request.DefaultController;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityListener.class);
    public static ThreadLocal enabled = new ThreadLocal();

    public static boolean isEnabled() {
        return enabled.get() == null || Boolean.TRUE.equals(enabled.get());
    }

    public boolean isJmsPresent() {
        return this.getConnectionFactory() != null;
    }

    public static void setEnabled(boolean b) {
        enabled.set(b);
    }

    @PostPersist
    public void postPersist(Object o) {
        this.sendPersistenceEvent(PersistenceEvent.Type.CREATE, o);
    }

    @PostUpdate
    public void postUpdate(Object o) {
        this.sendPersistenceEvent(PersistenceEvent.Type.UPDATE, o);
    }

    @PostRemove
    public void postRemove(Object o) {
        this.sendPersistenceEvent(PersistenceEvent.Type.DELETE, o);
    }

    public void sendPersistenceEvent(PersistenceEvent.Type type, Object o) {
        if (!AbstractEntityListener.isEnabled() || !this.isJmsPresent()) {
            return;
        }
        try {
            Object pk = DefaultController.getId(o);
            PersistenceEvent pe = new PersistenceEvent(type, o.getClass(), this.getClass(), pk);
            pe.memo = "" + o;
            this.sendMessage(pe);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void sendMessage(final Serializable s) {
        Thread t = new Thread(){

            @Override
            public void run() {
                AbstractEntityListener.this.sendMessage(s, 0);
            }
        };
        t.start();
    }

    protected void sendMessage(Serializable s, int attempt) {
        this.sendMessage(s, attempt, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(Serializable s, int attempt, Connection con, Session ses, MessageProducer producer) {
        boolean sent = false;
        try {
            con = this.getConnectionFactory().createConnection();
            ses = con.createSession(false, 1);
            producer = ses.createProducer((Destination)this.getTopic());
            ObjectMessage om = ses.createObjectMessage();
            om.setObject(s);
            producer.send((Message)om);
            producer.close();
            ses.close();
            con.close();
            sent = true;
        }
        catch (Throwable t) {
            log.error("... FAILED", t);
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (Throwable om) {}
            }
            if (ses != null) {
                try {
                    ses.close();
                }
                catch (Throwable om) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Throwable om) {}
            }
        }
        if (!sent && attempt < 3) {
            this.sendMessage(s, ++attempt);
        }
    }

    protected abstract ConnectionFactory getConnectionFactory();

    protected abstract Topic getTopic();
}

