/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.request;

import es.pablo.jee.ejb.exception.InvalidParameterException;
import es.pablo.jee.ejb.request.AppController;
import es.pablo.jee.ejb.request.Controller;
import es.pablo.jee.ejb.request.DefaultController;
import es.pablo.jee.entity.EntityMetaData;
import es.pablo.jee.entity.EntityRef;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public abstract class AbstractAppController
implements AppController {
    protected HashMap<Class, Controller> map = new HashMap();

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean check() {
        return true;
    }

    @Override
    public String executeQuery(String query) throws InvalidParameterException {
        try {
            long ts0 = System.currentTimeMillis();
            Query q = this.getEntityManager().createQuery(query);
            String s = query.substring(0, 6);
            if (s.toUpperCase().equals("SELECT")) {
                List l = q.getResultList();
                long qt = System.currentTimeMillis() - ts0;
                StringBuffer sb = new StringBuffer();
                for (Object o : l) {
                    if (o != null && o.getClass().isArray()) {
                        o = Arrays.deepToString((Object[])o);
                    }
                    sb.append(o + "\n");
                }
                sb.append(l.size() + " registros, " + (System.currentTimeMillis() - ts0) + " ms.");
                String ret = sb.toString();
                this.getEntityManager().flush();
                return ret;
            }
            int n = q.executeUpdate();
            return "Filas afectadas: " + n;
        }
        catch (Throwable t) {
            t.printStackTrace();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(os));
            throw new InvalidParameterException(t.getMessage() + "\n" + os.toString());
        }
    }

    @Override
    public Object getBackReferenceIds(Class c, Object pk, String backRefProperty, Object qlFilter) throws Exception {
        return this.getController(c).getBackReferenceIds(pk, backRefProperty, qlFilter);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public Object checkLarge(Object arg) {
        return new ArrayList<Object>().add(arg);
    }

    protected synchronized Controller getController(Class cl) {
        Controller c = this.map.get(cl);
        if (c == null) {
            try {
                c = new DefaultController(this, this.getEntityManager(), cl);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Can not retrieve controller for " + cl, e);
            }
            this.map.put(cl, c);
        }
        return c;
    }

    protected synchronized void resetControllers() {
        this.map = new HashMap();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public List<EntityRef> getFKValues(Class c, Object pk, String p) throws Exception {
        return this.getController(c).getFKValues(pk, p);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public EntityRef getEntityRef(Class c, Object pk) throws Exception {
        return this.getController(c).getEntityRef(pk);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public List<EntityRef> getAllEntityRefs(Class c) throws Exception {
        return this.getController(c).getAllEntityRefs();
    }

    @Override
    public Object create(Class c, List properties, List values) throws InvalidParameterException {
        Object ret = this.getController(c).create(properties, values);
        return ret;
    }

    @Override
    public Object createChild(Class c, List properties, List values, Class fatherClass, Object fatherPk, String fatherProperty, String childProperty) throws InvalidParameterException {
        Object ret = this.getController(c).createChild(properties, values, fatherClass, fatherPk, fatherProperty, childProperty);
        return ret;
    }

    @Override
    public void forceRemove(Class c, Object pk) throws InvalidParameterException {
        this.getController(c).forceRemove(pk);
    }

    @Override
    public void remove(Class c, Object pk) throws InvalidParameterException {
        this.getController(c).remove(pk);
    }

    @Override
    public EntityMetaData getEntityMetaData(Class c) throws Exception {
        return (EntityMetaData)this.getController(c).getBeanInfo().getBeanDescriptor().getValue("emd");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public Object get(Class c, Object pk, String property) throws Exception {
        return this.getController(c).get(pk, property);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public Object[] get(Class c, List pks, List<String> properties) throws Exception {
        return this.getController(c).get(pks, properties);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public Object[] get(Class c, Object pk, List<String> properties) throws Exception {
        return this.getController(c).get(pk, properties);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public Object[] getFullTable(Class c) throws Exception {
        return this.getController(c).getFullTable();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public List search(Class c, String s, List pks) throws Exception {
        long ts = System.currentTimeMillis();
        ArrayList l = new ArrayList(this.getController(c).search(s, pks));
        long ts1 = System.currentTimeMillis();
        l.trimToSize();
        return l;
    }

    @Override
    public void set(Class c, Object pk, String property, Object value) throws InvalidParameterException {
        this.getController(c).set(pk, property, value);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public List getPKs(Class c) throws Exception {
        return this.getController(c).getPKs();
    }

    protected abstract EntityManager getEntityManager();
}

