/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.jee.ejb.jms;

import es.pablo.jee.ejb.jms.PersistenceEvent;
import es.pablo.jee.ejb.jms.Refreshable;
import es.pablo.jee.ejb.swing.ClientSideModel;
import es.pablo.util.Util;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Refresher
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(Refresher.class);
    private static final int MAX_THREAD_COUNT = 40;
    private static final int POOL_RESIZE = 10;
    private static final int INITIAL_POOL_SIZE = 10;
    private static final int QUEUE_SIZE = 15;
    public static boolean MULTI_THREAD = true;
    private HashMap<Class, ArrayList<Refreshable>> listeners = new HashMap();
    private List<Refreshable> listenersOfAll = new ArrayList<Refreshable>();
    private Connection con = null;
    public static ConnectionFactory cf;
    public static Topic topic;
    public static MessageConsumer consumer;
    private static Refresher instance;
    int totalEvents = 0;
    int failed = 0;
    LinkedBlockingQueue<EventAndRefreshable> queue = new LinkedBlockingQueue(15);
    static volatile int workerThreadCount;
    static volatile int busyThreads;

    public static synchronized Refresher getInstance() throws JMSException {
        if (instance == null) {
            instance = new Refresher(cf, topic);
        }
        return instance;
    }

    private Refresher(final ConnectionFactory cf, final Topic topic) throws JMSException {
        final Refresher listener = this;
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    WorkerThread t = new WorkerThread();
                    t.start();
                    Refresher.this.con = cf.createConnection();
                    Session session = Refresher.this.con.createSession(false, 1);
                    consumer = session.createConsumer((Destination)topic);
                    consumer.setMessageListener(listener);
                    Refresher.this.con.start();
                    ClientSideModel.getInstance().flushAll();
                }
                catch (Exception e) {
                    Util.show(null, "No se pudo conectar con el servidor (JMS)");
                    System.exit(0);
                }
            }
        };
        t.start();
    }

    public synchronized void close() {
        log.debug("REFRESHER: Withdrawing from event notification ");
        try {
            if (consumer != null) {
                consumer.setMessageListener(null);
                log.debug("REFRESHER: Closing consumer");
                consumer.close();
                consumer = null;
            } else {
                log.debug("REFRESHER: Consumer was closed or not started");
            }
            log.debug("REFRESHER: Consumer closed");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.debug("REFRESHER: Error while closing consumner");
        }
        try {
            if (this.con != null) {
                this.con.close();
                log.debug("REFRESHER: Connection closed");
                this.con = null;
            } else {
                log.debug("REFRESHER: Connection was closed or not started");
            }
        }
        catch (JMSException e) {
            log.error("Encountered JMS exception", (Throwable)e);
        }
    }

    public synchronized void subscribeToAll(Refreshable r) {
        this.listenersOfAll.add(r);
    }

    public synchronized boolean unsubscribe(Class c, Refreshable r) {
        List l = this.listeners.get(r);
        if (l != null) {
            return l.remove(r);
        }
        return false;
    }

    public synchronized void subscribe(Class c, Refreshable r) {
        if (r == null) {
            throw new NullPointerException("Cannot subscribe null refreshable");
        }
        if (c == null) {
            throw new NullPointerException("Cannot subscribe to null Class");
        }
        ArrayList<Object> al = null;
        if (this.listeners.containsKey(c)) {
            al = this.listeners.get(c);
        } else {
            al = new ArrayList();
            this.listeners.put(c, al);
        }
        if (!al.contains(r)) {
            al.add(r);
        } else {
            log.debug(r.getClass() + " " + r.toString() + " already Subscribed to " + c.getSimpleName());
        }
    }

    public synchronized void refreshListeners(PersistenceEvent pe) throws Exception {
        ArrayList<Refreshable> allListeners = new ArrayList<Refreshable>();
        allListeners.addAll(this.listenersOfAll);
        if (this.queue.remainingCapacity() < 2) {
            for (Map.Entry<Class, ArrayList<Refreshable>> entry : this.listeners.entrySet()) {
                allListeners.addAll((Collection)entry.getValue());
            }
            pe = new PersistenceEvent(PersistenceEvent.Type.FULL_REFRESH);
            this.queue.clear();
        } else {
            ArrayList<Refreshable> al = this.listeners.get(pe.clazz);
            if (al != null) {
                allListeners.addAll(al);
            }
        }
        for (Refreshable r : allListeners) {
            this.addEventToQueue(r, pe);
        }
    }

    public void onMessage(Message m) {
        block2: {
            try {
                ++this.totalEvents;
                ObjectMessage om = (ObjectMessage)m;
                PersistenceEvent pe = (PersistenceEvent)om.getObject();
                this.refreshListeners(pe);
            }
            catch (Throwable t) {
                ++this.failed;
                t.printStackTrace(System.err);
                if (this.failed <= 10 || !((double)((float)this.failed / (float)this.totalEvents) > 0.9)) break block2;
                this.close();
            }
        }
    }

    public synchronized void addEventToQueue(Refreshable r, PersistenceEvent pe) {
        boolean full;
        EventAndRefreshable er = new EventAndRefreshable();
        er.r = r;
        er.pe = pe;
        boolean bl = full = !this.queue.offer(er);
        if (full) {
            // empty if block
        }
        if (MULTI_THREAD && full && workerThreadCount < 40) {
            for (int i = 0; i < 10; ++i) {
                WorkerThread t = new WorkerThread();
                t.start();
            }
            this.queue.offer(er);
        }
    }

    static {
        instance = null;
        workerThreadCount = 0;
        busyThreads = 0;
    }

    public class WorkerThread
    extends Thread {
        public WorkerThread() {
            super("Refresher worker Thread #" + workerThreadCount);
            ++workerThreadCount;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        EventAndRefreshable er;
                        if ((er = Refresher.this.queue.poll(30L, TimeUnit.SECONDS)) == null) {
                            continue;
                        }
                        ++busyThreads;
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        er.r.refresh(er.pe);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                        catch (InterruptedException | InvocationTargetException t) {
                            t.printStackTrace();
                        }
                        --busyThreads;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private static class EventAndRefreshable {
        PersistenceEvent pe;
        Refreshable r;

        private EventAndRefreshable() {
        }

        public String toString() {
            return "[" + this.r.getClass().getSimpleName() + "->" + this.pe + "]\n";
        }
    }
}

