/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.search;

import com.anahata.yam.model.search.ExpandSearch;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PojoSearchConverter<T> {
    @ExpandSearch(value=false)
    private T item;
    private String searchValue;

    public static <U> List<U> unwrap(List<PojoSearchConverter<U>> l) {
        return l.stream().map(e -> e.getItem()).collect(Collectors.toList());
    }

    public static <U> List<PojoSearchConverter<U>> wrap(List<U> l, Function<U, String> f) {
        return l.stream().map(e -> new PojoSearchConverter<Object>(e, (String)f.apply(e))).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"item", "searchValue"})
    public PojoSearchConverter(T item, String searchValue) {
        this.item = item;
        this.searchValue = searchValue;
    }

    public T getItem() {
        return this.item;
    }

    public String getSearchValue() {
        return this.searchValue;
    }
}

