/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.validation;

import com.anahata.util.cdi.Cdi;
import com.anahata.util.validation.ConditionalValidation;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationUtils {
    private static final Logger log = LoggerFactory.getLogger(ValidationUtils.class);
    private static final Class<?>[] DEFAULT_VALIDATION_GROUP = new Class[]{Default.class};

    public static String getValidationPropertyName(ConstraintViolation cv) {
        return ValidationUtils.getValidationPropertyName(cv, false);
    }

    public static String getValidationPropertyName(ConstraintViolation cv, boolean includeIndex) {
        Validate.notNull((Object)cv);
        ArrayList<String> nodes = new ArrayList<String>();
        String prev = null;
        for (Path.Node node : cv.getPropertyPath()) {
            if (node.getKind() != ElementKind.PROPERTY) continue;
            String name = node.getName();
            if (name.startsWith("#")) {
                prev = null;
                name = name.substring(1);
            }
            if (prev != null) {
                if (node.getIndex() != null && includeIndex) {
                    prev = prev + "[" + node.getIndex() + "]";
                }
                nodes.add(prev);
            }
            prev = name;
        }
        if (prev != null) {
            nodes.add(prev);
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String node : nodes) {
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            sb.append(node);
        }
        return sb.toString();
    }

    public static Class<?>[] getValidationGroups(Object bean) {
        if (bean == null) {
            return null;
        }
        if (!(bean instanceof ConditionalValidation)) {
            return DEFAULT_VALIDATION_GROUP;
        }
        ConditionalValidation cv = (ConditionalValidation)bean;
        return cv.getValidationGroups();
    }

    public static <T> Set<ConstraintViolation<T>> validate(Validator validator, T object) {
        Validate.notNull((Object)validator);
        return validator.validate(object, (Class[])ValidationUtils.getValidationGroups(object));
    }

    public static <T> void validate(T object, Class ... groups) throws ConstraintViolationException {
        ValidationUtils.validate(Cdi.get(Validator.class, new Annotation[0]), object, groups);
    }

    public static <T> void validate(Validator validator, T object, Class ... groups) throws ConstraintViolationException {
        Validate.notNull((Object)validator);
        Set violations = validator.validate(object, groups);
        if (violations != null && !violations.isEmpty()) {
            log.debug("Validation failed for {}, groups={}, violations={}", new Object[]{object, groups, violations});
            throw new ConstraintViolationException(violations);
        }
    }

    public static boolean isValid(Validator validator, Object object, Class ... groups) {
        Validate.notNull((Object)validator);
        Validate.notNull((Object)object);
        return validator.validate(object, groups).isEmpty();
    }

    public static boolean isValid(Object object, Class ... groups) {
        return ValidationUtils.isValid(Cdi.get(Validator.class, new Annotation[0]), object, new Class[0]);
    }

    public static String toString(Set<ConstraintViolation<?>> violations) {
        StringBuilder sb = new StringBuilder();
        sb.append(violations.size());
        sb.append(" Constraint violations: ");
        int counter = 1;
        for (ConstraintViolation<?> cv : violations) {
            sb.append("\n\tViolation ");
            sb.append(counter).append(" of ").append(violations.size());
            sb.append(":[");
            sb.append("root bean =");
            sb.append(cv.getRootBean());
            sb.append(",leaf bean =");
            sb.append(cv.getLeafBean());
            sb.append(", path = ");
            sb.append(cv.getPropertyPath());
            sb.append(", message = ");
            sb.append(cv.getMessage());
            sb.append(", invalid value= ");
            sb.append(cv.getInvalidValue());
            sb.append("] ");
        }
        return sb.toString();
    }

    public static String getConstraintValidationDetails(Throwable t) {
        String details = null;
        for (Throwable t1 : ExceptionUtils.getThrowableList((Throwable)t)) {
            if (!(t1 instanceof ConstraintViolationException)) continue;
            ConstraintViolationException cve = (ConstraintViolationException)t1;
            details = ValidationUtils.toString(cve.getConstraintViolations());
        }
        return details;
    }

    private ValidationUtils() {
    }
}

