/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.transport;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLookupUtils {
    private static final Logger log = LoggerFactory.getLogger(ServiceLookupUtils.class);

    public static <T> T serviceLookup(String appName, Class<T> serviceInterface) throws ClassNotFoundException, NamingException, SecurityException {
        return ServiceLookupUtils.serviceLookupInternal("java:global/" + appName + "/", serviceInterface);
    }

    public static <T> T serviceLookup(Class<T> serviceInterface) throws ClassNotFoundException, NamingException, SecurityException {
        return ServiceLookupUtils.serviceLookupInternal("java:module/", serviceInterface);
    }

    private static <T> T serviceLookupInternal(String prefix, Class<T> serviceInterface) throws ClassNotFoundException, NamingException, SecurityException {
        Object ret;
        String serviceInterfaceName = serviceInterface.getName();
        String serviceImplName = serviceInterfaceName.endsWith("Local") ? serviceInterfaceName.substring(0, serviceInterfaceName.lastIndexOf("Local")) + "Impl" : serviceInterface.getName() + "Impl";
        Class<?> serviceImpl = ServiceLookupUtils.loadClass(serviceImplName);
        String lookupName2 = prefix + serviceImpl.getSimpleName();
        String lookupName1 = lookupName2 + "!" + serviceInterface.getName();
        log.trace("Looking ejb by jndi name {}", (Object)lookupName1);
        InitialContext ctx = new InitialContext();
        long ts = System.currentTimeMillis();
        try {
            log.trace("Looking ejb by jndi name {}", (Object)lookupName1);
            ret = ctx.lookup(lookupName1);
        }
        catch (Exception e) {
            log.trace("Looking ejb by jndi name {}", (Object)lookupName2);
            ret = ctx.lookup(lookupName2);
        }
        ts = System.currentTimeMillis() - ts;
        log.trace("Looking ejb by jndi {} took {} ", (Object)ts);
        return (T)ret;
    }

    private static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return Class.forName(className, false, loader);
        }
        return Class.forName(className);
    }
}

