/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.props;

import com.anahata.util.env.ApplicationEnvironment;
import com.anahata.util.lang.ResourceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesUtils {
    private static final Logger log = LoggerFactory.getLogger(PropertiesUtils.class);
    private static final String APP_PROPS = "/application.properties";

    public static void load(Properties props, String propFileName) {
        Validate.notNull((Object)props);
        Validate.notNull((Object)propFileName);
        URL u = ResourceUtils.getResource(propFileName);
        Validate.isTrue((u != null ? 1 : 0) != 0, (String)"Could not load properties file: %s", (Object[])new Object[]{propFileName});
        log.debug("Loading {}", (Object)u);
        InputStream is = null;
        try {
            is = u.openStream();
            Properties loaded = new Properties();
            loaded.load(u.openStream());
            log.debug("Loaded from {}:", (Object)propFileName);
            PropertiesUtils.logDebugAlphaSorted(loaded);
            props.putAll((Map<?, ?>)loaded);
            log.debug("Resulting properties:");
            PropertiesUtils.logDebugAlphaSorted(loaded);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file: " + propFileName, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("There was an error closing the properties file input stream for properties file: " + propFileName, (Throwable)e);
                }
            }
        }
    }

    public static String toStringAlphaSorted(Properties props) {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> propMap = new TreeMap<String, String>();
        for (String propName : props.stringPropertyNames()) {
            String propValue = props.getProperty(propName);
            propMap.put(propName, propValue);
        }
        for (String propName : propMap.keySet()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(propName).append("=").append((String)propMap.get(propName));
        }
        return sb.toString();
    }

    private static void logDebugAlphaSorted(Properties props) {
        String[] s;
        for (String s1 : s = PropertiesUtils.toStringAlphaSorted(props).split("\n")) {
            log.debug(s1);
        }
    }

    public static void loadAppProps(Properties props, ApplicationEnvironment env) {
        Validate.notNull((Object)props);
        Validate.notNull((Object)((Object)env));
        log.debug("Loading properties from file {}", (Object)APP_PROPS);
        PropertiesUtils.load(props, APP_PROPS);
        String propsFile = "/application-" + env.toString().toLowerCase() + ".properties";
        log.debug("Loading properties from file {}", (Object)propsFile);
        try {
            PropertiesUtils.load(props, propsFile);
        }
        catch (IllegalArgumentException e) {
            log.info("No environment specific property file found for: {}", (Object)propsFile);
        }
        if (env == ApplicationEnvironment.LOCAL) {
            String osUserName = System.getProperty("user.name");
            String osUserPropsFile = "/application-" + env.toString().toLowerCase() + "-" + osUserName + ".properties";
            log.debug("Loading properties from file {}", (Object)osUserPropsFile);
            try {
                PropertiesUtils.load(props, osUserPropsFile);
            }
            catch (IllegalArgumentException e) {
                log.info("No os user environment specific property file found for: {}", (Object)osUserPropsFile);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Final properties:");
            PropertiesUtils.logDebugAlphaSorted(props);
        }
    }

    public static void setSystemProperties(Properties props, String prefix) {
        Validate.notNull((Object)props);
        Validate.notNull((Object)prefix);
        prefix = prefix + ".";
        int start = prefix.length();
        for (String prop : props.stringPropertyNames()) {
            if (!prop.startsWith(prefix)) continue;
            String name = prop.substring(start);
            String value = props.getProperty(prop);
            log.debug("Setting system property name={} value={}", (Object)name, (Object)value);
            System.getProperties().setProperty(name, value);
        }
    }

    public static void setSystemProperties(Properties props) {
        PropertiesUtils.setSystemProperties(props, "sysprop");
    }

    private PropertiesUtils() {
    }
}

