/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.progress;

import java.util.concurrent.TimeUnit;

public final class ProgressUtils {
    public static long getEstimatedDuration(long startTime, long processed, long total) {
        float ellapsed = System.currentTimeMillis() - startTime;
        float timePerFile = ellapsed / (float)processed;
        float remainingFiles = total - processed;
        Float fl = new Float(remainingFiles * timePerFile);
        long remainingTime = fl.longValue();
        return remainingTime;
    }

    public static String getEstimatedDurationDisplay(long startTime, long processed, long total) {
        return ProgressUtils.durationToHhMmSs(ProgressUtils.getEstimatedDuration(startTime, processed, total));
    }

    public static String durationToHhMmSs(long duration) {
        String time = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(duration), TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration)), TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration)));
        return time;
    }

    private ProgressUtils() {
    }
}

