/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.plaf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JniUtils {
    private static final Logger log = LoggerFactory.getLogger(JniUtils.class);

    public static void loadPackagedLibrary(String resource) {
        String fileName = null;
        try {
            URL url = JniUtils.class.getResource(resource);
            fileName = resource.substring(resource.lastIndexOf("/") + 1);
            log.info("Creating temp file for native library " + fileName);
            File fileOut = File.createTempFile("anahata-jni-utils", fileName);
            try (InputStream in = url.openStream();
                 FileOutputStream out = new FileOutputStream(fileOut);){
                log.info("Writing native library " + url.getFile() + " to: " + fileOut.getAbsolutePath());
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            log.info("Loading native library " + fileOut.toString());
            System.load(fileOut.toString());
        }
        catch (Exception e) {
            log.error("Failed to load native library", (Throwable)e);
            throw new RuntimeException("Failed to load library resource=" + resource + " fileName=" + fileName, e);
        }
    }

    public static void addToLibraryPath(String resource) {
        String javaLibraryPath = System.getProperty("java.library.path");
        log.info("javaLibraryPath = " + javaLibraryPath);
        String fileName = null;
        try {
            URL url = JniUtils.class.getResource(resource);
            fileName = resource.substring(resource.lastIndexOf("/") + 1);
            log.info("Creating temp file for native library " + fileName);
            File tempDir = FileUtils.getTempDirectory();
            tempDir = new File(tempDir, "anahata-util-jni-" + System.currentTimeMillis());
            tempDir.mkdir();
            log.info("temp dir will be " + tempDir);
            File fileOut = new File(tempDir, fileName);
            try (InputStream in = url.openStream();
                 FileOutputStream out = new FileOutputStream(fileOut);){
                log.info("Writing native library " + url.getFile() + " to: " + fileOut.getAbsolutePath());
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            log.info("library deployed to " + fileOut + " size=" + fileOut.length());
            javaLibraryPath = javaLibraryPath + System.getProperty("path.separator") + tempDir;
            log.info("Updating java.library.path to " + javaLibraryPath);
            System.setProperty("java.library.path", javaLibraryPath);
            log.info("Writing native library " + url.getFile() + " to: " + fileOut.getAbsolutePath());
        }
        catch (Exception e) {
            log.error("Failed to load native library", (Throwable)e);
            throw new RuntimeException("Failed to load library resource=" + resource + " fileName=" + fileName, e);
        }
    }

    private JniUtils() {
    }
}

