/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.net;

import com.anahata.util.net.InetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HMAClient {
    private static final Logger log = LoggerFactory.getLogger(HMAClient.class);
    private String realPublicIp;
    private String executable;

    public HMAClient(String executable, String realPublicIp) {
        this.executable = executable;
        this.realPublicIp = realPublicIp;
    }

    public HMAClient(String executable) {
        this(executable, InetUtils.getExternalIpAddress());
    }

    public void connect() throws Exception {
        log.debug("Before connecting, public ip is: {}", (Object)InetUtils.getExternalIpAddress());
        this.run("-connect", false);
        log.debug("After connecting, public ip is: {}", (Object)InetUtils.getExternalIpAddress());
    }

    public void disconnect() throws Exception {
        log.debug("Before connecting, public ip is: {}", (Object)InetUtils.getExternalIpAddress());
        this.run("-disconnect", true);
        log.debug("After connecting, public ip is: {}", (Object)InetUtils.getExternalIpAddress());
    }

    public String changeIp() throws Exception {
        try {
            String oldPublicIp = InetUtils.getExternalIpAddress();
            this.run("-changeip", true);
            boolean changed = false;
            String newPublicIp = null;
            int count = 0;
            while (true) {
                if (count % 60 == 59) {
                    log.debug("Count " + count + " calling changeIp again");
                    this.changeIp();
                }
                if (!(newPublicIp = InetUtils.getExternalIpAddress()).equals(oldPublicIp)) {
                    changed = true;
                    log.debug("External ip change detected {}", (Object)oldPublicIp, (Object)newPublicIp);
                }
                if (changed && newPublicIp.equals(oldPublicIp)) {
                    log.debug("External ip changed but got the same ip again, changing again");
                    newPublicIp = this.changeIp();
                }
                if (changed && !newPublicIp.equals(this.realPublicIp)) break;
                log.debug("Waiting for new IP address");
                Thread.sleep(1000L);
            }
            log.debug("Previous ip: {}, new ip {} ", (Object)oldPublicIp, (Object)newPublicIp);
            return newPublicIp;
        }
        catch (InterruptedException ex) {
            log.error("Exception running HMA", (Throwable)ex);
            throw ex;
        }
    }

    private void run(String parameter, boolean wait) throws Exception {
        String cmd = this.executable + " " + parameter;
        log.debug(cmd);
        Process p = Runtime.getRuntime().exec(cmd);
        if (wait) {
            // empty if block
        }
    }

    private HMAClient() {
    }

    public String getRealPublicIp() {
        return this.realPublicIp;
    }

    public void setRealPublicIp(String realPublicIp) {
        this.realPublicIp = realPublicIp;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }
}

