/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging.slf4j;

import com.anahata.util.error.StackTraceParser;
import com.anahata.util.logging.slf4j.ErrorMonitoringPrintStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ErrorStreamMonitor
extends Thread {
    private static final Logger log = LoggerFactory.getLogger((String)"System.err");
    private static final boolean LOG_ENABLED = false;
    private static final long ERROR_TIMEOUT = 200L;
    private ErrorMonitoringPrintStream ps;

    public ErrorStreamMonitor(ErrorMonitoringPrintStream ps) {
        this.ps = ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long currTs = System.currentTimeMillis();
            this.log("Waiting");
            while (this.ps.isCollecting() && currTs - this.ps.getLastLogTs() < 200L) {
                try {
                    ErrorStreamMonitor errorStreamMonitor = this;
                    synchronized (errorStreamMonitor) {
                        this.wait(200L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                currTs = System.currentTimeMillis();
            }
            List<String> buffer = this.ps.getBufferAndReset();
            Throwable error = StackTraceParser.parse(buffer);
            log.error("Unhandled exception caught from System.err", error);
        }
        catch (Throwable t) {
            log.error("An error was encountered attempting to parse System.err errors", t);
        }
        this.log("Error logged, setting collecting to false");
        this.ps.setCollecting(false);
        this.log("Exiting");
    }

    private void log(String message) {
    }

    private ErrorStreamMonitor() {
    }
}

