/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging;

import com.anahata.util.config.internal.ApplicationPropertiesFactory;
import com.anahata.util.logging.RemoteServiceWarning;
import com.anahata.util.transport.rpc.RpcStreamer;
import com.anahata.util.transport.rpc.client.RpcInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class RemoteServiceLogger
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RemoteServiceLogger.class);
    private static long DEFAULT_MAX_RET_SIZE = 262144L;
    private static long DEFAULT_MAX_ARGS_SIZE = 131072L;
    private static long DEFAULT_MAX_TIME = 5000L;
    @Inject
    private Event<RemoteServiceWarning> event;
    private Object remoteProxy;
    @Inject
    private RpcStreamer streamer;
    @Inject
    private ApplicationPropertiesFactory appPropsFactory;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long maxArgsSize = this.getMaxArgsSize(method);
        long maxRetSize = this.getMaxRetSize(method);
        long maxTime = this.getMaxTime(method);
        long compressTs = System.currentTimeMillis();
        long argsSize = this.streamer.getCompressedSize(args);
        HashSet<RemoteServiceWarning.Reason> reasons = new HashSet<RemoteServiceWarning.Reason>();
        String className = RemoteServiceLogger.getProxyClassName(this.remoteProxy);
        compressTs = System.currentTimeMillis() - compressTs;
        long time = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("Invoking @RemoteService {} {}.{} with {} bytes of args data", new Object[]{method.getReturnType(), className, method.getName(), argsSize});
        }
        Object ret = null;
        try {
            ret = method.invoke(this.remoteProxy, args);
        }
        catch (Throwable e) {
            while (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            log.debug("unwrapped exception: {}", e);
            throw e;
        }
        time = System.currentTimeMillis() - time;
        long retSize = this.streamer.getCompressedSize(ret);
        log.debug("@RemoteService {}.{} received data = {} bytes. took {} ms ", new Object[]{className, method.getName(), retSize, time});
        if (argsSize > maxArgsSize) {
            reasons.add(RemoteServiceWarning.Reason.ARGS_LARGE);
        }
        if (retSize > maxRetSize) {
            reasons.add(RemoteServiceWarning.Reason.RET_LARGE);
        }
        if (time > maxTime) {
            reasons.add(RemoteServiceWarning.Reason.SLOW);
        }
        if (!reasons.isEmpty()) {
            RemoteServiceWarning rsw = new RemoteServiceWarning();
            rsw.setReasons(reasons);
            rsw.setClassName(className);
            rsw.setMethod(method);
            rsw.setArgs(args);
            rsw.setArgsString(args != null ? Arrays.toString(args) : "");
            rsw.setArgsSize(argsSize);
            rsw.setRet(ret);
            rsw.setRetString(ret != null ? ret.toString() : "");
            rsw.setRetSize(retSize);
            rsw.setTime(time);
            this.event.fire((Object)rsw);
        }
        return ret;
    }

    private static String getProxyClassName(Object proxyObject) {
        if (Proxy.isProxyClass(proxyObject.getClass()) && Proxy.getInvocationHandler(proxyObject) instanceof RpcInvocationHandler) {
            RpcInvocationHandler rpcHandler = (RpcInvocationHandler)Proxy.getInvocationHandler(proxyObject);
            return rpcHandler.getClazz().getSimpleName();
        }
        return proxyObject.getClass().getSimpleName();
    }

    private long getMaxArgsSize(Method method) {
        return DEFAULT_MAX_ARGS_SIZE;
    }

    private long getMaxRetSize(Method method) {
        return DEFAULT_MAX_RET_SIZE;
    }

    private long getMaxTime(Method method) {
        String value = this.appPropsFactory.getAppProperties().getProperty("yam.error.performance.unresponsive.max.millis");
        return value != null ? Long.valueOf(value) : DEFAULT_MAX_TIME;
    }

    public void setRemoteProxy(Object remoteProxy) {
        this.remoteProxy = remoteProxy;
    }
}

