/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging;

import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(LoggingInvocationHandler.class);
    Object delegate;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String sargs = "";
        if (args != null) {
            sargs = " arguments = " + Arrays.asList(args);
        }
        log.info("Calling {} {}", (Object)method.getName(), (Object)sargs);
        Object ret = method.invoke(this.delegate, args);
        log.info("Call to {} {} returned {}", new Object[]{method.getName(), sargs, ret});
        return ret;
    }

    public static <T> T newProxy(T delegate) {
        return (T)Proxy.newProxyInstance(LoggingInvocationHandler.class.getClassLoader(), ClassUtils.getAllInterfaces(delegate.getClass()).toArray(new Class[0]), (InvocationHandler)new LoggingInvocationHandler(delegate));
    }

    @ConstructorProperties(value={"delegate"})
    public LoggingInvocationHandler(Object delegate) {
        this.delegate = delegate;
    }
}

