/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jsf;

import com.anahata.util.formatting.FormattingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JSFTableModel<T> {
    private static final Logger log = LoggerFactory.getLogger(JSFTableModel.class);
    private String sortColumn = null;
    private Comparator<T> comparator = null;
    private boolean sortAscending = true;
    private boolean needsResort = false;
    private boolean nullsAreHigh = false;
    private List<T> list = new ArrayList<T>();
    private Set<T> selection = new HashSet<T>();
    private boolean singleSelection = true;
    private boolean atLeastOne = true;
    private List<SelectionListener<T>> listeners = new ArrayList<SelectionListener<T>>();
    private SelectionFilter selectionFilter = null;
    private SelectionWrapperMap selectionWrapper = new SelectionWrapperMap();

    public JSFTableModel() {
    }

    public JSFTableModel(boolean singleSelection) {
        this.singleSelection = singleSelection;
        this.atLeastOne = singleSelection;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean sortAscending) {
        if (!sortAscending == this.sortAscending) {
            this.needsResort = true;
        }
        this.sortAscending = sortAscending;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(String sortColumn) {
        Validate.notNull((Object)sortColumn);
        if (!sortColumn.equals(this.sortColumn)) {
            this.needsResort = true;
        }
        this.sortColumn = sortColumn;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public boolean isNullsAreHigh() {
        return this.nullsAreHigh;
    }

    public void setNullsAreHigh(boolean nullsAreHigh) {
        this.nullsAreHigh = nullsAreHigh;
    }

    public List<T> getList() {
        if (this.needsResort) {
            this.sort();
        }
        return this.list;
    }

    public void sort() {
        if (this.comparator == null && this.sortColumn == null) {
            this.needsResort = false;
            return;
        }
        ComparableComparator c = null;
        if (this.comparator != null) {
            c = this.comparator;
        } else if (!StringUtils.isEmpty((CharSequence)this.sortColumn)) {
            c = ComparableComparator.getInstance();
            c = new BeanComparator(this.sortColumn, (Comparator)new NullComparator((Comparator)c, this.nullsAreHigh));
        }
        if (!this.sortAscending) {
            c = new ReverseComparator((Comparator)c);
        }
        Collections.sort(this.list, c);
        this.needsResort = false;
    }

    public void setList(List<T> list) {
        this.setList(list, true);
    }

    public void setList(List<T> list, boolean keepSelection) {
        this.list = new ArrayList<T>(list);
        if (keepSelection) {
            this.selection.retainAll(list);
        } else {
            this.selection.clear();
        }
        this.needsResort = true;
    }

    public void clear() {
        this.list.clear();
        this.clearSelection();
    }

    public boolean isAtLeastOne() {
        return this.atLeastOne;
    }

    public void setAtLeastOne(boolean atLeastOne) {
        this.atLeastOne = atLeastOne;
    }

    public void setSelectionFilter(SelectionFilter selectionFilter) {
        this.selectionFilter = selectionFilter;
    }

    public void selectFirstIfNoSelection() {
        this.getList();
        if (this.selection.isEmpty() && !this.list.isEmpty()) {
            this.addSelectedObject(this.list.get(0));
        }
    }

    public void clearSelection() {
        for (T t : this.selection) {
            this.notifyListeners(t, false);
        }
        this.selection.clear();
    }

    public Map<T, Boolean> getSelection() {
        return this.selectionWrapper;
    }

    public void setSelectedObject(T t) {
        if (t == null) {
            this.selection.clear();
            return;
        }
        this.addSelectedObject(t);
    }

    public boolean isSelected(T t) {
        this.validateSelectable(t);
        return this.selection.contains(t);
    }

    public void setSelectedObjects(List<T> l) {
        for (T t1 : l) {
            this.validateSelectable(t1);
        }
        this.selection = new HashSet<T>(l);
        for (T t : this.selection) {
            this.notifyListeners(t, true);
        }
    }

    public void addSelectedObject(T t) {
        this.validateSelectable(t);
        if (!this.isSelectable(t)) {
            return;
        }
        if (this.singleSelection) {
            this.selection.clear();
        }
        this.selection.add(t);
        log.debug("Add selected Object={} totalSelected={}", t, (Object)this.selection.size());
        this.notifyListeners(t, true);
    }

    public void removeSelectedObject(T t) {
        if (this.atLeastOne && this.selection.contains(t) && this.selection.size() == 1) {
            log.debug("Will not remove Object={} as atLeastOne is enabled", t);
            return;
        }
        this.selection.remove(t);
        log.debug("Remove selected Object={} totalSelected={}", t, (Object)this.selection.size());
        this.notifyListeners(t, false);
    }

    public List<T> getSelectedObjects() {
        ArrayList<T> ret = new ArrayList<T>();
        for (T t : this.selection) {
            int idx = this.list.indexOf(t);
            if (idx == -1) {
                throw new IllegalStateException("Unexisting object " + t + " mark as selected but not present in the list");
            }
            ret.add(this.list.get(idx));
        }
        return ret;
    }

    public T getSelectedObject() {
        List<T> ret = this.getSelectedObjects();
        int size = ret.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return ret.get(0);
        }
        return ret.get(0);
    }

    public void addSelectionListener(SelectionListener<T> listener) {
        this.listeners.add(listener);
    }

    public boolean isSelectable(T t) {
        this.validateSelectable(t);
        return this.selectionFilter == null || this.selectionFilter.isSelectable(t);
    }

    public void selectAll() {
        if (this.selectionFilter == null) {
            this.selection = new HashSet<T>(this.list);
        } else {
            this.selection.clear();
            for (T t : this.list) {
                if (!this.isSelectable(t)) continue;
                this.selection.add(t);
            }
        }
    }

    public void unselectAll() {
        this.selection.clear();
    }

    public void toggleSelectAll() {
        if (this.selection.isEmpty()) {
            this.selectAll();
        } else {
            this.unselectAll();
        }
    }

    private void validateSelectable(T t) {
        Validate.isTrue((boolean)this.list.contains(t), (String)"the object that you are trying to select or inquiring about it's selected state is not  in the list\n\tObject: %1$s\n\tList:\n %2$s", (Object[])new Object[]{t, FormattingUtils.collectionToTableString(this.list)});
    }

    private void notifyListeners(T t, boolean selected) {
        for (SelectionListener<T> listener : this.listeners) {
            listener.itemSelected(t, selected);
        }
    }

    public class SelectionWrapperMap
    implements Map<T, Boolean> {
        @Override
        public Boolean get(Object key) {
            return JSFTableModel.this.isSelected(key);
        }

        @Override
        public Boolean put(T key, Boolean value) {
            log.debug("put {}={}", key, (Object)value);
            Validate.notNull((Object)value, (String)"Value can not be null", (Object[])new Object[0]);
            boolean ret = JSFTableModel.this.isSelected(key);
            if (value.booleanValue()) {
                JSFTableModel.this.addSelectedObject(key);
            } else {
                JSFTableModel.this.removeSelectedObject(key);
            }
            return ret;
        }

        @Override
        public int size() {
            return JSFTableModel.this.selection.size();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Map.Entry<T, Boolean>> entrySet() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<T> keySet() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void putAll(Map<? extends T, ? extends Boolean> m) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Boolean remove(Object key) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<Boolean> values() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static interface SelectionFilter<T> {
        public boolean isSelectable(T var1);
    }

    public static interface SelectionListener<T> {
        public void itemSelected(T var1, boolean var2);
    }
}

