/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jpa.eclipselink;

import com.anahata.util.jpa.eclipselink.CopyGroupAttribute;
import com.anahata.util.jpa.eclipselink.CopyGroupFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.sessions.CopyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicCopyGroupFactory
implements CopyGroupFactory {
    private static final Logger log = LoggerFactory.getLogger(BasicCopyGroupFactory.class);
    private final Class baseClass;
    private final Map<Class, Set<CopyGroupAttribute>> attributes;
    private final Map<Class, CopyGroup> predefined;

    BasicCopyGroupFactory(Class baseClass, Map<Class, Set<CopyGroupAttribute>> attributes, Map<Class, CopyGroup> predefined) {
        Validate.notNull((Object)baseClass);
        Validate.notNull(attributes);
        Validate.isTrue((boolean)attributes.keySet().contains(baseClass), (String)"Base class %s not present in attributes", (Object[])new Object[]{baseClass.getSimpleName()});
        this.baseClass = baseClass;
        this.attributes = attributes;
        this.predefined = predefined;
    }

    @Override
    public CopyGroup newInstance() {
        CopyGroup copyGroup;
        long ts = System.currentTimeMillis();
        HashMap<Class, CopyGroup> copyGroups = new HashMap<Class, CopyGroup>();
        for (Class clazz : this.attributes.keySet()) {
            copyGroup = new CopyGroup();
            copyGroups.put(clazz, copyGroup);
        }
        for (Map.Entry entry : this.attributes.entrySet()) {
            copyGroup = (CopyGroup)copyGroups.get(entry.getKey());
            for (CopyGroupAttribute attr : (Set)entry.getValue()) {
                if (attr.getRefClass() == null) {
                    log.trace("Adding simple attribute {}.{}", (Object)((Class)entry.getKey()).getSimpleName(), (Object)attr.getName());
                    copyGroup.addAttribute(attr.getName());
                    continue;
                }
                CopyGroup refCopyGroup = this.predefined.get(attr.getRefClass());
                if (refCopyGroup == null) {
                    log.trace("No predefined copygroup for class " + attr.getRefClass());
                    refCopyGroup = (CopyGroup)copyGroups.get(attr.getRefClass());
                } else {
                    refCopyGroup = refCopyGroup.clone();
                    log.trace("Found predefined copygroup for class {} {}: ", new Object[]{attr.getRefClass(), refCopyGroup.getAttributeNames(), System.identityHashCode(refCopyGroup)});
                }
                Validate.notNull((Object)refCopyGroup, (String)"Could not find copygroup for class: %s", (Object[])new Object[]{attr.getRefClass().getSimpleName()});
                log.trace("Adding copygroup attribute {}.{} to {}.{}", new Object[]{((Class)entry.getKey()).getSimpleName(), attr.getName(), System.identityHashCode(copyGroup), System.identityHashCode(refCopyGroup)});
                copyGroup.addAttribute(attr.getName(), refCopyGroup);
            }
        }
        CopyGroup ret = (CopyGroup)copyGroups.get(this.baseClass);
        ts = System.currentTimeMillis() - ts;
        log.trace("returning cg {} for {} took {}", new Object[]{System.identityHashCode(ret), this.baseClass, ts});
        return ret;
    }
}

