/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jpa.eclipselink;

import com.anahata.util.jpa.JPAPropertyUtils;
import com.anahata.util.jpa.JpaPropertyDescriptor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.queries.AttributeGroup;

public final class AttributeGroupUtils {
    public static AttributeGroup allAttributes(Class c) {
        Validate.notNull((Object)c);
        AttributeGroup att = new AttributeGroup();
        Map<String, JpaPropertyDescriptor> props = JPAPropertyUtils.describe(c);
        att.addAttributes(props.keySet());
        return att;
    }

    public static void addAllAttributes(AttributeGroup att, Class c) {
        Validate.notNull((Object)att);
        Validate.notNull((Object)c);
        Map<String, JpaPropertyDescriptor> props = JPAPropertyUtils.describe(c);
        att.addAttributes(props.keySet());
    }

    public static Set<String> allAttributeNames(Class ... types) {
        HashSet<String> set = new HashSet<String>();
        for (Class c : types) {
            set.addAll(JPAPropertyUtils.describe(c).keySet());
        }
        return set;
    }

    private AttributeGroupUtils() {
    }
}

