/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jpa;

import com.anahata.util.jpa.JPAAnnotationUtils;
import com.anahata.util.jpa.JpaPropertyDescriptor;
import com.anahata.util.reflect.ReflectionUtils;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JPAPropertyUtils {
    private static final Logger log = LoggerFactory.getLogger(JPAPropertyUtils.class);

    public static <T> void updateBasicProperties(T source, T target) {
        Class<?> clazz = source.getClass();
        while (!Object.class.equals(clazz)) {
            for (Field f : clazz.getDeclaredFields()) {
                try {
                    PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor(source, (String)f.getName());
                    if (!JPAPropertyUtils.isBasicUpdatableProperty(clazz, f, pd)) continue;
                    Object val = PropertyUtils.getProperty(source, (String)f.getName());
                    PropertyUtils.setProperty(target, (String)f.getName(), (Object)val);
                    log.trace("{} Updating {} : {}" + source.getClass().getSimpleName(), (Object)pd.getName(), val);
                }
                catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    public static boolean isBasicUpdatableProperty(Class clazz, Field f, PropertyDescriptor pd) throws IntrospectionException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (pd.getReadMethod() == null || pd.getWriteMethod() == null) {
            return false;
        }
        if (f.isAnnotationPresent(Transient.class)) {
            return false;
        }
        if (JPAAnnotationUtils.isId(clazz, f.getName())) {
            return false;
        }
        if (f.getType().isAnnotationPresent(Entity.class)) {
            return false;
        }
        return !Collection.class.isAssignableFrom(f.getType());
    }

    public static Map<String, JpaPropertyDescriptor> describe(Class beanClass) {
        return JPAPropertyUtils.describe(beanClass, false, true, Object.class);
    }

    public static Map<String, JpaPropertyDescriptor> describe(Class beanClass, boolean setterRequired, boolean includeSuper, Class stopClass) {
        Map<String, Field> fields = JPAPropertyUtils.describeDeclaredFields(beanClass, includeSuper, stopClass);
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> propertyDescriptorsByPropertyName = new HashMap<String, PropertyDescriptor>();
            HashMap<String, JpaPropertyDescriptor> ret = new HashMap<String, JpaPropertyDescriptor>(propertyDescriptors.length);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                propertyDescriptorsByPropertyName.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            for (String property : fields.keySet()) {
                Field f;
                Method getter;
                PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptorsByPropertyName.get(property);
                Method setter = pd != null ? pd.getWriteMethod() : null;
                Method method = getter = pd != null ? pd.getReadMethod() : null;
                if (setterRequired && setter == null || (f = fields.get(property)) == null) continue;
                Class[] genericTypes = ReflectionUtils.getGenericArgs(f);
                if (genericTypes == null) {
                    genericTypes = new Class[]{};
                }
                JpaPropertyDescriptor jpaPropertyDescriptor = new JpaPropertyDescriptor(f.getName(), f.getType(), genericTypes);
                for (Annotation annotation : f.getAnnotations()) {
                    jpaPropertyDescriptor.addAnnotation(annotation.annotationType());
                }
                if (getter != null) {
                    for (Annotation annotation : getter.getAnnotations()) {
                        jpaPropertyDescriptor.addAnnotation(annotation.annotationType());
                    }
                }
                if (jpaPropertyDescriptor.isTransient()) continue;
                ret.put(property, jpaPropertyDescriptor);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Field> describeDeclaredFields(Class<?> clazz, boolean includeSuper, Class<?> stopClass) {
        if (stopClass == null) {
            stopClass = Object.class;
        }
        Validate.notNull(clazz, (String)"clazz is required", (Object[])new Object[0]);
        HashMap<String, Field> ret = new HashMap<String, Field>();
        if (stopClass == null || !stopClass.equals(clazz)) {
            Class<?> parent;
            for (Field f : clazz.getDeclaredFields()) {
                if (f.getName().startsWith("_persistence") || Modifier.isStatic(f.getModifiers())) continue;
                ret.put(f.getName(), f);
            }
            if (includeSuper && (parent = clazz.getSuperclass()) != null) {
                ret.putAll(JPAPropertyUtils.describeDeclaredFields(parent, true, stopClass));
            }
        }
        return ret;
    }

    private JPAPropertyUtils() {
    }
}

