/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.io;

import com.anahata.util.plaf.AnahataFilenameUtils;
import com.anahata.util.plaf.OSUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnahataFileUtils {
    private static final Logger log = LoggerFactory.getLogger(AnahataFileUtils.class);

    public static File createTempFile(String name, boolean deleteOnExit) throws IOException {
        return AnahataFileUtils.createTempFile(name, null, deleteOnExit);
    }

    public static File createTempFile(String name, byte[] data, boolean deleteOnExit) throws IOException {
        name = AnahataFilenameUtils.toValidFileName(name);
        File tempDir = FileUtils.getTempDirectory();
        tempDir = new File(tempDir, UUID.randomUUID().toString());
        tempDir.mkdirs();
        if (deleteOnExit) {
            tempDir.deleteOnExit();
        }
        File tempFile = new File(tempDir, name);
        if (deleteOnExit) {
            tempFile.deleteOnExit();
        }
        if (data != null) {
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])data);
        }
        return tempFile;
    }

    public static File createTempDir(String name, boolean unique, boolean deleteOnExit) {
        name = AnahataFilenameUtils.toValidFileName(name);
        File tempDir = FileUtils.getTempDirectory();
        if (unique) {
            tempDir = new File(tempDir, UUID.randomUUID().toString());
            if (deleteOnExit) {
                tempDir.deleteOnExit();
            }
        }
        tempDir = new File(tempDir, name);
        if (deleteOnExit) {
            tempDir.deleteOnExit();
        }
        tempDir.mkdirs();
        return tempDir;
    }

    public static File getApplicationDataDirectory(String appName) {
        File ret = OSUtils.isWindows() ? new File(System.getenv("APPDATA") + File.separator + appName) : (OSUtils.isMac() ? new File(OSUtils.getUserHome() + File.separator + "Library" + File.separator + "Application Support" + File.separator + appName) : new File(OSUtils.getUserHome(), "." + appName));
        ret.mkdirs();
        return ret;
    }

    public static File getAnahataUserDirectory() {
        File f = new File(OSUtils.getUserHome(), ".anahata");
        f.mkdirs();
        return f;
    }

    public static File getAnahataUserDirectory(String name) {
        File f = new File(AnahataFileUtils.getAnahataUserDirectory(), name);
        if (!f.exists()) {
            f.mkdir();
        }
        return f;
    }

    public static File getAnahataAppDataDirectory() {
        File f = AnahataFileUtils.getApplicationDataDirectory("anahata");
        f.mkdirs();
        return f;
    }

    public static File getAnahataAppDataDirectory(String name) {
        File f = new File(AnahataFileUtils.getAnahataAppDataDirectory(), name);
        if (!f.exists()) {
            f.mkdir();
        }
        return f;
    }

    public static byte[] convertToByteArray(String filePath) {
        File file = new File(filePath);
        byte[] b = new byte[(int)file.length()];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            fileInputStream.read(b);
        }
        catch (FileNotFoundException e) {
            log.error("File Not Found {}", (Object)filePath);
        }
        catch (IOException e1) {
            log.error("Error in reading the file {}", (Object)filePath);
        }
        return b;
    }

    public static void deleteFilesOlderThan(File file, Date thresholdDate) {
        Iterator filesToDelete = FileUtils.iterateFiles((File)file, (IOFileFilter)new AgeFileFilter(thresholdDate), null);
        while (filesToDelete.hasNext()) {
            File fileToDelete = (File)filesToDelete.next();
            try {
                log.debug("deleting file filename= {}", (Object)fileToDelete.getName());
                fileToDelete.delete();
            }
            catch (Throwable t) {
                log.error("could not delte file= {}", (Object)fileToDelete.getAbsolutePath(), (Object)t);
            }
        }
    }

    public static String readString(File file, int offset, int length) throws IOException {
        int totalLength = offset + length;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] arr1 = new byte[totalLength];
            AnahataFileUtils.read(fileInputStream, arr1, 0, totalLength);
            byte[] arr2 = ArrayUtils.subarray((byte[])arr1, (int)offset, (int)totalLength);
            String string = new String(arr2, "UTF-8");
            return string;
        }
    }

    public static int read(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count;
        int EOF = -1;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && EOF != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
        }
        return length - remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileOpenedInAnotherProcess(File file) {
        boolean flag = false;
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            FileChannel channel = raf.getChannel();
            FileLock lock = null;
            try {
                lock = channel.tryLock();
            }
            catch (OverlappingFileLockException e) {
                flag = true;
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
        catch (IOException e) {
            flag = true;
        }
        return flag;
    }

    public static long getTotalSize(File fileOrDir) {
        if (fileOrDir.isFile()) {
            return fileOrDir.length();
        }
        return AnahataFileUtils.getTotalSize(Arrays.asList(fileOrDir.listFiles()));
    }

    public static long getTotalSize(Collection<File> files) {
        return files.parallelStream().mapToLong(f -> AnahataFileUtils.getTotalSize(f)).sum();
    }

    public static long getTotalFiles(Collection<File> files) {
        return files.parallelStream().mapToLong(f -> f.isFile() ? 1L : (f.listFiles() != null ? AnahataFileUtils.getTotalFiles(Arrays.asList(f.listFiles())) : 1L)).sum();
    }

    public static void main(String[] args) {
        System.out.println("Total files " + AnahataFileUtils.getTotalFiles(Arrays.asList(new File("/home/pablo/NetBeansProjects"))));
    }

    private AnahataFileUtils() {
    }
}

