/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.error;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public final class StackTraceParser {
    private static final boolean LOG_ENABLED = false;

    public static Throwable parse(List<String> lines) {
        Validate.notNull(lines);
        ArrayList<StackTraceElement> stes = new ArrayList<StackTraceElement>(lines.size() - 1);
        ArrayList<StackTraceDetail> allStes = new ArrayList<StackTraceDetail>();
        int size = lines.size();
        String message = lines.get(0);
        int colonPos = message.indexOf(58);
        String tClass = colonPos >= 0 ? message.substring(0, colonPos) : message;
        for (int i = 1; i < size; ++i) {
            String line = lines.get(i);
            StackTraceParser.log("Processing line: " + line);
            if (line.startsWith("Caused by:")) {
                StackTraceParser.log("Found caused by, adding existing detail");
                allStes.add(new StackTraceDetail(tClass, message, stes));
                message = line;
                tClass = message.substring(message.indexOf(58) + 2);
                stes.clear();
                continue;
            }
            if (line.startsWith("\t... ") || line.indexOf("(") < 0) continue;
            int methodEnd = line.indexOf("(");
            int methodStart = line.substring(0, methodEnd).lastIndexOf(".") + 1;
            int lineNumberStart = line.indexOf(":");
            int lineNumber = -1;
            if (lineNumberStart == -1) {
                if (line.contains("(Native Method)")) {
                    lineNumber = -2;
                }
            } else {
                try {
                    lineNumber = Integer.valueOf(line.substring(lineNumberStart + 1, line.indexOf(")", lineNumberStart)));
                }
                catch (NumberFormatException e) {
                    lineNumber = -1;
                }
            }
            String className = line.substring(4, methodStart - 1);
            String fileName = className.substring(className.lastIndexOf(46) + 1) + ".java";
            String methodName = line.substring(methodStart, methodEnd);
            StackTraceElement ste = new StackTraceElement(className, methodName, fileName, lineNumber);
            stes.add(ste);
        }
        allStes.add(new StackTraceDetail(tClass, message, stes));
        Throwable t = null;
        for (int i = allStes.size() - 1; i >= 0; --i) {
            StackTraceDetail std = (StackTraceDetail)allStes.get(i);
            t = new Throwable(std.getMessage(), t);
            t.fillInStackTrace();
            t.setStackTrace(std.getStes().toArray(new StackTraceElement[std.getStes().size()]));
        }
        return t;
    }

    private static void log(String message) {
    }

    private StackTraceParser() {
    }

    private static class StackTraceDetail {
        private String className;
        private String message;
        private List<StackTraceElement> stes;

        private StackTraceDetail(String className, String message, List<StackTraceElement> stes) {
            this.className = className;
            this.message = message;
            this.stes = new ArrayList<StackTraceElement>(stes);
        }

        public String getClassName() {
            return this.className;
        }

        public String getMessage() {
            return this.message;
        }

        public List<StackTraceElement> getStes() {
            return this.stes;
        }
    }
}

