/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.error;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.anahata.util.config.internal.ErrorEmailConfig;
import com.anahata.util.error.ErrorDetail;
import com.anahata.util.error.ErrorLodgementException;
import com.anahata.util.error.ErrorService;
import com.anahata.util.html.HtmlBuilder;
import com.anahata.util.html.StyleBuilder;
import com.anahata.util.html.TableBuilder;
import com.anahata.util.lang.Nvl;
import com.anahata.util.logging.FxThreadWarning;
import com.anahata.util.logging.PerformanceWarning;
import com.anahata.util.logging.RemoteServiceWarning;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ErrorServiceEmail
implements ErrorService,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(ErrorServiceEmail.class);
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    private static final int WIDTH_DATETIME = 165;
    private static final int WIDTH_USER = 70;
    private static final int WIDTH_THREAD = 80;
    private static final int WIDTH_LEVEL = 50;
    private static final int WIDTH_LOGGER = 250;
    @Inject
    private ErrorEmailConfig config;
    private String bodyStyle;
    private String textStyle;
    private String tableStyle;
    private String headingStyle;
    private String cellStyle;
    private String logCellStyle;
    private String oddCellStyle;
    private String evenCellStyle;
    private String throwableCellStyle;
    private String infoCellStyle;
    private String labelStyle;

    @PostConstruct
    void postConstruct() {
        this.bodyStyle = new StyleBuilder().style("font-family", "Arial").build();
        this.textStyle = new StyleBuilder().stylePx("font-size", 13).build();
        this.tableStyle = new StyleBuilder().style("border-collapse", "collapse").build();
        this.headingStyle = new StyleBuilder().style("font-family", "Arial").stylePx("font-size", 12).style("font-weight", "bold").style("border", "solid 1px #CCCCCC").style("background-color", "#AAAAAA").build();
        this.cellStyle = new StyleBuilder().style("font-family", "Arial").style("vertical-align", "top").stylePx("padding-left", 2).stylePx("padding-right", 2).build();
        this.logCellStyle = new StyleBuilder(this.cellStyle).style("border", "solid 1px #CCCCCC").stylePx("font-size", 11).build();
        this.infoCellStyle = new StyleBuilder(this.cellStyle).stylePx("font-size", 13).build();
        this.labelStyle = new StyleBuilder(this.infoCellStyle).stylePx("width", 130).style("font-weight", "bold").build();
        this.oddCellStyle = new StyleBuilder(this.logCellStyle).style("background-color", "none").build();
        this.evenCellStyle = new StyleBuilder(this.logCellStyle).style("background-color", "#EEEEEE").build();
        this.throwableCellStyle = new StyleBuilder(this.logCellStyle).style("background-color", "#FFD7D7").build();
    }

    @Override
    public void lodge(ErrorDetail error) throws ErrorLodgementException {
        log.debug("Lodging ErrorDetail by email");
        Validate.notNull((Object)error, (String)"error is required", (Object[])new Object[0]);
        try {
            HtmlEmail email = new HtmlEmail();
            email.setHostName(this.config.getErrorEmailHost());
            if (this.config.getErrorEmailSmtpPort() != null) {
                email.setSmtpPort(this.config.getErrorEmailSmtpPort().intValue());
            }
            if (this.config.getErrorEmailUser() != null) {
                email.setAuthentication(this.config.getErrorEmailUser(), this.config.getErrorEmailPassword());
            }
            email.setSSLOnConnect(this.config.isErrorEmailSSL());
            email.setFrom(this.config.getErrorEmailFrom());
            email.setSubject(ErrorServiceEmail.buildSubject(error));
            if (error.getAppUserEmail() != null) {
                email.addReplyTo(error.getAppUserEmail());
            }
            email.setMsg(this.buildMessage(error, email));
            email.addTo(this.config.getErrorEmailTo());
            if (!StringUtils.isBlank((CharSequence)this.config.getErrorEmailCc())) {
                email.addCc(this.config.getErrorEmailCc());
            }
            if (!StringUtils.isEmpty((CharSequence)error.getUserComments())) {
                email.addHeader("X-Priority", "1 (Highest)");
            }
            log.debug("Sending error email to {}", (Object)this.config.getErrorEmailTo());
            email.send();
            log.debug("error email sent to {}", (Object)this.config.getErrorEmailTo());
        }
        catch (EmailException e) {
            throw new ErrorLodgementException("Exception sending error email using " + this.config, e);
        }
    }

    private static String buildSubject(ErrorDetail error) throws ErrorLodgementException {
        String subjectPreffix = "";
        if (!StringUtils.isEmpty((CharSequence)error.getUserComments()) && !StringUtils.isEmpty((CharSequence)error.getUserName())) {
            subjectPreffix = subjectPreffix + "[" + error.getUserName() + "]";
        }
        return subjectPreffix + error.getMessage();
    }

    private String buildMessage(ErrorDetail error, HtmlEmail email) throws ErrorLodgementException {
        InetAddress localIpAddress = error.getLocalIpAddress();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN);
        HtmlBuilder hb = new HtmlBuilder().style(this.bodyStyle).span(this.textStyle, "Error encountered. Details:").br().br().body(new TableBuilder().style(this.tableStyle).trTdLabelValue(this.labelStyle, "Date / Time", this.infoCellStyle, dateFormat.format(error.getCreated())).trTdLabelValue(this.labelStyle, "Application", this.infoCellStyle, error.getApplicationName()).trTdLabelValue(this.labelStyle, "Version", this.infoCellStyle, error.getApplicationVersion()).trTdLabelValue(this.labelStyle, "Environment", this.infoCellStyle, (Object)error.getApplicationEnv()).trTdLabelValue(this.labelStyle, "Memory", this.infoCellStyle, error.getMemStats()).trTdLabelValue(this.labelStyle, "Device", this.infoCellStyle, error.getDevice()).trTdLabelValue(this.labelStyle, "Application User", this.infoCellStyle, error.getAppUserName()).trTdLabelValue(this.labelStyle, "Local IP Address", this.infoCellStyle, localIpAddress == null ? null : localIpAddress.getHostAddress()).trTdLabelValue(this.labelStyle, "Local Host Name", this.infoCellStyle, localIpAddress == null ? null : localIpAddress.getHostName()).trTdLabelValue(this.labelStyle, "External IP Address", this.infoCellStyle, error.getExternalIpAddress()).trTdLabelValue(this.labelStyle, "Java Vendor", this.infoCellStyle, error.getJavaVendor()).trTdLabelValue(this.labelStyle, "Java Version", this.infoCellStyle, error.getJavaVersion()).trTdLabelValue(this.labelStyle, "JavaFX Version", this.infoCellStyle, error.getJavaFxVersion()).trTdLabelValue(this.labelStyle, "OS Name", this.infoCellStyle, error.getOsName()).trTdLabelValue(this.labelStyle, "OS Version", this.infoCellStyle, error.getOsVersion()).trTdLabelValue(this.labelStyle, "OS Architecture", this.infoCellStyle, error.getOsArchitecture()).trTdLabelValue(this.labelStyle, "OS User", this.infoCellStyle, error.getUserName()).trTdLabelValue(this.labelStyle, "OS User Home Dir", this.infoCellStyle, error.getUserHome()).trTdLabelValue(this.labelStyle, "OS User Working Dir", this.infoCellStyle, error.getUserWorking()).trTdLabelValue(this.labelStyle, "User Comments", this.infoCellStyle, error.getUserComments()).build()).br();
        if (error.canSendScreenshot()) {
            log.debug("sending {} screenshots {}", (Object)error.getScreenshots().size());
            for (int i = 0; i < error.getScreenshots().size(); ++i) {
                int idx = i + 1;
                log.debug("attaching screenshot {}", (Object)idx);
                hb.span(this.textStyle, "Screenshot-" + idx).br().br();
                StringBuilder sb = new StringBuilder();
                sb.append("<img src=cid:");
                try {
                    sb.append(email.embed((DataSource)new PngDataSource("ErrorScreenshot-" + idx + ".png", error.getScreenshots().get(i)), "Error Screenshot-" + idx));
                }
                catch (EmailException e) {
                    throw new ErrorLodgementException(e);
                }
                sb.append(" />");
                hb.body(sb.toString());
                hb.br().br();
            }
        } else {
            log.debug("Not sending screenshot ");
        }
        if (error.getEvents() != null) {
            hb.span(this.textStyle, "Log trace:").br().br();
            TableBuilder tb = new TableBuilder().style(this.tableStyle).th(this.headingStyle(165), "Date / Time");
            boolean server = "Server".equalsIgnoreCase(error.getDevice());
            if (server) {
                tb.th(this.headingStyle(70), "User");
            }
            tb.th(this.headingStyle, "Thread").th(this.headingStyle(50), "Level").th(this.headingStyle(250), "Logger").th(this.headingStyle, "Message");
            boolean white = true;
            for (ILoggingEvent event : error.getEvents()) {
                String user = Nvl.nvl((String)event.getMDCPropertyMap().get("user"));
                String style = white ? this.oddCellStyle : this.evenCellStyle;
                tb.tr().td(this.style(style, 165), dateFormat.format(new Date(event.getTimeStamp())));
                if (server) {
                    tb.td(this.style(style, 70), user);
                }
                tb.td(this.style(style, 80), StringUtils.trim((String)event.getThreadName())).td(this.style(style, 50), StringUtils.trim((String)event.getLevel().toString())).td(this.style(style, 250), StringUtils.trim((String)event.getLoggerName())).td(style, StringUtils.trim((String)event.getFormattedMessage()));
                IThrowableProxy throwableProxy = event.getThrowableProxy();
                if (throwableProxy != null) {
                    Throwable throwable = ((ThrowableProxy)throwableProxy).getThrowable();
                    tb.tr().td(this.throwableCellStyle, this.pre(throwable), server ? 6 : 5);
                }
                white = !white;
            }
            hb.body(tb.build());
        } else {
            hb.span(this.textStyle, "No log trace was present.");
        }
        int fxCurrent = 0;
        int current = 0;
        if (!error.getPerformanceWarnings().isEmpty()) {
            for (PerformanceWarning warn : error.getPerformanceWarnings()) {
                hb.hr();
                hb.h2("Performance Item #" + ++current + "/" + error.getPerformanceWarnings().size());
                hb.span(warn.getTimestamp().toString());
                if (warn instanceof FxThreadWarning) {
                    ++fxCurrent;
                    FxThreadWarning fxWarn = (FxThreadWarning)warn;
                    TableBuilder beforeAfter = new TableBuilder().style(this.tableStyle).th(this.headingStyle, "Upon detection").th(this.headingStyle, "After (" + fxWarn.getUnresponsiveTime() + " ms.)");
                    beforeAfter.tr();
                    int monitor = 0;
                    StringBuilder before = new StringBuilder();
                    for (byte[] byArray : fxWarn.getBefore()) {
                        before.append("Monitor ").append(++monitor);
                        before.append("<br/>");
                        before.append(this.embedImage(email, byArray, "FxThreadUnresponsive-" + fxCurrent + "-monitor-" + monitor + "-before"));
                    }
                    beforeAfter.td(before.toString());
                    monitor = 0;
                    StringBuilder after = new StringBuilder();
                    for (byte[] barr3 : fxWarn.getAfter()) {
                        after.append("Monitor ").append(++monitor);
                        after.append("<br/>");
                        after.append(this.embedImage(email, barr3, "FxThreadUnresponsive-" + fxCurrent + "-monitor-" + monitor + "-after"));
                    }
                    beforeAfter.td(after.toString());
                    hb.body(beforeAfter.build());
                    hb.span(this.labelStyle, "Fx Thread Stack Traces");
                    TableBuilder tableBuilder = new TableBuilder().style(this.tableStyle).th(this.headingStyle(165), "Date / Time").th(this.headingStyle, "Unresponsive time").th(this.headingStyle, "Stack Trace");
                    int snapCount = 0;
                    for (FxThreadWarning.FxThreadSnapshot snap : fxWarn.getFxThreadSnapshots()) {
                        tableBuilder.tr();
                        String style = snapCount % 2 == 0 ? this.oddCellStyle : this.evenCellStyle;
                        tableBuilder.td(style, warn.getTimestamp().toString());
                        tableBuilder.td(style, snap.getUnresponsiveTime() + " ms.");
                        tableBuilder.td(style, snap.stackTraceHtml());
                    }
                    hb.body(tableBuilder.build());
                    hb.h3("After");
                    hb.br();
                    continue;
                }
                if (!(warn instanceof RemoteServiceWarning)) continue;
                RemoteServiceWarning rsWarn = (RemoteServiceWarning)warn;
                String mainDetails = new TableBuilder().trTdLabelValue(this.labelStyle, "Class.Method", this.infoCellStyle, rsWarn.getClassName() + "." + rsWarn.getMethodName()).trTdLabelValue(this.labelStyle, "Reasons", this.infoCellStyle, rsWarn.getReasons().toString()).trTdLabelValue(this.labelStyle, "Round Trip time", this.infoCellStyle, rsWarn.getTime() + " ms.").build();
                TableBuilder tb = new TableBuilder().style(this.tableStyle).th(this.headingStyle(165), "Details").th(this.headingStyle, "Request Payload").th(this.headingStyle, "Response Payload");
                tb.tr().td(this.cellStyle, mainDetails).td(this.cellStyle, FileUtils.byteCountToDisplaySize((long)rsWarn.getArgsSize()) + "<br/>" + rsWarn.getArgsString()).td(this.cellStyle, FileUtils.byteCountToDisplaySize((long)rsWarn.getRetSize()) + " b<br/>" + rsWarn.getRetString());
                hb.body(tb.build());
            }
        }
        return hb.build();
    }

    private String embedImage(HtmlEmail email, byte[] barr, String name) throws ErrorLodgementException {
        StringBuilder sb = new StringBuilder();
        sb.append("<img src=cid:");
        try {
            sb.append(email.embed((DataSource)new PngDataSource(name + ".png", barr), name));
        }
        catch (EmailException e) {
            throw new ErrorLodgementException(e);
        }
        sb.append(" />");
        return sb.toString();
    }

    private String pre(Throwable throwable) {
        return "<pre>" + ExceptionUtils.getStackTrace((Throwable)throwable) + "</pre>";
    }

    private String style(String baseStyle, int width) {
        return new StyleBuilder(baseStyle).stylePx("width", width).build();
    }

    private String headingStyle(int width) {
        return this.style(this.headingStyle, width);
    }

    private static class PngDataSource
    implements DataSource {
        private final String name;
        private final byte[] data;
        private long maxSize;

        public PngDataSource(String name, byte[] data, long maxSize) {
            this.name = name;
            this.data = data;
            this.maxSize = maxSize;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException("Not supported");
        }

        public String getContentType() {
            return "image/png";
        }

        @ConstructorProperties(value={"name", "data"})
        public PngDataSource(String name, byte[] data) {
            this.name = name;
            this.data = data;
        }

        public String getName() {
            return this.name;
        }
    }
}

