/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.config.internal;

import com.anahata.util.config.internal.ApplicationPropertiesFactory;
import com.anahata.util.props.StructuredProperties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class ErrorEmailConfig {
    private static final String PROPS_PREFIX = "erroremail";
    @Inject
    private ApplicationPropertiesFactory appProps;
    private String errorEmailHost;
    private Integer errorEmailSmtpPort;
    private boolean errorEmailSSL;
    private String errorEmailUser;
    private String errorEmailPassword;
    private String errorEmailFrom;
    private String errorEmailTo;
    private String errorEmailCc;

    @PostConstruct
    void postConstruct() {
        StructuredProperties props = new StructuredProperties(this.appProps.getAppProperties(), "anahatautil", PROPS_PREFIX);
        this.errorEmailHost = props.getString("host");
        this.errorEmailSmtpPort = props.getInteger("smtpport", null);
        this.errorEmailSSL = props.getBoolean("ssl", false);
        this.errorEmailUser = props.getString("user", null);
        this.errorEmailPassword = props.getString("password", null);
        this.errorEmailFrom = props.getString("from");
        this.errorEmailTo = props.getString("to");
        this.errorEmailCc = props.getString("cc", null);
    }

    public String toString() {
        return "ErrorEmailConfig{errorEmailHost=" + this.errorEmailHost + ", errorEmailSmtpPort=" + this.errorEmailSmtpPort + ", errorEmailSSL=" + this.errorEmailSSL + ", errorEmailUser=" + this.errorEmailUser + ", errorEmailPassword=" + this.errorEmailPassword + ", errorEmailFrom=" + this.errorEmailFrom + ", errorEmailTo=" + this.errorEmailTo + '}';
    }

    public ApplicationPropertiesFactory getAppProps() {
        return this.appProps;
    }

    public String getErrorEmailHost() {
        return this.errorEmailHost;
    }

    public Integer getErrorEmailSmtpPort() {
        return this.errorEmailSmtpPort;
    }

    public boolean isErrorEmailSSL() {
        return this.errorEmailSSL;
    }

    public String getErrorEmailUser() {
        return this.errorEmailUser;
    }

    public String getErrorEmailPassword() {
        return this.errorEmailPassword;
    }

    public String getErrorEmailFrom() {
        return this.errorEmailFrom;
    }

    public String getErrorEmailTo() {
        return this.errorEmailTo;
    }

    public String getErrorEmailCc() {
        return this.errorEmailCc;
    }
}

