/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.concurrent;

import com.anahata.util.validation.ValidationUtils;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private Class loggerClass;

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String details = ValidationUtils.getConstraintValidationDetails(e);
        String mssg = "Uncaught Exception on thread " + t.getName();
        if (details != null) {
            mssg = mssg + ". ConstraintValidations: " + details;
        }
        Logger logger = LoggerFactory.getLogger((Class)this.loggerClass);
        logger.error(mssg, e);
    }

    @ConstructorProperties(value={"loggerClass"})
    public BasicUncaughtExceptionHandler(Class loggerClass) {
        this.loggerClass = loggerClass;
    }
}

