/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.awt;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AWTUtils {
    private static final Logger log = LoggerFactory.getLogger(AWTUtils.class);

    public static List<byte[]> snapshotAllMonitors() {
        return AWTUtils.snapshotAllMonitors(null);
    }

    public static List<byte[]> snapshotAllMonitors(Integer maxSize) {
        long ts = System.currentTimeMillis();
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : ge.getScreenDevices()) {
            try {
                log.debug("Taking snapshot of: {}, conf =", (Object)gd, (Object)gd.getDefaultConfiguration().getBounds());
                Robot r = new Robot(gd);
                BufferedImage bi = r.createScreenCapture(gd.getDefaultConfiguration().getBounds());
                if (maxSize != null) {
                    bi = Scalr.resize((BufferedImage)bi, (Scalr.Method)Scalr.Method.SPEED, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)maxSize, (BufferedImageOp[])new BufferedImageOp[0]);
                }
                ret.add(AWTUtils.toPNG(bi));
            }
            catch (Exception e) {
                log.warn("Could not take screenshot", (Throwable)e);
            }
        }
        ts = System.currentTimeMillis() - ts;
        log.info("snapshotAllMonitors maxSize={} took{}", (Object)maxSize, (Object)ts);
        return ret;
    }

    public static byte[] toPNG(BufferedImage bi) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bi, "png", os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] result = os.toByteArray();
        return result;
    }

    public static void main(String[] args) {
        AWTUtils.snapshotAllMonitors();
    }

    private AWTUtils() {
    }
}

