/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.search;

import java.io.Serializable;
import org.apache.commons.lang3.Validate;

public abstract class AbstractSearchRequest
implements Serializable {
    private boolean includeDeleted;
    private Enum sortKey;
    private boolean sortAscending;
    private boolean matchAllTokens;
    private boolean expandSearch = true;
    private int startPage = 0;
    private int pageSize = 100;

    public void setPageSize(int pageSize) {
        Validate.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"pageSize must be > 0", (Object[])new Object[0]);
        this.pageSize = pageSize;
    }

    public void setStartPage(int startPage) {
        Validate.isTrue((startPage >= 0 ? 1 : 0) != 0, (String)"startPage must be >= 0", (Object[])new Object[0]);
        this.startPage = startPage;
    }

    public int getStartIndex() {
        return this.pageSize * this.startPage;
    }

    public boolean isIncludeDeleted() {
        return this.includeDeleted;
    }

    public Enum getSortKey() {
        return this.sortKey;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public boolean isMatchAllTokens() {
        return this.matchAllTokens;
    }

    public boolean isExpandSearch() {
        return this.expandSearch;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setIncludeDeleted(boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    public void setSortKey(Enum sortKey) {
        this.sortKey = sortKey;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public void setMatchAllTokens(boolean matchAllTokens) {
        this.matchAllTokens = matchAllTokens;
    }

    public void setExpandSearch(boolean expandSearch) {
        this.expandSearch = expandSearch;
    }

    public String toString() {
        return "AbstractSearchRequest(includeDeleted=" + this.isIncludeDeleted() + ", sortKey=" + this.getSortKey() + ", sortAscending=" + this.isSortAscending() + ", matchAllTokens=" + this.isMatchAllTokens() + ", expandSearch=" + this.isExpandSearch() + ", startPage=" + this.getStartPage() + ", pageSize=" + this.getPageSize() + ")";
    }
}

