/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.transport.rpc;

import com.anahata.util.cdi.Cdi;
import com.anahata.util.io.AnahataCompressionUtils;
import com.anahata.util.io.AnahataSerializationUtils;
import com.anahata.util.io.CompressionType;
import com.anahata.util.io.SerializationType;
import com.anahata.util.transport.rpc.RpcStreamer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Rpc
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Rpc.class);
    private static final Map<String, Class<?>> primitiveClasses = new HashMap();
    private final String clazzName;
    private final String methodName;
    private final String[] methodParamTypeNames;
    private final Object[] args;
    private transient Class clazz = null;
    private transient Method method = null;
    private transient Class[] methodParamTypes = null;
    private transient Object[] checkedArgs = null;

    public Rpc(Method method, Object[] args) {
        this(method.getDeclaringClass(), method, args);
    }

    public Rpc(Class clazz, Method method, Object[] args) {
        this.clazz = clazz;
        this.clazzName = clazz.getName();
        this.method = method;
        this.methodName = method.getName();
        this.methodParamTypes = method.getParameterTypes();
        this.methodParamTypeNames = new String[method.getParameterTypes().length];
        for (int i = 0; i < this.methodParamTypeNames.length; ++i) {
            this.methodParamTypeNames[i] = Rpc.className(method.getParameterTypes()[i]);
        }
        this.args = args;
        this.checkedArgs = args;
    }

    public Class getClazz() {
        if (this.clazz != null) {
            return this.clazz;
        }
        try {
            this.clazz = Class.forName(this.clazzName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class " + this.clazzName, e);
        }
        return this.clazz;
    }

    public Method getMethod() throws NoSuchMethodException, ClassNotFoundException {
        if (this.method != null) {
            return this.method;
        }
        Class loadedClazz = this.getClazz();
        log.trace("Class {}, ", (Object)loadedClazz);
        log.trace("Parameter Types {}, ", (Object[])this.getMethodParamTypes());
        log.trace("Method name {}, ", (Object)this.methodName);
        this.method = MethodUtils.getAccessibleMethod((Class)loadedClazz, (String)this.methodName, (Class[])this.getMethodParamTypes());
        Validate.notNull((Object)this.method, (String)"Could not find accessible method for %s.%s %s", (Object[])new Object[]{this.getClazz(), this.methodName, this.getMethodParamTypes()});
        log.trace("Method {}, ", (Object)this.method);
        return this.method;
    }

    private Class[] getMethodParamTypes() {
        if (this.methodParamTypes != null) {
            return this.methodParamTypes;
        }
        Class[] ret = new Class[this.methodParamTypeNames.length];
        for (int i = 0; i < this.methodParamTypeNames.length; ++i) {
            try {
                ret[i] = Rpc.loadClass(this.methodParamTypeNames[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        this.methodParamTypes = ret;
        return ret;
    }

    public Object[] getArgs() {
        if (this.args == null) {
            return this.args;
        }
        if (this.checkedArgs != null) {
            return this.checkedArgs;
        }
        Object[] ret = new Object[this.args.length];
        Class[] paramTypes = this.getMethodParamTypes();
        for (int i = 0; i < this.args.length; ++i) {
            Object arg = this.args[i];
            if (arg != null) {
                Class type = paramTypes[i];
                if (arg.getClass() != type) {
                    arg = arg.getClass() == String.class && type == char[].class ? (Object)((String)arg).toCharArray() : ConvertUtils.convert((Object)arg, (Class)type);
                }
            }
            ret[i] = arg;
        }
        this.checkedArgs = ret;
        return this.checkedArgs;
    }

    public Object invoke(Object target) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.getMethod().invoke(target, this.getArgs());
    }

    public String toString() {
        return "RpcRequest{clazzName=" + this.clazzName + ", methodName=" + this.methodName + ", methodParamTypeNames=" + Arrays.toString(this.methodParamTypeNames) + ", args=" + Arrays.toString(this.args) + '}';
    }

    private static Class<?> loadClass(String name) throws ClassNotFoundException {
        if (primitiveClasses.containsKey(name)) {
            return primitiveClasses.get(name);
        }
        return Class.forName(name);
    }

    private static String className(Class clazz) {
        Set<Map.Entry<String, Class<?>>> set = primitiveClasses.entrySet();
        for (Map.Entry<String, Class<?>> entry : set) {
            if (entry.getValue() != clazz) continue;
            return entry.getKey();
        }
        return clazz.getName();
    }

    public static Rpc parse(Message message) throws JMSException, IOException, CompressorException {
        RpcStreamer streamer = Cdi.get(RpcStreamer.class, new Annotation[0]);
        CompressionType compression = AnahataCompressionUtils.readHeader(message);
        SerializationType serialization = AnahataSerializationUtils.readHeader(message);
        streamer.setCompressionType(compression);
        streamer.setSerializationType(serialization);
        BytesMessage bytesMessage = (BytesMessage)message;
        log.trace("BodyLength: {}", (Object)bytesMessage.getBodyLength());
        byte[] barr = new byte[(int)bytesMessage.getBodyLength()];
        bytesMessage.readBytes(barr);
        log.trace("received bytes {} ", (Object)barr);
        Rpc rpc = (Rpc)streamer.uncompressDeserialize(barr);
        return rpc;
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getMethodParamTypeNames() {
        return this.methodParamTypeNames;
    }

    public Object[] getCheckedArgs() {
        return this.checkedArgs;
    }

    static {
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("byte[]", byte[].class);
        primitiveClasses.put("short", Short.TYPE);
        primitiveClasses.put("short[]", short[].class);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("char[]", char[].class);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("int[]", int[].class);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("long[]", long[].class);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("float[]", float[].class);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("double[]", double[].class);
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("boolean[]", boolean[].class);
    }
}

