/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.search;

import com.anahata.util.search.SearchCriteria;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;

public class SearchResults<T>
implements Serializable {
    private SearchCriteria criteria;
    private long totalCount;
    private List<T> page;

    public int getTotalPages() {
        return (int)Math.ceil((float)this.totalCount / (float)this.criteria.getPageSize());
    }

    public <C extends SearchCriteria> C getCriteriaTyped() {
        return (C)this.criteria;
    }

    public SearchCriteria getCriteria() {
        return this.criteria;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public List<T> getPage() {
        return this.page;
    }

    public void setCriteria(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public void setPage(List<T> page) {
        this.page = page;
    }

    public String toString() {
        return "SearchResults(criteria=" + this.getCriteria() + ", totalCount=" + this.getTotalCount() + ", page=" + this.getPage() + ")";
    }

    @ConstructorProperties(value={"criteria", "totalCount", "page"})
    public SearchResults(SearchCriteria criteria, long totalCount, List<T> page) {
        this.criteria = criteria;
        this.totalCount = totalCount;
        this.page = page;
    }
}

