/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.anahata.util.cdi.Cdi;
import com.anahata.util.logging.logback.ErrorEvent;
import com.anahata.util.logging.logback.ErrorEventAppender;
import java.util.ArrayList;
import javax.ejb.Asynchronous;
import javax.ejb.Singleton;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.inject.Inject;

@Singleton
public class ErrorEventAppenderMonitor {
    @Inject
    @Any
    private Event<ErrorEvent> errorEvent;
    private ErrorEventAppender appender;

    @Asynchronous
    public void processError(@Observes ErrorEventAppender appender) {
        this.appender = appender;
        if (Cdi.isSe()) {
            new JavaSeMonitor().start();
        } else {
            this.process();
        }
    }

    private void process() {
        boolean found;
        long currTs = System.currentTimeMillis();
        boolean bl = found = this.appender.getState() == ErrorEventAppender.State.FOUND;
        while (this.appender.getState() == ErrorEventAppender.State.FOUND && currTs - this.appender.getLastLogTs() < this.appender.getErrorTimeout()) {
            found = true;
            try {
                Thread.sleep(this.appender.getErrorTimeout());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            currTs = System.currentTimeMillis();
        }
        this.appender.setState(ErrorEventAppender.State.SEARCHING);
        if (found) {
            this.errorEvent.fire((Object)new ErrorEvent(new ArrayList<ILoggingEvent>(this.appender.getLogBuffer())));
        }
    }

    private class JavaSeMonitor
    extends Thread {
        private JavaSeMonitor() {
        }

        @Override
        public void run() {
            ErrorEventAppenderMonitor.this.process();
        }
    }
}

