/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging;

import com.anahata.util.logging.PerformanceWarning;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FxThreadWarning
extends PerformanceWarning {
    private static final Logger log = LoggerFactory.getLogger(FxThreadWarning.class);
    private final List<FxThreadSnapshot> fxThreadSnapshots = new ArrayList<FxThreadSnapshot>();
    private List<byte[]> before;
    private List<byte[]> after;
    private Long unresponsiveTime;

    public void addSnapshot(long unresponsiveTime, StackTraceElement[] trace) {
        this.fxThreadSnapshots.add(new FxThreadSnapshot(unresponsiveTime, trace));
    }

    public String toString() {
        return "FxThreadWarning{" + super.getTimestamp() + " fxThreadSnapshots=" + this.fxThreadSnapshots.size() + ", unresponsiveTime=" + this.unresponsiveTime + '}';
    }

    public List<FxThreadSnapshot> getFxThreadSnapshots() {
        return this.fxThreadSnapshots;
    }

    public List<byte[]> getBefore() {
        return this.before;
    }

    public List<byte[]> getAfter() {
        return this.after;
    }

    public Long getUnresponsiveTime() {
        return this.unresponsiveTime;
    }

    public void setBefore(List<byte[]> before) {
        this.before = before;
    }

    public void setAfter(List<byte[]> after) {
        this.after = after;
    }

    public void setUnresponsiveTime(Long unresponsiveTime) {
        this.unresponsiveTime = unresponsiveTime;
    }

    public FxThreadWarning() {
    }

    @ConstructorProperties(value={"before", "after", "unresponsiveTime"})
    public FxThreadWarning(List<byte[]> before, List<byte[]> after, Long unresponsiveTime) {
        this.before = before;
        this.after = after;
        this.unresponsiveTime = unresponsiveTime;
    }

    public static class FxThreadSnapshot {
        private long unresponsiveTime;
        protected StackTraceElement[] trace;

        public String stackTraceHtml() {
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement stackTraceElement : this.trace) {
                sb.append("at ");
                sb.append(stackTraceElement.toString());
                sb.append("<br/>");
            }
            return sb.toString();
        }

        @ConstructorProperties(value={"unresponsiveTime", "trace"})
        public FxThreadSnapshot(long unresponsiveTime, StackTraceElement[] trace) {
            this.unresponsiveTime = unresponsiveTime;
            this.trace = trace;
        }

        public long getUnresponsiveTime() {
            return this.unresponsiveTime;
        }

        public StackTraceElement[] getTrace() {
            return this.trace;
        }
    }
}

