/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jsf;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(servletNames={"Faces Servlet"}, description="Disable browser caching of JSF pages")
public class CacheFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CacheFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpResp = (HttpServletResponse)response;
        if (!httpReq.getRequestURI().startsWith(httpReq.getContextPath() + "/javax.faces.resource")) {
            log.debug("Disabling filter");
            httpResp.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            httpResp.setHeader("Pragma", "no-cache");
            httpResp.setDateHeader("Expires", 0L);
        }
        try {
            chain.doFilter(request, response);
        }
        catch (IOException | ServletException e) {
            log.error("Unhandled error encountered", e);
            throw e;
        }
    }

    public void destroy() {
    }
}

